/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.governance;

import com.dataiku.dip.llm.online.LLMClient;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.python.icu.text.BreakIterator;

public class SentenceBufferingStreamFilter
implements LLMClient.StreamedCompletionResponseConsumer {
    private StringBuilder sb = new StringBuilder();
    private final LLMClient.StreamedCompletionResponseConsumer consumer;

    public SentenceBufferingStreamFilter(LLMClient.StreamedCompletionResponseConsumer consumer) {
        this.consumer = consumer;
    }

    @Override
    public void onStreamStarted() throws Exception {
    }

    @Override
    public void onStreamChunk(LLMClient.StreamedCompletionResponseChunk chunk) throws Exception {
        if ("event".equals(chunk.type)) {
            this.flushBuffer();
            this.consumer.onStreamChunk(chunk);
        } else if (chunk.toolCalls != null) {
            this.flushBuffer();
            this.consumer.onStreamChunk(chunk);
        } else if (chunk.text == null) {
            this.flushBuffer();
            this.consumer.onStreamChunk(chunk);
        } else {
            this.sb.append(chunk.text);
            this.evaluateSentenceEmit();
        }
    }

    @Override
    public void onStreamComplete(LLMClient.StreamedCompletionResponseFooter footer) throws Exception {
        this.flushBuffer();
        this.consumer.onStreamComplete(footer);
    }

    private void evaluateSentenceEmit() throws Exception {
        if (this.sb.length() == 0) {
            return;
        }
        List<String> sentences = this.getSentences();
        if (sentences.size() < 2) {
            return;
        }
        while (sentences.size() >= 2) {
            String sentence = sentences.remove(0);
            if (sentence.trim().isEmpty()) continue;
            this.emitChunk(sentence);
        }
        this.sb.setLength(0);
        for (String sentence : sentences) {
            this.sb.append(sentence);
        }
    }

    private List<String> getSentences() {
        ArrayList<String> sentences = new ArrayList<String>();
        BreakIterator iterator = BreakIterator.getSentenceInstance((Locale)Locale.ROOT);
        String text = this.sb.toString();
        iterator.setText(text);
        int start = iterator.first();
        int end = iterator.next();
        while (end != -1) {
            String sentence = text.substring(start, end);
            if (!sentence.isEmpty()) {
                sentences.add(sentence);
            }
            start = end;
            end = iterator.next();
        }
        return sentences;
    }

    private void flushBuffer() throws Exception {
        if (this.sb.length() > 0) {
            this.emitChunk(this.sb.toString());
            this.sb.setLength(0);
        }
    }

    private void emitChunk(String text) throws Exception {
        LLMClient.StreamedCompletionResponseChunk chunk = new LLMClient.StreamedCompletionResponseChunk();
        chunk.type = "content";
        chunk.text = text;
        this.consumer.onStreamChunk(chunk);
    }
}

