/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.online;

import com.dataiku.dip.connections.AbstractLLMConnection;
import com.dataiku.dip.llm.utils.OnlineLLMUtils;
import com.dataiku.dss.shadelib.com.google.api.client.util.BackOff;

public class ConfigurableOnlineLLMBackOff
implements BackOff {
    private int executionCount = 1;
    private final AbstractLLMConnection.HTTPBasedLLMNetworkSettings networkSettings;

    public ConfigurableOnlineLLMBackOff(AbstractLLMConnection.HTTPBasedLLMNetworkSettings networkSettings) {
        this.networkSettings = networkSettings;
    }

    public void reset() {
        this.executionCount = 1;
    }

    public long nextBackOffMillis() {
        if (this.executionCount > this.networkSettings.maxRetries) {
            return -1L;
        }
        return OnlineLLMUtils.backoffDelay(this.networkSettings, ++this.executionCount);
    }
}

