/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.online.bedrock.converse;

import com.dataiku.dip.llm.online.LLMClient;
import com.dataiku.dip.llm.online.bedrock.RawBedrockClient;
import com.dataiku.dip.llm.online.bedrock.converse.ConverseChatChunkResponseAdapter;
import com.dataiku.dip.llm.online.bedrock.converse.ConverseChatQueryAdapter;
import com.dataiku.dip.llm.online.bedrock.converse.ConverseChatResponseAdapter;
import com.dataiku.dip.llm.online.marshall.CoreCompletionSettings;
import com.dataiku.dip.llm.online.marshall.CoreCompletionSettingsValidator;
import com.dataiku.dip.llm.online.sagemakergeneric.GenericLLMHandling;
import com.dataiku.dip.llm.online.sagemakergeneric.GenericTextCompletionLLMMarshall;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.bedrockruntime.model.ConverseRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.bedrockruntime.model.ConverseResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.bedrockruntime.model.ConverseStreamOutput;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.bedrockruntime.model.ConverseStreamRequest;
import java.util.List;

public class ConverseAPILLMMarshall {
    private final GenericLLMHandling handling;
    private final CoreCompletionSettingsValidator validator = new CoreCompletionSettingsValidator("Bedrock Converse").allowMaxTokens().allowTemperature().allowTopP().allowStopSequences().allowTools();

    public ConverseAPILLMMarshall(GenericLLMHandling handling) {
        this.handling = handling;
        switch (handling) {
            case AMAZON_NOVA: 
            case ANTHROPIC_CLAUDE_CHAT: 
            case ANTHROPIC_CLAUDE: 
            case MISTRAL_AI: {
                this.validator.allowTopK();
                break;
            }
            case COHERE_COMMAND_CHAT: {
                this.validator.allowTopK().allowFrequencyPenalty().allowPresencePenalty();
            }
        }
    }

    public ConverseRequest prepareChatCompletionQuery(List<LLMClient.ChatMessage> messages, RawBedrockClient.Settings settings, CoreCompletionSettings ccs) {
        this.validator.validate(ccs);
        return ConverseChatQueryAdapter.adapt(messages, settings, ccs);
    }

    public ConverseStreamRequest prepareChatCompletionStreamingQuery(List<LLMClient.ChatMessage> messages, RawBedrockClient.Settings settings, CoreCompletionSettings ccs) {
        this.validator.validate(ccs);
        return ConverseChatQueryAdapter.adaptStreaming(messages, settings, ccs);
    }

    public LLMClient.SimpleCompletionResponse parseChatCompletionResponse(ConverseResponse response) {
        return ConverseChatResponseAdapter.adapt(response);
    }

    public GenericTextCompletionLLMMarshall.EnrichedStreamedCompletionResponseChunk parseChatCompletionChunk(ConverseStreamOutput chunk) {
        return ConverseChatChunkResponseAdapter.adapt(chunk.sdkEventType(), chunk);
    }
}

