/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.meanings;

import com.dataiku.dip.meanings.MeaningsDAO;
import com.dataiku.dip.meanings.model.UserDefinedMeaning;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class FilesBasedMeaningsDAO
implements MeaningsDAO {
    private Logger logger = Logger.getLogger((String)"dku.meanings.dao");

    @Override
    public List<UserDefinedMeaning> listUnsafe() throws IOException {
        TransactionRef tr = TransactionContext.retrieveRead();
        RelFile rf = RelFile.global((String)"meanings");
        ArrayList<UserDefinedMeaning> ret = new ArrayList<UserDefinedMeaning>();
        if (tr.isDirectory(rf)) {
            for (RelFile f : tr.listFiles(rf)) {
                if (!f.getLeafName().endsWith(".json")) continue;
                try {
                    UserDefinedMeaning udm = (UserDefinedMeaning)tr.readObjectUnsafe(f, UserDefinedMeaning.class);
                    udm.id = f.getLeafName().replace(".json", "");
                    ret.add(udm);
                }
                catch (IOException e) {
                    this.logger.warn((Object)("Failed to read UDM " + String.valueOf(f)), (Throwable)e);
                }
            }
        }
        return ret;
    }

    @Override
    public void save(UserDefinedMeaning udm) throws IOException {
        RWTransactionRef tr = TransactionContext.retrieveWrite();
        tr.writeObject(this.meaningFile(udm.id), (Object)udm);
    }

    @Override
    public void delete(String id) throws IOException {
        RWTransactionRef tr = TransactionContext.retrieveWrite();
        tr.deleteFile(this.meaningFile(id));
    }

    private RelFile meaningFile(String id) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)id), (Object)"User defined meaning id is not specified");
        return new RelFile(new String[]{"meanings", id + ".json"});
    }
}

