/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.mec;

import com.dataiku.dip.coremodel.Partitionable;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.datasets.PartitionableHandler;
import com.dataiku.dip.mec.ModelEvaluationStoreHandler;
import com.dataiku.dip.metrics.ChecksSet;
import com.dataiku.dip.metrics.ProbesSet;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.JSON;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;

public class ModelEvaluationStore
extends TaggableObjectsService.TaggableObject
implements Partitionable {
    @JSON.FileTransient
    public String projectKey;
    @JSON.FileTransient
    public String id;
    public SerializedDataset.RebuildBehavior rebuildBehavior = SerializedDataset.RebuildBehavior.EXPLICIT;
    public String name;
    public ProbesSet metrics;
    public ChecksSet metricsChecks;
    public SerializedDataset.FlowOptions flowOptions = new SerializedDataset.FlowOptions();
    public PartitioningScheme partitioning = new PartitioningScheme();
    public DisplayParams displayParams = new DisplayParams();
    public boolean governSyncOptOut = false;
    public String governTimestampLabel;

    public ModelEvaluationStore() {
    }

    public ModelEvaluationStore(String projectKey) {
        this.projectKey = projectKey;
        this.id = SecretKeyGenerator.generate((int)8);
    }

    @Override
    public ITaggingService.TaggableType getTaggableType() {
        return ITaggingService.TaggableType.MODEL_EVALUATION_STORE;
    }

    @Override
    public String getSubtype() {
        return "store";
    }

    @Override
    public String getProjectKey() {
        return this.projectKey;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getDisplayName() {
        return this.name;
    }

    @Override
    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public boolean isPartitioned() {
        return false;
    }

    @Override
    public PartitioningScheme getPartitioningSchema() {
        return this.partitioning;
    }

    @Override
    public SerializedDataset.FlowOptions getFlowOptions() {
        return this.flowOptions;
    }

    @Override
    public String getName() {
        return this.id;
    }

    @Override
    public String getFullName() {
        return this.getFullId();
    }

    @Override
    public PartitionableHandler buildHandler(AuthCtx authCtx) {
        return new ModelEvaluationStoreHandler(this);
    }

    public AnyLoc getLoc() {
        return new AnyLoc(this.projectKey, this.id);
    }

    public static class DisplayParams {
        LinkedHashSet<String> displayedMetrics;
        LinkedHashSet<String> allAvailableMetrics;
        String predictionType;
        LinkedHashSet<String> pinnedMetrics = new LinkedHashSet();
        String xLabel;
        List<String> yLabels = new ArrayList<String>();
        List<String> alsoDisplayedLabels = new ArrayList<String>();
        List<String> barLabels;
        GraphStyle graphStyle;
        String sortColumn;
        boolean sortDescending;
        boolean showConfidenceIntervals = true;
        List<String> disabledMERunIds = new ArrayList<String>();
        public String rowByRowShakerScript;
        public List<String> rowByRowAdditionalColumns;
    }

    public static enum GraphStyle {
        BAR,
        LINE;

    }

    public static class ModelEvaluationStoreListItem
    extends TaggableObjectsService.TaggableListItem {
        public long evaluationCount = 0L;

        public ModelEvaluationStoreListItem(ModelEvaluationStore mes) {
            super(mes);
        }

        @Override
        public ITaggingService.TaggableType getTaggableType() {
            return ITaggingService.TaggableType.MODEL_EVALUATION_STORE;
        }
    }
}

