/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.dss;

import com.dataiku.dip.pivot.backend.dss.DoubleDataTensor;
import com.dataiku.dip.pivot.backend.dss.GenericDataTensor;
import com.dataiku.dip.pivot.backend.dss.TensorType;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Date;

public abstract class DataTensor<T> {
    public int numAxes;
    public int[] axisLengths;
    public long[] nonNullCounts;
    public boolean dimension1MemorySaving;
    public long[][] axesNonNullCounts;
    public int[] multipliers;
    public TensorType type;
    public transient boolean hasNullValues = false;
    public transient int tensorSize;
    public transient Class<T> clazz;
    private transient int pos;
    private transient int ncpos;
    public static final double MIN_SAFE_INTEGER = -(Math.pow(2.0, 53.0) - 1.0);

    protected DataTensor(int[] axisLengths, TensorType type, boolean dimension1MemorySaving, boolean initNonNullCounts, Class<T> clazz) {
        if (axisLengths == null) {
            int TENSOR_DEFAULT_SIZE = 10;
            axisLengths = new int[]{TENSOR_DEFAULT_SIZE};
        }
        this.numAxes = axisLengths.length;
        this.clazz = clazz;
        this.axisLengths = axisLengths;
        this.type = type;
        this.pos = 0;
        this.dimension1MemorySaving = dimension1MemorySaving;
        if (dimension1MemorySaving) {
            this.tensorSize = axisLengths[0];
            this.multipliers = new int[]{1};
        } else {
            this.multipliers = new int[this.numAxes];
            for (int i = 0; i < this.numAxes; ++i) {
                this.multipliers[i] = i == 0 ? 1 : this.multipliers[i - 1] * axisLengths[i - 1];
            }
            this.tensorSize = this.multipliers[this.numAxes - 1] * axisLengths[this.numAxes - 1];
        }
        if (initNonNullCounts) {
            this.initNonNullCountsTensor();
        }
    }

    public abstract DataTensor<T> createMergeDT(int[] var1);

    public abstract DataTensor<T> createMergeDT(int[] var1, boolean var2);

    public abstract DataTensor<T> createMergeDT(int var1);

    public abstract DataTensor<T> createMergeDT(int var1, boolean var2);

    public abstract T getOrDefault(int[] var1, T var2);

    public abstract int getAxisLength(int var1);

    public abstract void set(int var1, T var2);

    public abstract void set(int var1, T var2, boolean var3);

    public void add(T data, boolean inferType) {
        if (this.pos >= this.tensorSize) {
            this.resize(this.tensorSize + this.tensorSize / 2);
        }
        this.set(this.pos++, data, inferType);
    }

    public abstract void resize(int var1);

    public T get(int location) {
        return this.get(location, false);
    }

    public abstract T get(int var1, boolean var2);

    public abstract T getAxis(int var1, int var2);

    public abstract void setAxis(int var1, int var2, T var3);

    public abstract double getAsDouble(int var1);

    public abstract void setAsDouble(int var1, double var2);

    public abstract void setAsDouble(int[] var1, double var2);

    public abstract double getAxisAsDouble(int var1, int var2);

    public abstract double[] getAxisAsDouble(int var1);

    public abstract void setAxisAsDouble(int var1, int var2, double var3);

    public abstract double[] getDoubleTensor();

    public abstract double[][] getDoubleAxes();

    public abstract int getAxesLength();

    public abstract T[] getTensor();

    public abstract void initDoubleTensor(double var1);

    public abstract void replaceInvalidValues();

    public void inferType(T element) {
        if (element == null) {
            return;
        }
        this.type = element instanceof Number ? (this.type == TensorType.NUMERICAL || this.type == TensorType.UNKNOWN ? TensorType.NUMERICAL : TensorType.OBJECT) : (element instanceof String ? (this.type == TensorType.ALPHANUM || this.type == TensorType.UNKNOWN ? TensorType.ALPHANUM : TensorType.OBJECT) : (element instanceof DateTime || element instanceof Date ? (this.type == TensorType.DATE || this.type == TensorType.UNKNOWN ? TensorType.DATE : TensorType.OBJECT) : TensorType.OBJECT));
    }

    public double getAsDouble(int[] coords) {
        return this.getAsDouble(this.loc(coords));
    }

    public void set(int[] coords, T data) {
        this.set(this.loc(coords), data, false);
    }

    public void set(int[] coords, T data, boolean inferType) {
        this.set(this.loc(coords), data, inferType);
    }

    public T get(int[] coords) {
        return this.get(coords, false);
    }

    public T get(int[] coords, boolean realType) {
        return this.get(this.loc(coords), realType);
    }

    public void incrementNonNullCount(int bin) {
        this.incrementNonNullCount(bin, 1L);
    }

    public void addNonNullCount(long value) {
        if (this.nonNullCounts == null) {
            this.initNonNullCountsTensor();
        }
        if (this.ncpos >= this.nonNullCounts.length) {
            this.nonNullCounts = Arrays.copyOf(this.nonNullCounts, this.nonNullCounts.length + this.nonNullCounts.length / 2);
        }
        this.nonNullCounts[this.ncpos++] = value;
    }

    public void incrementNonNullCount(int[] coordinates) {
        this.incrementNonNullCount(coordinates, 1L);
    }

    public int loc(int[] coordinates) {
        int loc = 0;
        for (int i = 0; i < coordinates.length; ++i) {
            loc += coordinates[i] * this.multipliers[i];
        }
        return loc;
    }

    public void incrementNonNullCount(int[] coordinates, long val) {
        this.incrementNonNullCount(this.loc(coordinates), val);
    }

    public void incrementNonNullCount(int bin, long val) {
        if (this.nonNullCounts == null) {
            this.initNonNullCountsTensor();
        }
        if (this.nonNullCounts.length > bin) {
            int n = bin;
            this.nonNullCounts[n] = this.nonNullCounts[n] + val;
        }
    }

    public void incrementAxesNonNullCount(int[] coordinates) {
        this.incrementAxesNonNullCount(coordinates, 1L);
    }

    public void incrementAxesNonNullCount(int[] coordinates, long val) {
        for (int i = 0; i < this.axesNonNullCounts.length; ++i) {
            long[] lArray = this.axesNonNullCounts[i];
            int n = coordinates[i];
            lArray[n] = lArray[n] + val;
        }
    }

    public long getNonNullCount(int[] coordinates) {
        return this.getNonNullCount(this.loc(coordinates));
    }

    public long getNonNullCount(int i) {
        return this.nonNullCounts[i];
    }

    public long getAxesNonNullCount(int i, int j) {
        return this.axesNonNullCounts[i][j];
    }

    public void initNonNullCountsTensor() {
        this.nonNullCounts = new long[this.tensorSize];
        if (!this.dimension1MemorySaving) {
            this.initAxesNonNullCounts();
        }
    }

    private void initAxesNonNullCounts() {
        this.axesNonNullCounts = new long[this.numAxes][];
        for (int i = 0; i < this.numAxes; ++i) {
            this.axesNonNullCounts[i] = new long[this.axisLengths[i]];
        }
    }

    public static long getUsedBytes(int[] axisLengths) {
        long usedDoubles = 0L;
        long tensorLength = 1L;
        for (int axisLength : axisLengths) {
            tensorLength *= (long)axisLength;
            usedDoubles += (long)axisLength;
        }
        return (usedDoubles += tensorLength * 2L) * 8L;
    }

    static {
        JSON.registerAdapter((Type)new TypeToken<DataTensor<?>>(){}.getType(), (Object)new JSON.Adapter<DataTensor<?>>(){

            public JsonElement serialize(DataTensor<?> src, Type type, JsonSerializationContext context) {
                return context.serialize(src);
            }

            public DataTensor<?> deserialize(JsonElement src, Type type, JsonDeserializationContext context) throws JsonParseException {
                if (TensorType.NUMERICAL.name().equals(src.getAsJsonObject().get("type").getAsString())) {
                    return (DataTensor)context.deserialize(src, DoubleDataTensor.class);
                }
                return (DataTensor)context.deserialize(src, GenericDataTensor.class);
            }
        });
    }

    public static class Builder<T> {
        protected int[] axisLengths;
        protected TensorType type;
        protected boolean dimension1MemorySaving = false;
        protected boolean initNonNullCounts = false;

        public Builder<T> axisLengths(int[] axisLengths) {
            this.axisLengths = axisLengths;
            return this;
        }

        public Builder<T> axisLengths(int axisLength) {
            this.axisLengths = new int[]{axisLength};
            this.dimension1MemorySaving = true;
            return this;
        }

        public Builder<T> initNonNullCounts(boolean initNonNullCounts) {
            this.initNonNullCounts = initNonNullCounts;
            return this;
        }

        public DataTensor<T> build() {
            throw new IllegalArgumentException();
        }
    }
}

