/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.dss.aggregators;

import com.dataiku.dip.pivot.backend.dss.GenericDataTensor;
import com.dataiku.dip.pivot.backend.dss.aggregators.GenericAggregator;
import com.dataiku.dip.pivot.backend.model.Aggregation;
import java.util.function.BiFunction;

public class BiFuncGenericAggregator
extends GenericAggregator<Object> {
    BiFunction<Object, Object, Object> biFunction;

    public BiFuncGenericAggregator(Aggregation req, Type biFunctionType) {
        super(req, new GenericDataTensor.Builder<Object>().clazz(Object.class).initNonNullCounts(true).axisLengths(1).build());
        this.init(biFunctionType);
    }

    public BiFuncGenericAggregator(Aggregation req, int bins, Type biFunctionType) {
        super(req, new GenericDataTensor.Builder<Object>().clazz(Object.class).initNonNullCounts(true).axisLengths(bins).build());
        this.init(biFunctionType);
    }

    public BiFuncGenericAggregator(Aggregation req, int[] numBins, Type biFunctionType) {
        super(req, new GenericDataTensor.Builder<Object>().clazz(Object.class).initNonNullCounts(true).axisLengths(numBins).build());
        this.init(biFunctionType);
    }

    private void init(Type biFunctionType) {
        this.biFunction = Type.MAX.equals((Object)biFunctionType) ? this::max : this::min;
    }

    @Override
    public Object mergeValues(Object v1, Object v2) {
        return this.biFunction.apply(v1, v2);
    }

    @Override
    public double mergeDoubleValues(double v1, double v2) {
        return (Double)this.biFunction.apply(v1, v2);
    }

    private Object min(Object s1, Object s2) {
        if (s1 == null && s2 == null) {
            return null;
        }
        if (s1 == null || s2 == null) {
            return s1 == null ? s2 : s1;
        }
        if (this.isDoubleNaN(s1) || this.isDoubleNaN(s2)) {
            return this.isDoubleNaN(s1) ? s2 : s1;
        }
        return this.compareValues(s1, s2) > 0 ? s1 : s2;
    }

    private Object max(Object s1, Object s2) {
        if (s1 == null && s2 == null) {
            return null;
        }
        if (s1 == null || s2 == null) {
            return s1 == null ? s2 : s1;
        }
        if (this.isDoubleNaN(s1) || this.isDoubleNaN(s2)) {
            return this.isDoubleNaN(s1) ? s2 : s1;
        }
        return this.compareValues(s1, s2) < 0 ? s1 : s2;
    }

    private boolean isDoubleNaN(Object obj) {
        return obj instanceof Double && ((Double)obj).isNaN();
    }

    public static enum Type {
        MIN,
        MAX;

    }
}

