/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.frontend.excel.xssf.charts;

import com.dataiku.dip.pivot.frontend.excel.xssf.ChartUtils;
import com.dataiku.dip.pivot.frontend.excel.xssf.charts.BaseChart;
import com.dataiku.dip.pivot.frontend.excel.xssf.series.Series1D;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xddf.usermodel.chart.XDDFChart;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xddf.usermodel.chart.XDDFChartAxis;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTAxDataSource;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTLineChart;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTLineSer;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTMarker;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTNumDataSource;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTPlotArea;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTSerTx;
import org.openxmlformats.schemas.drawingml.x2006.chart.STMarkerStyle;
import org.openxmlformats.schemas.drawingml.x2006.main.CTLineProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSRgbColor;
import org.openxmlformats.schemas.drawingml.x2006.main.CTShapeProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSolidColorFillProperties;

public class LineChart
extends BaseChart<Series1D> {
    @Override
    public void plot(XDDFChart chart, XDDFChartAxis ... chartAxes) {
        CTPlotArea plotArea = chart.getCTChart().getPlotArea();
        CTLineChart ctLineChart = plotArea.addNewLineChart();
        ctLineChart.addNewVaryColors().setVal(false);
        for (Series1D series : this.getSeries()) {
            CTLineSer lineSer = ctLineChart.addNewSer();
            lineSer.addNewIdx().setVal((long)series.getId());
            lineSer.addNewOrder().setVal((long)series.getId());
            CTMarker ctMarker = lineSer.addNewMarker();
            if (series.getMarker() != STMarkerStyle.NONE) {
                ctMarker.addNewSize().setVal((short)4);
                ctMarker.addNewSymbol().setVal(series.getMarker());
                CTShapeProperties markerSpPr = ctMarker.addNewSpPr();
                markerSpPr.addNewNoFill();
                markerSpPr.addNewLn().addNewSolidFill().addNewSrgbClr().setVal(ChartUtils.computeDarkenColor(series.getColor().asByteArray()));
            } else {
                ctMarker.addNewSymbol().setVal(STMarkerStyle.NONE);
            }
            CTShapeProperties spPr = lineSer.addNewSpPr();
            CTSolidColorFillProperties scfp = spPr.addNewSolidFill();
            CTSRgbColor rgbColor = scfp.addNewSrgbClr();
            rgbColor.setVal(series.getColor().asByteArray());
            CTLineProperties ln = spPr.addNewLn();
            CTSolidColorFillProperties solidFill = ln.addNewSolidFill();
            CTSRgbColor fillCol = solidFill.addNewSrgbClr();
            fillCol.setVal(series.getColor().asByteArray());
            ln.addNewRound();
            CTSerTx tx = lineSer.addNewTx();
            ChartUtils.buildSerTx(tx, series.getTitle());
            CTAxDataSource cats = lineSer.addNewCat();
            ChartUtils.buildAxDataSource(cats, series.getLabels());
            CTNumDataSource vals = lineSer.addNewVal();
            ChartUtils.buildNumDataSource(vals, series.getXValues());
            lineSer.addNewSmooth().setVal(series.isSmoothed());
        }
        for (XDDFChartAxis axis : chartAxes) {
            ctLineChart.addNewAxId().setVal(axis.getId());
        }
    }
}

