/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.populardatasets;

import com.dataiku.dip.populardatasets.MostSharedDatasetInfos;
import com.dataiku.dip.populardatasets.PopularDatasetInfos;
import com.dataiku.dip.populardatasets.PopularDatasetsProcessing;
import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.ObjDoubleConsumer;
import java.util.function.ToDoubleFunction;
import java.util.stream.Collectors;

public class ScoreComputer {
    private ScoreComputer() {
    }

    @VisibleForTesting
    public static double[] computeRankPercentile(double[] values) {
        int size = values.length;
        double[] res = new double[size];
        int ptr = 0;
        while (ptr < size) {
            int ptr2;
            double currentValue = values[ptr];
            for (ptr2 = ptr + 1; ptr2 < size && values[ptr2] == currentValue; ++ptr2) {
            }
            double rank = (double)ptr2 / (double)size;
            while (ptr < ptr2) {
                res[ptr] = rank;
                ++ptr;
            }
        }
        return res;
    }

    private static void fetchRank(PopularDatasetInfos[] datasets, Map<PopularDatasetInfos, InternalScoreState> scores, ToDoubleFunction<PopularDatasetInfos> selector, ObjDoubleConsumer<InternalScoreState> saveResult) {
        Arrays.sort(datasets, Comparator.comparingDouble(selector));
        double[] rankedValues = new double[datasets.length];
        for (int i = 0; i < rankedValues.length; ++i) {
            rankedValues[i] = selector.applyAsDouble(datasets[i]);
        }
        double[] percentiles = ScoreComputer.computeRankPercentile(rankedValues);
        for (int i = 0; i < rankedValues.length; ++i) {
            saveResult.accept(scores.get(datasets[i]), percentiles[i]);
        }
    }

    private static void computeFinalScore(Map<PopularDatasetInfos, InternalScoreState> scores) {
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        for (InternalScoreState score2 : scores.values()) {
            score2.aggregatedL2Norm = Math.sqrt(score2.trendingRankPercentile * score2.trendingRankPercentile + score2.numSharesPercentile * score2.numSharesPercentile + score2.numSharesPerMonthRankPercentile * score2.numSharesPerMonthRankPercentile + score2.lastWindowRankPercentile * score2.lastWindowRankPercentile);
            min = Math.min(score2.aggregatedL2Norm, min);
            max = Math.max(score2.aggregatedL2Norm, max);
        }
        double range = max - min;
        double finalMin = min;
        scores.forEach((d, score) -> {
            d.score = range == 0.0 ? 1.0 : (score.aggregatedL2Norm - finalMin) / range;
        });
    }

    public static void enrichWithScore_NT(List<PopularDatasetInfos> datasetsAsList) {
        Map<PopularDatasetInfos, InternalScoreState> scores = datasetsAsList.stream().collect(Collectors.toMap(d -> d, d -> new InternalScoreState()));
        PopularDatasetInfos[] datasets = datasetsAsList.toArray(new PopularDatasetInfos[0]);
        ScoreComputer.fetchRank(datasets, scores, d -> d.isTrending ? 1.0 : 0.0, (s, v) -> {
            s.trendingRankPercentile = v;
        });
        ScoreComputer.fetchRank(datasets, scores, d -> d.numShares, (s, v) -> {
            s.numSharesPercentile = v;
        });
        ScoreComputer.fetchRank(datasets, scores, d -> d.numSharesPerMonth, (s, v) -> {
            s.numSharesPerMonthRankPercentile = v;
        });
        ScoreComputer.fetchRank(datasets, scores, d -> d.percentNewRecipesCreatedDuringLastWindow, (s, v) -> {
            s.lastWindowRankPercentile = v;
        });
        ScoreComputer.computeFinalScore(scores);
    }

    public static List<MostSharedDatasetInfos> computeMostSharedDatasetScore_NT(List<PopularDatasetsProcessing.DatasetInfo> rawMostSharedDatasets) {
        List<MostSharedDatasetInfos> mostSharedDatasetInfos = rawMostSharedDatasets.stream().map(d -> new MostSharedDatasetInfos((PopularDatasetsProcessing.DatasetInfo)d, d.projects - 1)).toList();
        int maxNumberOfShares = 0;
        for (MostSharedDatasetInfos d2 : mostSharedDatasetInfos) {
            maxNumberOfShares = Math.max(maxNumberOfShares, d2.numShares);
        }
        for (MostSharedDatasetInfos d2 : mostSharedDatasetInfos) {
            ScoreComputer.enrichMostSharedDatasetWithScore(d2, maxNumberOfShares);
        }
        return mostSharedDatasetInfos;
    }

    private static void enrichMostSharedDatasetWithScore(MostSharedDatasetInfos dataset, int maxNumberOfShares) {
        dataset.score = Math.log(1.0 + (double)dataset.numShares / (double)maxNumberOfShares) / Math.log(2.0);
    }

    @VisibleForTesting
    public static class InternalScoreState {
        double trendingRankPercentile;
        double numSharesPercentile;
        double numSharesPerMonthRankPercentile;
        double lastWindowRankPercentile;
        double aggregatedL2Norm;
    }
}

