/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.code.hive;

import com.dataiku.dip.dataflow.FlowGraph;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.recipes.RecipeSchemaComputer;
import com.dataiku.dip.recipes.code.hive.HiveRecipeMeta;
import com.dataiku.dip.recipes.code.hive.HiveRecipeTester;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.recipes.GenericRecipesValidationService;
import com.dataiku.dip.server.recipes.RecipeSchemaService;
import com.dataiku.dip.server.services.SingleWriteTransactionTransactionService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import org.springframework.beans.factory.annotation.Autowired;

public class HiveRecipeSchemaComputer
extends RecipeSchemaComputer
implements RecipeSchemaComputer.RecipeSchemaComputerWithPayload {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private GenericRecipesValidationService validationService;
    private String query;
    protected static DKULogger logger = DKULogger.getLogger((String)"dku.hive.schema.computer");

    public HiveRecipeSchemaComputer(AuthCtx authCtx, JobActivity activity) {
        super(authCtx, activity);
    }

    @Override
    public void setPayload(String payload) {
        this.query = payload;
    }

    @Override
    public boolean computesDiffItself() {
        return true;
    }

    @Override
    public RecipeSchemaService.RecipeSchemaAutoupdateResult getAutoupdateResult_NT() throws Exception {
        HiveRecipeTester.HiveCheckContext ctx;
        SingleWriteTransactionTransactionService.DetransactionalizedCallable<RecipeRunnableSubgraph> subgraphCallable;
        HiveRecipeTester tester = new HiveRecipeTester();
        try (Transaction t = this.transactionService.beginRead();){
            FlowGraph graph = new FlowGraph();
            FlowRecipe frecipe = graph.buildSingleRecipe(this.recipe);
            subgraphCallable = this.validationService.getValidationRunnableSubgraph(this.authCtx, frecipe, null);
        }
        RecipeRunnableSubgraph subgraph = subgraphCallable.call_NT();
        try (Transaction t = this.transactionService.beginRead();){
            ctx = tester.startCheckHive(this.authCtx, this.recipe, (HiveRecipeMeta.HiveRecipeParams)this.recipe.params, false, this.query, subgraph);
        }
        if (ctx.proceed) {
            tester.doCheckHive_NT(ctx);
            tester.finishCheckHive_NT(ctx);
            return ctx.status.schemaResult;
        }
        throw ErrorContext.iae((String)("Failed to compute output schema: " + String.valueOf(ctx.status.gatherAllMessages().firstFatal())));
    }
}

