/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.code.impala;

import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.fs.HDFSDatasetHandler;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.hive.HiveSchemaHandler;
import com.dataiku.dip.impala.ImpalaConfigurator;
import com.dataiku.dip.input.formats.hive.orcfile.ORCFileFormatMeta;
import com.dataiku.dip.input.formats.parquet.ParquetFormatConfig;
import com.dataiku.dip.input.formats.parquet.ParquetFormatMeta;
import com.dataiku.dip.recipes.code.hive.HiveQLQueryRecipeUtils;
import com.dataiku.dip.recipes.code.impala.ImpalaRecipeMeta;
import com.dataiku.dip.recipes.code.sql.AbstractSQLQueryRecipeTester;
import com.dataiku.dip.recipes.code.sql.SQLQueryRecipeUtils;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.ErrorContext;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.util.StringUtils;

public class ImpalaQueryRecipeTester
extends AbstractSQLQueryRecipeTester {
    public ImpalaQueryRecipeTester() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    @Override
    protected SQLConnectionProvider.SQLConnectionData getConnectionDataFromConnection_NT(AuthCtx authCtx, String projectKey, String sourceConnection) throws IOException, DKUSecurityException, SQLException {
        logger.info((Object)("Impala: Getting connection data from virtual connection: " + sourceConnection));
        String databaseName = HiveSchemaHandler.getHiveDatabaseFromVirtualConnection(authCtx, sourceConnection);
        return ImpalaConfigurator.configureConnectionForDatabase(authCtx, databaseName).getConnectionData_NT(authCtx, projectKey);
    }

    @Override
    protected String getRecipeType() {
        return "impala";
    }

    @Override
    protected String getRecipeDisplayName() {
        return "Impala query";
    }

    @Override
    protected String getSQLDatasetConnectionName(AuthCtx authCtx, Dataset ds) {
        try {
            String db = HiveSchemaHandler.getResolvedHiveTableRefFromDataset(ds).getSchemaNullIfBlank();
            return "@virtual(impala-jdbc):" + db;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get SQL connection name", e);
        }
    }

    @Override
    protected boolean checkConnectionsMismatch(Set<String> connections, SerializedRecipe recipe) {
        return false;
    }

    @Override
    public String getMainConnection(SerializedRecipe recipe, AuthCtx liu) throws IOException {
        return SQLQueryRecipeUtils.getSourceDatasets(recipe).stream().map(dataset -> this.getSQLDatasetConnectionName(liu, (Dataset)dataset)).findFirst().orElse(null);
    }

    @Override
    protected void validateSourceDatasets(List<Dataset> sourceDatasets, AuthCtx liu) throws IllegalArgumentException {
        if (sourceDatasets.isEmpty()) {
            throw ErrorContext.iaef((String)"Recipe %s needs inputs", (Object)this.getRecipeDisplayName(), (Object[])new Object[0]);
        }
        for (Dataset dataset : sourceDatasets) {
            if (DatasetInspector.isHiveQuery(dataset)) {
                throw ErrorContext.iaef((String)"%s is a Hive query dataset hence it cannot be used as input of this recipe.", (Object)dataset.getName(), (Object[])new Object[0]);
            }
            if (!DatasetInspector.isHDFSDatasetOrHiveTableDataset(dataset)) {
                throw ErrorContext.iaef((String)"Input dataset %s cannot be used as input of this recipe", (Object)dataset.getName(), (Object[])new Object[0]);
            }
            if (DatasetInspector.isHive(dataset)) {
                return;
            }
            if (dataset.getFormatType().equals(ORCFileFormatMeta.META.getType())) {
                throw ErrorContext.iaef((String)"Impala cannot read %s because its format is Orc.", (Object)dataset.getName(), (Object[])new Object[0]);
            }
            if (!dataset.getFormatType().equals(ParquetFormatMeta.META.getType())) {
                return;
            }
            if (dataset.getFormatParamsAs(ParquetFormatConfig.class).parquetCompressionMethod != ParquetFormatConfig.CompressionMethod.LZO) continue;
            throw ErrorContext.iaef((String)"Impala cannot read %s because its format is Lzo-compressed Parquet.", (Object)dataset.getName(), (Object[])new Object[0]);
        }
    }

    @Override
    protected InfoMessage.InfoMessages getFullSqlRecommendation(SerializedRecipe recipe, String mainConnection) throws IOException {
        InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
        if (((ImpalaRecipeMeta.ImpalaRecipeParams)recipe.params).runInStreamMode && this.allDatasetsAreOfSameType(recipe)) {
            messages.withInfo((InfoMessage.MessageCode)RecipeCodes.INFO_RECIPE_IMPALA_POTENTIAL_FAST_PATH, "The recipe is configured to let DSS write the output, which handles more formats but is slower.");
        }
        return messages;
    }

    private boolean allDatasetsAreOfSameType(SerializedRecipe recipe) throws IOException {
        return SQLQueryRecipeUtils.getAllDatasetStream(recipe).map(dataset -> dataset.type).collect(Collectors.toSet()).size() == 1;
    }

    public AbstractSQLQueryRecipeTester.SQLQueryValidationResult postValidate(AbstractSQLQueryRecipeTester.SQLQueryValidationResult ret, SerializedRecipe recipe) throws Exception {
        Pattern impalaTableNotFound;
        Matcher impalaTableNotFoundMatcher;
        if (ret.configOK && ret.connectionOK && ret.runResult != null && !ret.runResult.success && !StringUtils.isEmpty((Object)ret.runResult.errorMessage) && (impalaTableNotFoundMatcher = (impalaTableNotFound = Pattern.compile("Table does not exist: (.*)", 2)).matcher(ret.runResult.errorMessage)).find()) {
            String firstMissingTable = impalaTableNotFoundMatcher.group(1).trim();
            logger.info((Object)("Found a missing table in error message: " + firstMissingTable));
            for (SerializedDataset dataset : this.datasetsDAO.listUnsafe(recipe.projectKey)) {
                String database;
                if (!(dataset.getParams() instanceof HDFSDatasetHandler.Config) || !firstMissingTable.equalsIgnoreCase((database = HiveSchemaHandler.getResolvedHiveTableRefFromDataset(Dataset.fromSerializedUnsafe(dataset)).getSchemaNullIfBlank()) + "." + dataset.name)) continue;
                ret.runResult.datasetInNeedOfSynchronization = dataset.name;
                return ret;
            }
        }
        return ret;
    }

    @Override
    protected boolean willRunInFullSQL(AuthCtx authCtx, String mainConnection, Dataset outputDataset, String query, SerializedRecipe recipe) {
        ImpalaRecipeMeta.ImpalaRecipeParams params = (ImpalaRecipeMeta.ImpalaRecipeParams)recipe.params;
        boolean runInStreamMode = params != null ? params.runInStreamMode : true;
        return !runInStreamMode && HiveQLQueryRecipeUtils.runsInSQLMode(authCtx, mainConnection, outputDataset, query) == null;
    }
}

