/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.code.python;

import com.dataiku.dip.code.CodeEnvSelection;
import com.dataiku.dip.code.CodeEnvSelector;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.FlowGraph;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.recipes.code.CodeBasedRecipeStatus;
import com.dataiku.dip.recipes.code.python.PythonRecipeMeta;
import com.dataiku.dip.recipes.code.python.PythonRecipeStatusComputerBase;
import com.dataiku.dip.recipes.common.RecipeStatus;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.recipes.RecipeVariablesHelper;
import com.dataiku.dip.server.services.SingleWriteTransactionTransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.JSON;
import java.io.IOException;
import org.apache.log4j.Logger;

public class PythonRecipeStatusComputer
extends PythonRecipeStatusComputerBase {
    private static Logger logger = Logger.getLogger((String)"dip.python.recipe.status");

    public PythonRecipeStatusComputer(SerializedRecipe recipe, String payload) {
        super(recipe, payload);
    }

    @Override
    public RecipeStatus getFullStatus_NT(AuthCtx authCtx, String requestData) throws Exception {
        Object graph;
        Transaction t;
        CodeBasedRecipeStatus.CodeBasedRecipeStatusRequest request = (CodeBasedRecipeStatus.CodeBasedRecipeStatusRequest)JSON.parse((String)requestData, CodeBasedRecipeStatus.CodeBasedRecipeStatusRequest.class);
        CodeBasedRecipeStatus ret = null;
        RecipeRunnableSubgraph subgraph = null;
        if (request != null) {
            SingleWriteTransactionTransactionService.DetransactionalizedCallable<RecipeRunnableSubgraph> subgraphCallable;
            t = this.transactionService.beginRead();
            try {
                this.recipe.name = "testRecipe";
                graph = new FlowGraph();
                FlowRecipe frecipe = ((FlowGraph)graph).buildSingleRecipe(this.recipe);
                subgraphCallable = this.validationService.getValidationRunnableSubgraph(authCtx, frecipe, request.targetPartitionSpec);
            }
            finally {
                if (t != null) {
                    t.close();
                }
            }
            subgraph = subgraphCallable.call_NT();
        }
        PythonRecipeMeta.PythonRecipeParams params = this.recipe.getParamsAs(PythonRecipeMeta.PythonRecipeParams.class);
        t = this.transactionService.beginRead();
        try {
            authCtx.failIfNoSafeCode("validate a Python recipe");
            ret = this.fastStatusIgnorePartitions(authCtx);
            this.checkContainerConfiguration(authCtx, ret, params, null);
            if (ret.topLevelMessages.anyFatal()) {
                graph = ret;
                return graph;
            }
            if (request != null) {
                RecipeVariablesHelper.RecipeSubstitutionVariablesResult vres = new RecipeVariablesHelper().getRecipeVariables(authCtx, this.recipe.projectKey, subgraph, null);
                ret.substitutionVariables = vres.substitutionVariables;
            }
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
        CodeEnvSelection codeEnvSelection = params.getCodeEnvSelection();
        String envName = new CodeEnvSelector().selectForPythonRecipe(this.recipe.getProjectKey(), codeEnvSelection);
        logger.info((Object)("Check script in code env : " + envName));
        PythonRecipeStatusComputer.checkPythonCompile(ret.topLevelMessages, this.payload, envName, this.recipe.getProjectKey());
        return ret;
    }

    @Override
    public CodeBasedRecipeStatus fastStatusIgnorePartitions(AuthCtx authCtx) throws IOException, DKUSecurityException {
        CodeBasedRecipeStatus ret = new CodeBasedRecipeStatus();
        this.performBasicStructureChecks(ret, authCtx);
        ret.addSingleEngine("USER_CODE", "User code", "PYTHON", "Python", "Python (user code)");
        return ret;
    }
}

