/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.streaming.python;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.ComputableFromRefService;
import com.dataiku.dip.dataflow.exec.window.WindowRecipePayloadParams;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowStreamingEndpoint;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.recipes.streaming.python.ContinuousPythonRecipeParams;
import com.dataiku.dip.recipes.streaming.python.FunctionCheckpoint;
import com.dataiku.dip.recipes.streaming.python.FunctionCheckpointComparator;
import com.dataiku.dip.recipes.streaming.python.FunctionStreamingFeedParams;
import com.dataiku.dip.recipes.streaming.python.RowsSplittingHandler;
import com.dataiku.dip.recipes.streaming.python.StreamDoneException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.streaming.endpoints.Replayable;
import com.dataiku.dip.streaming.endpoints.RowWithTimestamp;
import com.dataiku.dip.streaming.endpoints.StreamRowWithTimestampFactory;
import com.dataiku.dip.streaming.endpoints.StreamingEndpointSimplePuller;
import com.dataiku.dip.streaming.endpoints.StreamingEndpointsRegistry;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;

public class RowsPullingHandler
implements FunctionCheckpointComparator {
    public static int DRAIN_EXTRA = 4;
    private final List<RowsPullingThread> pullThreads = Lists.newArrayList();
    private final FunctionCheckpoint current = new FunctionCheckpoint(System.currentTimeMillis(), 0L);
    private final Runnable notifyError;
    private final List<FunctionCheckpointGate> checkpointGates = Lists.newArrayList();
    private int currentGate;
    private volatile boolean closed = false;
    private static Logger logger = Logger.getLogger((String)"dip.streaming.function.rows.pull");

    public RowsPullingHandler(AuthCtx authCtx, String projectKey, SerializedRecipe sr, List<FunctionCheckpoint> checkpointsToReplay, ComputableFromRefService computableFromRefService, Runnable notifyError) throws Exception {
        this.notifyError = notifyError;
        ArrayList streamingEndpoints = Lists.newArrayList();
        for (SerializedRecipe.RecipeInput input : sr.getFlatInputs()) {
            FlowComputable computable = computableFromRefService.get(projectKey, input.ref);
            if (!(computable instanceof FlowStreamingEndpoint)) continue;
            streamingEndpoints.add(((FlowStreamingEndpoint)computable).getStreamingEndpoint());
        }
        for (int i = 0; i < checkpointsToReplay.size(); ++i) {
            FunctionCheckpoint start = checkpointsToReplay.get(i);
            FunctionCheckpoint end = i + 1 < checkpointsToReplay.size() ? checkpointsToReplay.get(i + 1) : null;
            this.checkpointGates.add(new FunctionCheckpointGate(start, end, streamingEndpoints.size()));
        }
        if (this.checkpointGates.isEmpty()) {
            this.checkpointGates.add(new FunctionCheckpointGate(new FunctionCheckpoint(-1L, -1L), null, streamingEndpoints.size()));
        }
        FunctionStreamingFeedParams feedParams = sr.getParamsAs(ContinuousPythonRecipeParams.class).feedParams;
        for (SerializedRecipe.RecipeInput input : sr.getFlatInputs()) {
            FlowComputable computable = computableFromRefService.get(projectKey, input.ref);
            if (!(computable instanceof FlowStreamingEndpoint)) continue;
            StreamingEndpoint streamingEndpoint = ((FlowStreamingEndpoint)computable).getStreamingEndpoint();
            FunctionStreamingFeedParams.Consumption consumptionParams = feedParams.getInputForRef(input.ref);
            RowsPullingThread pullThread = new RowsPullingThread(authCtx, streamingEndpoint, consumptionParams);
            this.pullThreads.add(pullThread);
        }
        this.currentGate = 0;
        this.current.offsets.putAll(this.checkpointGates.get((int)this.currentGate).start.offsets);
    }

    public Map<String, Schema> getSchemas() {
        HashMap schemas = Maps.newHashMap();
        for (RowsPullingThread pullThread : this.pullThreads) {
            schemas.put(pullThread.fullId, pullThread.schema);
        }
        return schemas;
    }

    public Map<String, Long> getWindowDefinitions() {
        HashMap defs = Maps.newHashMap();
        for (RowsPullingThread pullThread : this.pullThreads) {
            if (pullThread.rowsWindow == null) continue;
            defs.put(pullThread.fullId, pullThread.rowsWindow.windowSize);
        }
        return defs;
    }

    public RowsSplittingHandler.InputRowsBatch takeRowsToProcess() throws InterruptedException {
        boolean allClosed;
        int closedCount = 0;
        for (RowsPullingThread t : this.pullThreads) {
            if (!t.closed) continue;
            ++closedCount;
        }
        boolean bl = allClosed = closedCount == this.pullThreads.size();
        if (this.currentGate >= this.checkpointGates.size()) {
            return null;
        }
        FunctionCheckpointGate gate = this.checkpointGates.get(this.currentGate);
        ArrayList newDrained = Lists.newArrayList();
        if (allClosed) {
            gate.queue.drainTo(newDrained, 1);
        } else {
            newDrained.add(gate.queue.take());
        }
        if (DRAIN_EXTRA > 0) {
            gate.queue.drainTo(newDrained, DRAIN_EXTRA * this.pullThreads.size());
        }
        ArrayList drained = Lists.newArrayList();
        for (InputRowsBlock b : newDrained) {
            if (b.fullId == null) {
                ++gate.passedThreadCount;
                continue;
            }
            drained.add(b);
        }
        if (gate.isPassed()) {
            if (gate.passedThreadCount == this.pullThreads.size()) {
                logger.info((Object)("Exit reading the gate for " + gate.rangeDescription()));
                ++this.currentGate;
            } else {
                logger.info((Object)"Pull threads done will processing gated record chunk, catching up");
            }
        }
        if (drained.isEmpty() && allClosed) {
            return null;
        }
        RowsSplittingHandler.InputRowsBatch batch = new RowsSplittingHandler.InputRowsBatch();
        for (RowsPullingThread pullThread : this.pullThreads) {
            batch.inputs.put(pullThread.fullId, new RowsSplittingHandler.InputRowsElement());
        }
        for (InputRowsBlock rowsBlock : drained) {
            RowsSplittingHandler.InputRowsElement element = batch.inputs.get(rowsBlock.fullId);
            IndexRange range = new IndexRange(rowsBlock.startIdx, rowsBlock.endIdx);
            element.range = element.range == null ? range : element.range.merge(range);
            element.removeFromWindowAtBeginning = rowsBlock.removeFromWindowAtBeginning;
            element.removeFromWindowAtEnd = rowsBlock.removeFromWindowAtEnd;
            if (!rowsBlock.noProcess) {
                element.rows.addAll(rowsBlock.rows);
            }
            element.windowSize = rowsBlock.windowSize;
            this.current.offsets.put(rowsBlock.fullId, rowsBlock.offset);
        }
        ++this.current.idx;
        batch.checkpoint = new FunctionCheckpoint(this.current);
        logger.info((Object)("Read up to current=" + JSON.json((Object)this.current)));
        return batch;
    }

    public void startPull() {
        for (RowsPullingThread pullThread : this.pullThreads) {
            pullThread.start();
        }
    }

    public void stopPull() {
        logger.info((Object)("Stop pull closed=" + this.closed + " on " + String.valueOf(this)));
        if (this.closed) {
            return;
        }
        this.closed = true;
        for (RowsPullingThread pullThread : this.pullThreads) {
            pullThread.stopThreadPull();
        }
    }

    public void errorPull() {
        logger.info((Object)("Stop pull closed=" + this.closed + " on " + String.valueOf(this)));
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.notifyError != null) {
            this.notifyError.run();
        }
        for (RowsPullingThread pullThread : this.pullThreads) {
            pullThread.stopThreadPull();
        }
    }

    @Override
    public boolean lastStoredIsPastCurrent(FunctionCheckpoint last, FunctionCheckpoint current) {
        int count = 0;
        for (RowsPullingThread t : this.pullThreads) {
            JsonElement tb;
            JsonElement ta;
            if (!t.lastStoredIsPastCurrent(ta = (JsonElement)last.offsets.getOrDefault(t.fullId, null), tb = (JsonElement)current.offsets.getOrDefault(t.fullId, null))) continue;
            ++count;
        }
        return count == this.pullThreads.size();
    }

    public static class FunctionCheckpointGate {
        public final LinkedBlockingQueue<InputRowsBlock> queue;
        public final FunctionCheckpoint start;
        public final FunctionCheckpoint end;
        public final CyclicBarrier startBarrier;
        public final CyclicBarrier endBarrier;
        public volatile boolean passed;
        public int passedThreadCount = 0;

        public FunctionCheckpointGate(FunctionCheckpoint start, FunctionCheckpoint end, int barrierSize) {
            this.start = start;
            this.end = end;
            this.startBarrier = new CyclicBarrier(barrierSize);
            this.endBarrier = new CyclicBarrier(barrierSize, () -> {
                FunctionCheckpointGate functionCheckpointGate = this;
                synchronized (functionCheckpointGate) {
                    this.passed = true;
                }
            });
            this.queue = new LinkedBlockingQueue(2 * barrierSize);
        }

        public synchronized boolean isPassed() {
            return this.passed;
        }

        public String rangeDescription() {
            String startDescription = String.format("%d/%d", this.start.run, this.start.idx);
            if (this.end == null) {
                return startDescription + " -> end";
            }
            return startDescription + " -> " + String.format("%d/%d", this.end.run, this.end.idx);
        }
    }

    private class RowsPullingThread
    extends Thread {
        private final String fullId;
        private final Schema schema;
        private final StreamingEndpointSimplePuller puller;
        private final StreamColumnFactory cf;
        private final RowsWindow rowsWindow;
        private volatile boolean closed;
        private long idx;

        public RowsPullingThread(AuthCtx authCtx, StreamingEndpoint streamingEndpoint, FunctionStreamingFeedParams.Consumption consumptionParams) throws Exception {
            super("rows-pull-thread-" + streamingEndpoint.getFullId());
            this.closed = false;
            this.idx = 0L;
            this.fullId = streamingEndpoint.getFullId();
            this.schema = streamingEndpoint.schema;
            this.cf = new StreamColumnFactory();
            this.puller = StreamingEndpointsRegistry.getMeta(streamingEndpoint).getSimplePuller(authCtx, streamingEndpoint, false);
            if (consumptionParams.windowEnabled && this.puller instanceof Replayable) {
                this.puller.init((ColumnFactory)this.cf, new StreamRowWithTimestampFactory(), this.schema, Replayable.BOS);
                this.rowsWindow = new RowsWindow(consumptionParams.windowSize, consumptionParams.windowUnit);
            } else {
                this.puller.init((ColumnFactory)this.cf, new StreamRowWithTimestampFactory(), this.schema, RowsPullingHandler.this.checkpointGates.get((int)0).start.offsets.get(this.fullId));
                this.rowsWindow = null;
            }
        }

        public boolean lastStoredIsPastCurrent(JsonElement ta, JsonElement tb) {
            if (this.puller instanceof Replayable) {
                return ((Replayable)((Object)this.puller)).compareOffsets(ta, tb) >= 0;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (this.rowsWindow != null) {
                    logger.info((Object)(this.fullId + " - Start window pull"));
                    JsonElement limit = RowsPullingHandler.this.checkpointGates.get((int)0).start.offsets.get(this.fullId);
                    this.puller.setLimit(limit == null ? Replayable.EOS : limit);
                    this.pullFrom(this.puller, RowsPullingHandler.this.checkpointGates.get(0), true);
                }
                for (int i = 0; i < RowsPullingHandler.this.checkpointGates.size(); ++i) {
                    JsonElement limit;
                    FunctionCheckpointGate gate = RowsPullingHandler.this.checkpointGates.get(i);
                    gate.startBarrier.await();
                    logger.info((Object)(this.fullId + " - Tripped the start barrier for " + JSON.json((Object)gate.start)));
                    if (gate.end != null) {
                        limit = gate.end.offsets.get(this.fullId);
                        if (limit == null && this.puller instanceof Replayable) {
                            limit = Replayable.EOS;
                        }
                    } else {
                        limit = null;
                    }
                    if (limit != null && !(this.puller instanceof Replayable)) continue;
                    this.puller.setLimit(limit);
                    try {
                        this.pullFrom(this.puller, gate, false);
                    }
                    catch (StreamDoneException e) {
                        logger.info((Object)("Done stream " + this.fullId));
                    }
                    gate.endBarrier.await();
                    logger.info((Object)(this.fullId + " - Tripped the end barrier for " + JSON.json((Object)gate.start)));
                    gate.queue.put(new InputRowsBlock(null, null, this.idx));
                }
            }
            catch (Exception e) {
                logger.error((Object)"Failed to read input streaming data", (Throwable)e);
                RowsPullingHandler.this.errorPull();
            }
            finally {
                this.stopThreadPull();
            }
        }

        private void pullFrom(StreamingEndpointSimplePuller puller, FunctionCheckpointGate gate, boolean initialWindowPull) throws Exception {
            StreamingEndpointSimplePuller.RowsPulled pulled;
            while (!this.closed && (pulled = puller.next()) != null) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Pulled " + pulled.rows.size() + " rows in " + this.fullId));
                }
                InputRowsBlock rowsBlock = new InputRowsBlock(this.fullId, pulled.state, this.idx);
                rowsBlock.noProcess = initialWindowPull;
                if (this.rowsWindow != null) {
                    rowsBlock.removeFromWindowAtBeginning = this.rowsWindow.startBatch();
                }
                for (Row row : pulled.rows) {
                    List<String> cells = this.rowToCells(row);
                    InputRow inputRow = new InputRow().withIndex(this.idx++).withCells(cells);
                    if (row instanceof RowWithTimestamp) {
                        inputRow.withTimestamp(((RowWithTimestamp)row).getTimestamp());
                    }
                    rowsBlock.withRow(inputRow);
                    if (this.rowsWindow == null || inputRow.ts <= 0L) continue;
                    this.rowsWindow.add(inputRow);
                }
                if (this.rowsWindow != null) {
                    rowsBlock.removeFromWindowAtEnd = this.rowsWindow.endBatch();
                    rowsBlock.windowSize = this.rowsWindow.windowSize;
                }
                if (pulled.ack != null) {
                    pulled.ack.run();
                }
                gate.queue.put(rowsBlock);
            }
        }

        private List<String> rowToCells(Row row) {
            ArrayList cells = Lists.newArrayList();
            for (SchemaColumn sc : this.schema.columns) {
                cells.add(row.get((Column)this.cf.column(sc.getName())));
            }
            return cells;
        }

        public void stopThreadPull() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            try {
                this.puller.close();
            }
            catch (Exception e) {
                logger.warn((Object)"Failed to stop puller", (Throwable)e);
            }
        }
    }

    private static class RowsWindow {
        public final long windowSize;
        public List<InputRow> contents = Lists.newArrayList();
        public long minTsInBatch;

        public RowsWindow(int size, WindowRecipePayloadParams.DateDiffUnit unit) {
            size = Math.max(1, size);
            unit = unit == null ? WindowRecipePayloadParams.DateDiffUnit.SECOND : unit;
            switch (unit) {
                case SECOND: {
                    this.windowSize = 1000L * (long)size;
                    break;
                }
                case MINUTE: {
                    this.windowSize = 60000L * (long)size;
                    break;
                }
                case HOUR: {
                    this.windowSize = 3600000L * (long)size;
                    break;
                }
                case DAY: {
                    this.windowSize = 86400000L * (long)size;
                    break;
                }
                case WEEK: {
                    this.windowSize = 604800000L * (long)size;
                    break;
                }
                case MONTH: 
                case YEAR: {
                    throw new IllegalArgumentException("Unit " + String.valueOf((Object)unit) + " is too large to be used as window");
                }
                default: {
                    throw new IllegalArgumentException("Unknown unit " + String.valueOf((Object)unit));
                }
            }
        }

        public long startBatch() {
            this.minTsInBatch = 0L;
            long maxTs = this.contents.isEmpty() ? 0L : this.contents.get((int)(this.contents.size() - 1)).ts;
            return maxTs - this.windowSize;
        }

        public void add(InputRow row) {
            if (row.ts <= 0L) {
                return;
            }
            this.contents.add(row);
            if (this.minTsInBatch == 0L || row.ts < this.minTsInBatch) {
                this.minTsInBatch = row.ts;
            }
        }

        public long endBatch() {
            long min = this.minTsInBatch - this.windowSize;
            this.contents.sort(Comparator.comparingLong(a -> a.ts));
            for (int p = 0; p < this.contents.size() && this.contents.get((int)p).ts < min; ++p) {
            }
            ArrayList nContents = Lists.newArrayList();
            for (int i = p; i < this.contents.size(); ++i) {
                nContents.add(this.contents.get(i));
            }
            this.contents = nContents;
            return min;
        }
    }

    public static class InputRowsBlock {
        public final String fullId;
        public final JsonElement offset;
        public final List<InputRow> rows = Lists.newArrayList();
        public long startIdx;
        public long endIdx;
        public boolean noProcess;
        public long removeFromWindowAtBeginning;
        public long removeFromWindowAtEnd;
        public long windowSize;

        public InputRowsBlock(String fullId, JsonElement offset, long idx) {
            this.fullId = fullId;
            this.offset = offset;
            this.startIdx = idx;
            this.endIdx = idx;
        }

        public InputRowsBlock withRow(InputRow row) {
            this.rows.add(row);
            this.endIdx = row.idx;
            return this;
        }
    }

    public static class IndexRange {
        public final long start;
        public final long end;

        public IndexRange(long startIdx, long endIdx) {
            this.start = startIdx;
            this.end = endIdx;
        }

        public IndexRange merge(IndexRange o) {
            return new IndexRange(Math.min(this.start, o.start), Math.max(this.end, o.end));
        }
    }

    public static class InputRow {
        public long idx;
        public long ts;
        public final List<String> cells = Lists.newArrayList();

        public InputRow withCells(List<String> cells) {
            this.cells.addAll(cells);
            return this;
        }

        public InputRow withTimestamp(long ts) {
            this.ts = ts;
            return this;
        }

        public InputRow withIndex(long idx) {
            this.idx = idx;
            return this;
        }
    }
}

