/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.runnables;

import com.dataiku.dip.io.AbstractImpersonableSecretProtectedPythonKernel;
import com.dataiku.dip.io.BasicKernelLink;
import com.dataiku.dip.io.SecretProtectedKernelLink;
import com.dataiku.dip.io.SocketBlockLinkIOException;
import com.dataiku.dip.kernels.DSSKernelBase;
import com.dataiku.dip.scheduler.reports.ReportTargetItem;
import com.dataiku.dip.scheduler.runnables.DSSRunnableDesc;
import com.dataiku.dip.scheduler.runnables.DSSRunnableResult;
import com.dataiku.dip.scheduler.runnables.LoadedRunnable;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.SmartLogTail;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class DSSRunnableUtils {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.runnables");

    static void fillResult(String projectKey, LoadedRunnable<?> loaded, File contextDir, DSSRunnableResult commandResult, byte[] data) throws IOException {
        commandResult.type = ((DSSRunnableDesc)loaded.desc).resultType;
        commandResult.label = ((DSSRunnableDesc)loaded.desc).resultLabel;
        if (commandResult.type != null) {
            logger.info((Object)("Prepare " + data.length + " bytes of data as the runnable's output"));
            switch (commandResult.type) {
                case NONE: {
                    break;
                }
                case URL: {
                    commandResult.data = new ReportTargetItem.UrlItem(new String(data, StandardCharsets.UTF_8));
                    break;
                }
                case JSON_OBJECT: {
                    commandResult.data = new ReportTargetItem.JsonObjectItem((JsonObject)JSON.parse((byte[])data, JsonObject.class));
                    break;
                }
                case HTML: {
                    byte[] htmlContent = data;
                    if (htmlContent.length < 1024) {
                        commandResult.data = new ReportTargetItem.InlineHtmlItem(new String(htmlContent, StandardCharsets.UTF_8));
                        break;
                    }
                    File htmlFile = new File(contextDir, "out.html");
                    DKUFileUtils.mkdirsParent((File)htmlFile);
                    FileUtils.writeByteArrayToFile((File)htmlFile, (byte[])htmlContent);
                    commandResult.data = new ReportTargetItem.KeptFileItem(commandResult.type.name(), htmlFile.getName(), "application/html");
                    break;
                }
                case FILE: {
                    byte[] fileContent = data;
                    String extension = StringUtils.isNotBlank((String)((DSSRunnableDesc)loaded.desc).extension) ? ((DSSRunnableDesc)loaded.desc).extension : "txt";
                    File file = new File(contextDir, "out." + extension);
                    DKUFileUtils.mkdirsParent((File)file);
                    FileUtils.writeByteArrayToFile((File)file, (byte[])fileContent);
                    String mimeType = StringUtils.isNotBlank((String)((DSSRunnableDesc)loaded.desc).mimeType) ? ((DSSRunnableDesc)loaded.desc).mimeType : DKUtils.probeContentTypeWithFallback((File)file);
                    commandResult.data = new ReportTargetItem.KeptFileItem(commandResult.type.name(), file.getName(), mimeType);
                    break;
                }
                case FOLDER_FILE: {
                    List pair = (List)JSON.parse((String)new String(data, StandardCharsets.UTF_8), (TypeToken)new TypeToken<List<String>>(){});
                    if (pair.size() != 2) {
                        ErrorContext.iaef((String)"FILE result should be a pair of (folderId, path in folder), got %d values instead", (Object)pair.size(), (Object[])new Object[0]);
                    }
                    commandResult.data = new ReportTargetItem.ManagedFolderFileItem(projectKey, (String)pair.get(0), (String)pair.get(1));
                    break;
                }
                case RESULT_TABLE: {
                    if (data.length < 1024) {
                        commandResult.data = new ReportTargetItem.InlineResultTableItem((JsonObject)JSON.parse((InputStream)new ByteArrayInputStream(data), JsonObject.class));
                        break;
                    }
                    File htmlFile = new File(contextDir, "out.json");
                    DKUFileUtils.mkdirsParent((File)htmlFile);
                    FileUtils.writeByteArrayToFile((File)htmlFile, (byte[])data);
                    commandResult.data = new ReportTargetItem.KeptFileItem(commandResult.type.name(), htmlFile.getName(), "application/vnd.dataiku.resulttable");
                }
            }
        } else {
            logger.info((Object)"Runnable doesn't expect output");
        }
    }

    public static void waitEnd(final String projectKey, final LoadedRunnable<?> loaded, final DSSRunnableResult commandResult, AbstractImpersonableSecretProtectedPythonKernel<?> kernel, BasicKernelLink link, final File contextDir) throws IOException, InterruptedException {
        AbstractImpersonableSecretProtectedPythonKernel.LoopWithProgress<Void> loop = new AbstractImpersonableSecretProtectedPythonKernel.LoopWithProgress<Void>(){
            AbstractImpersonableSecretProtectedPythonKernel.PythonError error = null;

            @Override
            protected void handleError(SecretProtectedKernelLink link, DSSKernelBase kernel) throws IOException {
                this.error = (AbstractImpersonableSecretProtectedPythonKernel.PythonError)link.receiveJsonResponse(AbstractImpersonableSecretProtectedPythonKernel.PythonError.class);
                commandResult.failure = this.error.getSerializedThrowable();
                commandResult.logTail = kernel.getLogTail();
                if (commandResult.failure != null && commandResult.failure.stack.length() > 0) {
                    if (commandResult.logTail == null) {
                        commandResult.logTail = new SmartLogTail();
                    }
                    commandResult.logTail.lines.add("");
                    for (String elt : commandResult.failure.stack.split("\n")) {
                        commandResult.logTail.lines.add(elt);
                    }
                }
            }

            @Override
            protected void handleResult(SecretProtectedKernelLink link, DSSKernelBase kernel) throws IOException {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try {
                    link.receiveStream((OutputStream)baos, 0x100000);
                }
                catch (IOException e) {
                    throw new SocketBlockLinkIOException("Failed to receive result", (Throwable)e);
                }
                byte[] data = baos.toByteArray();
                DSSRunnableUtils.fillResult(projectKey, loaded, contextDir, commandResult, data);
            }

            @Override
            public AbstractImpersonableSecretProtectedPythonKernel.PythonError getError() {
                return this.error;
            }

            @Override
            public Void getResult() {
                return null;
            }
        };
        loop.runUntilDone("runnable", (SecretProtectedKernelLink)link, kernel);
    }
}

