/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.steps;

import com.dataiku.dip.scheduler.reports.ReportItem;
import com.dataiku.dip.scheduler.scenarios.ScenarioRun;
import com.dataiku.dip.scheduler.scenarios.ScenarioRunContext;
import com.dataiku.dip.scheduler.steps.Step;
import com.dataiku.dip.security.tickets.ContextAwareTicketPayload;
import com.dataiku.dip.server.SpringUtils;
import com.google.common.collect.Lists;
import java.util.List;

public class StepRun
implements ContextAwareTicketPayload {
    public ScenarioRun scenarioRun;
    public Step step;
    public String runId;
    public int retryIndex;
    public long start;
    public long end;
    public ReportItem result;
    public List<ReportItem> additionalReportItems = Lists.newArrayList();
    public Object payload;

    public ScenarioRun getScenarioRun() {
        return this.scenarioRun;
    }

    public AutoCloseable openTicketContext() {
        return new AutoCloseable(){
            private final ScenarioRun previousScenarioRun;
            private final StepRun previousStepRun;
            private ScenarioRunContext scenarioRunContext = (ScenarioRunContext)SpringUtils.getBean(ScenarioRunContext.class);
            {
                this.previousScenarioRun = this.scenarioRunContext.getScenarioRun();
                this.previousStepRun = this.scenarioRunContext.getStepRun();
                this.scenarioRunContext.setScenarioRun(StepRun.this.getScenarioRun());
                this.scenarioRunContext.setStepRun(StepRun.this);
            }

            @Override
            public void close() {
                this.scenarioRunContext.setScenarioRun(this.previousScenarioRun);
                this.scenarioRunContext.setStepRun(this.previousStepRun);
            }
        };
    }

    public Step getStep() {
        return this.step;
    }

    public String getRunId() {
        return this.runId;
    }

    public int getRetryIndex() {
        return this.retryIndex;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    public ReportItem getResult() {
        return this.result;
    }

    public List<ReportItem> getAdditionalReportItems() {
        return this.additionalReportItems;
    }

    public StepRun withScenarioRun(ScenarioRun scenarioRun) {
        this.scenarioRun = scenarioRun;
        return this;
    }

    public StepRun withStep(Step step) {
        this.step = step;
        return this;
    }

    public StepRun withRunId(String runId) {
        this.runId = runId;
        return this;
    }

    public StepRun withRetryIndex(int retryIndex) {
        this.retryIndex = retryIndex;
        return this;
    }

    public StepRun withStart(long start) {
        this.start = start;
        return this;
    }

    public StepRun withEnd(long end) {
        this.end = end;
        return this;
    }

    public StepRun withResult(ReportItem result) {
        this.result = result;
        return this;
    }
}

