/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security.audit.targets;

import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.KafkaConnection;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.audit.AuditObj;
import com.dataiku.dip.security.audit.model.KafkaTargetSettings;
import com.dataiku.dip.security.audit.targets.AuditTarget;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import java.io.IOException;
import java.util.Properties;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.springframework.beans.factory.annotation.Autowired;

public class KafkaTarget
extends AuditTarget {
    private DKULogger logger = DKULogger.getLogger((String)"dku.auditmechanism.event");
    @Autowired
    private ConnectionsDAO connectionsDAO;
    private KafkaTargetSettings settings;
    private KafkaProducer<Object, Object> producer;

    public KafkaTarget(KafkaTargetSettings settings) throws IOException, DKUSecurityException {
        SpringUtils.getInstance().autowire((Object)this);
        this.logger.info((Object)"Building a Kafka target");
        this.baseSettings = settings;
        this.settings = settings;
        KafkaConnection conn = (KafkaConnection)this.connectionsDAO.getConnection(DSSAuthCtx.newNone(), settings.connection);
        Properties props = conn.buildBasicProperties(DSSAuthCtx.newNone(), null);
        props.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        props.put("value.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        this.producer = new KafkaProducer(props);
    }

    public void handle(AuditObj auditObj) {
        AuditObj copy = (AuditObj)JSON.deepCopy((Object)auditObj);
        copy.get().addProperty("auditTopic", auditObj.topic);
        if (auditObj.routingKey != null) {
            copy.get().addProperty("auditRoutingKey", copy.routingKey);
        }
        copy.get().addProperty("timestamp", DKUDateUtils.isoFormatLocal((long)System.currentTimeMillis()));
        String value = JSON.json((Object)copy.get());
        ProducerRecord record = new ProducerRecord(this.settings.topic, (Object)value);
        this.producer.send(record);
    }

    public void shutdown() throws InterruptedException {
        this.producer.close();
    }
}

