/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.apideployer.deployments.APIServiceDeploymentsService;
import com.dataiku.dip.apideployer.deployments.ProjectDeploymentsService;
import com.dataiku.dip.apideployer.infra.ApiNodeInfrasService;
import com.dataiku.dip.apideployer.infra.AutomationNodeInfrasService;
import com.dataiku.dip.apideployer.published.PublishedAPIServicesService;
import com.dataiku.dip.apideployer.published.PublishedProjectsService;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.controllers.admin.AdminEditionController;
import com.dataiku.dip.server.datasets.DatasetDeletionService;
import com.dataiku.dip.server.notifications.backend.TaggableObjectChangedEvent;
import com.dataiku.dip.server.services.GitReferencesService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ProjectGitMergeRequestService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.licensing.LicenseEnforcementService;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.git.GitCodes;
import com.dataiku.dip.transactions.git.GitModel;
import com.dataiku.dip.transactions.git.cli.GitRemoteCommands;
import com.dataiku.dip.transactions.git.jgit.DSSVersionInfo;
import com.dataiku.dip.transactions.git.jgit.ProjectsJGitService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.SmartLogTail;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.NotMergedException;
import org.eclipse.jgit.lib.Repository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class ProjectGitController
extends DIPInternalControllerBase {
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private ProjectsJGitService projectsGitService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private ApiNodeInfrasService apiNodeInfrasService;
    @Autowired
    private AutomationNodeInfrasService automationNodeInfrasService;
    @Autowired
    private PublishedAPIServicesService publishedAPIServicesService;
    @Autowired
    private PublishedProjectsService publishedProjectsService;
    @Autowired
    private ProjectDeploymentsService projectDeploymentsService;
    @Autowired
    private APIServiceDeploymentsService apiServiceDeploymentsService;
    @Autowired
    private GitReferencesService gitRefsService;
    @Autowired
    private FutureService futureService;
    @Autowired
    private DatasetDeletionService datasetsDeletionService;
    @Autowired
    private RecipesDAO recipesDAO;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private ProjectGitMergeRequestService projectGitMergeRequestService;
    @Autowired
    private LicenseEnforcementService licenseEnforcementService;
    private static Logger logger = Logger.getLogger((String)"dku.controllers.projects.git");

    private void checkPermission(ITaggingService.TaggableType type, String id, AuthCtx user, String projectKey, boolean write) throws DKUSecurityException, IOException {
        switch (type) {
            case API_DEPLOYER_INFRA: {
                this.apiNodeInfrasService.getSettingsMandatoryUnsafe_CheckAdmin(id, user);
                break;
            }
            case API_DEPLOYER_SERVICE: {
                this.publishedAPIServicesService.getPublishedItemSettingsMandatoryUnsafe_Check(id, user);
                break;
            }
            case API_DEPLOYER_DEPLOYMENT: {
                if (write) {
                    this.apiServiceDeploymentsService.checkDeployPermissions(id, user);
                    break;
                }
                this.apiServiceDeploymentsService.getSettingsMandatoryUnsafe_Check(id, user);
                break;
            }
            case PROJECT_DEPLOYER_INFRA: {
                this.automationNodeInfrasService.getSettingsMandatoryUnsafe_CheckAdmin(id, user);
                break;
            }
            case PROJECT_DEPLOYER_PROJECT: {
                this.publishedProjectsService.getPublishedItemSettingsMandatoryUnsafe_Check(id, user);
                break;
            }
            case PROJECT_DEPLOYER_DEPLOYMENT: {
                if (write) {
                    this.projectDeploymentsService.checkDeployPermissions(id, user);
                    break;
                }
                this.projectDeploymentsService.getSettingsMandatoryUnsafe_Check(id, user);
                break;
            }
            case CODE_STUDIO_TEMPLATE: {
                if (this.permissionsService.hasCodeStudioTemplatePrivilege(user, id, write ? Privileges.CodeStudioTemplatePrivilegeType.UPDATE : Privileges.CodeStudioTemplatePrivilegeType.USE)) break;
                throw new DKUSecurityException("User cannot access template " + id);
            }
            default: {
                Privileges.ProjectLevelPrivilegeType privilegeType = write ? Privileges.ProjectLevelPrivilegeType.WRITE_CONF : Privileges.ProjectLevelPrivilegeType.READ_CONF;
                this.projectsService.checkPerm(user, projectKey, privilegeType);
            }
        }
    }

    @AuditedCall(value={"msgType", "object-commit-prepare", "projectKey", "${projectKey}", "objectType", "${objectType}", "objectId", "${objectId}"})
    @RequestMapping(value={"/api/git/prepare-object-commit"})
    public void prepareObjectCommit(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) String projectKey, @RequestParam String objectType, @RequestParam String objectId) throws Exception {
        TaggableObjectsService.TaggableObjectRef obj = new TaggableObjectsService.TaggableObjectRef(projectKey, ITaggingService.TaggableType.valueOf(objectType), objectId);
        try (Transaction t = this.transactionService.beginRead();){
            this.checkPermission(obj.type, obj.id, this.authService.getMandatoryUser(req), projectKey, false);
        }
        ProjectGitController.writeJSON((HttpServletResponse)resp, (Object)((Object)this.projectsGitService.prepareObjectCommit(obj)));
    }

    @AuditedCall(value={"msgType", "object-commit", "projectKey", "${projectKey}", "objectType", "${objectType}", "objectId", "${objectId}"})
    @RequestMapping(value={"/api/git/commit-object"})
    public void commitObject(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) String projectKey, @RequestParam String objectType, @RequestParam String objectId, @RequestParam String message) throws Exception {
        AuthCtx user;
        TaggableObjectsService.TaggableObjectRef obj = new TaggableObjectsService.TaggableObjectRef(projectKey, ITaggingService.TaggableType.valueOf(objectType), objectId);
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            this.checkPermission(obj.type, obj.id, user, projectKey, true);
        }
        this.projectsGitService.commitObject(obj, user, message);
    }

    @AuditedCall(value={"msgType", "add-git-tag", "projectKey", "${projectKey}", "objectType", "${objectType}", "objectId", "${objectId}", "reference", "${reference}", "name", "${name}"})
    @RequestMapping(value={"/api/git/tag"}, method={RequestMethod.POST})
    public void addObjectTag(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) String projectKey, @RequestParam String objectType, @RequestParam String objectId, @RequestParam(required=false) String reference, @RequestParam String name, @RequestParam(required=false) String message) throws Exception {
        AuthCtx user;
        TaggableObjectsService.TaggableObjectRef obj = new TaggableObjectsService.TaggableObjectRef(projectKey, ITaggingService.TaggableType.valueOf(objectType), objectId);
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            this.checkPermission(obj.type, obj.id, user, obj.projectKey, true);
        }
        if (GitModel.GitTag.isReadOnly((String)name)) {
            throw new DKUSecurityException("You can't add a tag beginning with 'dss-'");
        }
        this.projectsGitService.addLocalTag_NT(user, obj, name, message, reference);
    }

    @AuditedCall(value={"msgType", "remove-git-tag", "projectKey", "${projectKey}", "objectType", "${objectType}", "objectId", "${objectId}", "name", "${name}"})
    @RequestMapping(value={"/api/git/remove-tag"}, method={RequestMethod.POST})
    public void removeObjectTag(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) String projectKey, @RequestParam String objectType, @RequestParam String objectId, @RequestParam String name) throws Exception {
        TaggableObjectsService.TaggableObjectRef obj = new TaggableObjectsService.TaggableObjectRef(projectKey, ITaggingService.TaggableType.valueOf(objectType), objectId);
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.checkPermission(obj.type, obj.id, user, projectKey, true);
        }
        if (GitModel.GitTag.isReadOnly((String)name)) {
            throw new DKUSecurityException("You can't remove the read-only tag \"" + name + "\"");
        }
        this.projectsGitService.removeLocalTag_NT(obj, name);
    }

    @AuditedCall(value={"msgType", "object-get-log", "projectKey", "${projectKey}", "objectType", "${objectType}", "objectId", "${objectId}", "projectZone", "${projectZone}", "since", "${since}"})
    @RequestMapping(value={"/api/git/get-object-log"})
    public void getObjectLog(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) String projectKey, @RequestParam String objectType, @RequestParam String objectId, @RequestParam(required=false) String projectZone, @RequestParam(required=false) String since, @RequestParam(required=false, defaultValue="-1") int count) throws Exception {
        ITaggingService.TaggableType type = ITaggingService.TaggableType.valueOf(objectType);
        TaggableObjectsService.TaggableObjectRef obj = new TaggableObjectsService.TaggableObjectRef(projectKey, type, objectId);
        try (Transaction t = this.transactionService.beginRead();){
            this.checkPermission(obj.type, obj.id, this.authService.getMandatoryUser(req), projectKey, false);
        }
        String subPath = type == ITaggingService.TaggableType.PROJECT && StringUtils.isNotBlank((String)projectZone) ? AdminEditionController.GlobalCodeZone.valueOf(projectZone).getZoneSubPath() : null;
        ProjectGitController.writeJSON((HttpServletResponse)resp, (Object)((Object)this.projectsGitService.getObjectLog(obj, since, count, subPath)));
    }

    @AuditedCall(value={"msgType", "object-get-log", "projectKey", "${projectKey}", "objectType", "${objectType}", "objectId", "${objectId}", "branch", "${branch}", "since", "${since}"})
    @RequestMapping(value={"/api/git/get-object-log-since"})
    public void getObjectLogSince(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) String projectKey, @RequestParam String objectType, @RequestParam String objectId, @RequestParam(required=false) String branch, @RequestParam(required=false) String since, @RequestParam(required=false, defaultValue="-1") int count) throws Exception {
        TaggableObjectsService.TaggableObjectRef obj = new TaggableObjectsService.TaggableObjectRef(projectKey, ITaggingService.TaggableType.valueOf(objectType), objectId);
        try (Transaction t = this.transactionService.beginRead();){
            this.checkPermission(obj.type, obj.id, this.authService.getMandatoryUser(req), projectKey, false);
        }
        ProjectGitController.writeJSON((HttpServletResponse)resp, (Object)((Object)this.projectsGitService.getObjectLogSince(obj, branch, since, count)));
    }

    @AuditedCall(value={"msgType", "object-get-log-until", "projectKey", "${projectKey}", "objectType", "${objectType}", "objectId", "${objectId}", "branch", "${branch}", "until", "${until}"})
    @RequestMapping(value={"/api/git/get-object-log-until"})
    public void getObjectLogUntil(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String objectType, @RequestParam String objectId, @RequestParam(required=false) String branch, @RequestParam String until, @RequestParam int count) throws Exception {
        TaggableObjectsService.TaggableObjectRef obj = new TaggableObjectsService.TaggableObjectRef(projectKey, ITaggingService.TaggableType.valueOf(objectType), objectId);
        try (Transaction t = this.transactionService.beginRead();){
            this.checkPermission(obj.type, obj.id, this.authService.getMandatoryUser(req), projectKey, false);
        }
        ProjectGitController.writeJSON((HttpServletResponse)resp, (Object)((Object)this.projectsGitService.getObjectLogUntil(obj, branch, until, count)));
    }

    @AuditedCall(value={"msgType", "dss-version-commit", "projectKey", "${projectKey}", "hash", "${hash}"})
    @RequestMapping(value={"/api/git/dss-version-commit"})
    public void getDSSVersionForASpecificCommit(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String hash) throws Exception {
        TaggableObjectsService.TaggableObjectRef obj = new TaggableObjectsService.TaggableObjectRef(projectKey, ITaggingService.TaggableType.PROJECT, projectKey);
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.checkPermission(obj.type, obj.id, user, projectKey, false);
        }
        DSSVersionInfo dssVersionInfo = this.projectsGitService.getDSSVersionInfo(projectKey, hash);
        ProjectGitController.writeJSON((HttpServletResponse)resp, (Object)new DSSVersionForCommitResponse(dssVersionInfo.version, dssVersionInfo.isCommitFromPreviousDSSVersion(hash)));
    }

    @AuditedCall(value={"msgType", "object-revert", "projectKey", "${projectKey}", "objectType", "${objectType}", "objectId", "${objectId}", "toRevision", "${hash}"})
    @RequestMapping(value={"/api/git/revert-object-to-revision"})
    public void revertObjectToRevision(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) String projectKey, @RequestParam String objectType, @RequestParam String objectId, @RequestParam String hash) throws Exception {
        AuthCtx user;
        TaggableObjectsService.TaggableObjectRef obj = new TaggableObjectsService.TaggableObjectRef(projectKey, ITaggingService.TaggableType.valueOf(objectType), objectId);
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            this.checkPermission(obj.type, obj.id, user, projectKey, true);
        }
        this.projectsGitService.revertObjectToRevision(user, obj, hash);
    }

    @AuditedCall(value={"msgType", "project-revert", "projectKey", "${projectKey}", "toRevision", "${hash}", "projectZone", "${projectZone}"})
    @RequestMapping(value={"/api/git/revert-project-to-revision"})
    public void revertProjectToRevision(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String hash, @RequestParam(required=false) String projectZone) throws Exception {
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
        }
        if (StringUtils.isBlank((String)projectZone)) {
            ProjectGitController.writeJSON((HttpServletResponse)resp, (Object)this.projectsGitService.revertProjectToRevision(user, projectKey, hash));
        } else {
            AdminEditionController.GlobalCodeZone zone = AdminEditionController.GlobalCodeZone.valueOf(projectZone);
            ProjectGitController.writeJSON((HttpServletResponse)resp, (Object)this.projectsGitService.revertProjectZoneToRevision(user, projectKey, hash, zone));
        }
    }

    @AuditedCall(value={"msgType", "project-revert-commit", "projectKey", "${projectKey}", "objectRef", "${objectRef}", "commitId", "${hash}"})
    @RequestMapping(value={"/api/git/revert-single-commit"})
    public void revertSingleCommit(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) String projectKey, @RequestParam(required=false) String objectRef, @RequestParam String hash) throws Exception {
        AuthCtx user;
        TaggableObjectsService.TaggableObjectRef obj = StringUtils.isBlank((String)objectRef) ? new TaggableObjectsService.TaggableObjectRef(projectKey, ITaggingService.TaggableType.PROJECT, projectKey) : (TaggableObjectsService.TaggableObjectRef)JSON.parse((String)objectRef, TaggableObjectsService.TaggableObjectRef.class);
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            this.checkPermission(obj.type, obj.id, user, projectKey, true);
        }
        ProjectGitController.writeJSON((HttpServletResponse)resp, (Object)this.projectsGitService.revertSingleCommit(user, projectKey, hash));
    }

    @AuditedCall(value={"msgType", "project-get-diff", "projectKey", "${projectKey}", "objectRef", "${objectRef}", "commitId", "${commitId}"})
    @RequestMapping(value={"/api/git/get-commit-diff"})
    public void getObjectLog(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) String projectKey, @RequestParam(required=false) String objectRef, @RequestParam String commitId) throws Exception {
        TaggableObjectsService.TaggableObjectRef obj = objectRef == null ? new TaggableObjectsService.TaggableObjectRef(projectKey, ITaggingService.TaggableType.PROJECT, projectKey) : (TaggableObjectsService.TaggableObjectRef)JSON.parse((String)objectRef, TaggableObjectsService.TaggableObjectRef.class);
        try (Transaction t = this.transactionService.beginRead();){
            this.checkPermission(obj.type, obj.id, this.authService.getMandatoryUser(req), projectKey, false);
        }
        if (obj.type.isFakeType()) {
            if (projectKey != null) {
                throw new DKUSecurityException("Unauthorized project key for API/Project deployer git diff: " + projectKey);
            }
            if (!commitId.matches("^[a-fA-F0-9]+$")) {
                throw new DKUSecurityException("Unauthorized git ref for API/Project deployer git diff: " + commitId);
            }
        }
        ProjectGitController.writeJSON((HttpServletResponse)resp, (Object)this.projectsGitService.getSingleCommitDiff(projectKey, commitId));
    }

    @AuditedCall(value={"msgType", "project-get-diff", "projectKey", "${projectKey}", "commitFrom", "${commitFrom}", "commitTo", "${commitTo}", "objectRef", "${objectRef}"})
    @RequestMapping(value={"/api/git/get-revisions-diff"})
    public void getRevisionsDiff(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) String projectKey, @RequestParam String commitFrom, @RequestParam String commitTo, @RequestParam(required=false) String objectRef) throws Exception {
        TaggableObjectsService.TaggableObjectRef obj = objectRef == null ? new TaggableObjectsService.TaggableObjectRef(projectKey, ITaggingService.TaggableType.PROJECT, projectKey) : (TaggableObjectsService.TaggableObjectRef)JSON.parse((String)objectRef, TaggableObjectsService.TaggableObjectRef.class);
        try (Transaction t = this.transactionService.beginRead();){
            this.checkPermission(obj.type, obj.id, this.authService.getMandatoryUser(req), projectKey, false);
        }
        if (obj.type.isFakeType()) {
            if (projectKey != null) {
                throw new DKUSecurityException("Unauthorized project key for API/Project deployer git diff: " + projectKey);
            }
            if (!commitFrom.matches("^[a-fA-F0-9]+$")) {
                throw new DKUSecurityException("Unauthorized git ref for API/Project deployer git diff: " + commitFrom);
            }
            if (!commitTo.matches("^[a-fA-F0-9]+$")) {
                throw new DKUSecurityException("Unauthorized git ref for API/Project deployer git diff: " + commitTo);
            }
        }
        ProjectGitController.writeJSON((HttpServletResponse)resp, (Object)((Object)this.projectsGitService.getObjectDiff(obj, commitFrom, commitTo)));
    }

    @AuditedCall(value={"msgType", "project-git-pull", "projectKey", "${projectKey}", "remoteName", "${remoteName}", "branchName", "${branchName}"})
    @RequestMapping(value={"/api/projects/git/pull"})
    public void gitPull(HttpServletRequest req, HttpServletResponse resp, final @RequestParam String projectKey, final @RequestParam(required=false, defaultValue="origin") String remoteName, final @RequestParam(required=false, defaultValue="") String branchName) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.ADMIN);
        }
        ProjectGitController.writeJSON((HttpServletResponse)resp, this.futureService.runFuture(new SimpleFutureThread<GitRemoteCommands.GitCommandResult>(authCtx){
            DKUtils.SmartLogTailBuilder logTailBuilder;
            {
                super(owner);
                this.logTailBuilder = new DKUtils.SmartLogTailBuilder();
            }

            @Override
            protected GitRemoteCommands.GitCommandResult compute() throws Exception {
                return ProjectGitController.this.projectsGitService.pullRebase_NT(projectKey, remoteName, branchName, authCtx, this.logTailBuilder);
            }

            public FuturePayload getPayload() {
                return FuturePayload.newSimple((String)"project_git_pull", (String)"Git pull - project changes");
            }

            public SmartLogTail getLog() {
                return this.logTailBuilder.get();
            }
        }, 0L, new TypeToken<FutureResponse<GitRemoteCommands.GitCommandResult>>(){}));
    }

    @AuditedCall(value={"msgType", "project-git-fetch", "projectKey", "${projectKey}", "remoteName", "${remoteName}"})
    @RequestMapping(value={"/api/projects/git/fetch"})
    public void gitFetch(HttpServletRequest req, HttpServletResponse resp, final @RequestParam String projectKey, final @RequestParam(required=false, defaultValue="origin") String remoteName) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.ADMIN);
        }
        ProjectGitController.writeJSON((HttpServletResponse)resp, this.futureService.runFuture(new SimpleFutureThread<GitRemoteCommands.GitCommandResult>(authCtx){
            DKUtils.SmartLogTailBuilder logTailBuilder;
            {
                super(owner);
                this.logTailBuilder = new DKUtils.SmartLogTailBuilder();
            }

            @Override
            protected GitRemoteCommands.GitCommandResult compute() throws Exception {
                return ProjectGitController.this.projectsGitService.fetch_NT(projectKey, remoteName, authCtx, this.logTailBuilder);
            }

            public FuturePayload getPayload() {
                return FuturePayload.newSimple((String)"project_git_fetch", (String)"Git fetch - project changes");
            }

            public SmartLogTail getLog() {
                return this.logTailBuilder.get();
            }
        }, 0L, new TypeToken<FutureResponse<GitRemoteCommands.GitCommandResult>>(){}));
    }

    @AuditedCall(value={"msgType", "project-git-push", "projectKey", "${projectKey}", "remoteName", "${remoteName}", "branchName", "${branchName}"})
    @RequestMapping(value={"/api/projects/git/push"})
    public void gitPush(HttpServletRequest req, HttpServletResponse resp, final @RequestParam String projectKey, final @RequestParam(required=false, defaultValue="origin") String remoteName, final @RequestParam(required=false, defaultValue="") String branchName) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.ADMIN);
        }
        ProjectGitController.writeJSON((HttpServletResponse)resp, this.futureService.runFuture(new SimpleFutureThread<GitRemoteCommands.GitCommandResult>(authCtx){
            DKUtils.SmartLogTailBuilder logTailBuilder;
            {
                super(owner);
                this.logTailBuilder = new DKUtils.SmartLogTailBuilder();
            }

            @Override
            protected GitRemoteCommands.GitCommandResult compute() throws Exception {
                return ProjectGitController.this.projectsGitService.push_NT(authCtx, projectKey, remoteName, branchName, this.logTailBuilder);
            }

            public FuturePayload getPayload() {
                return FuturePayload.newSimple((String)"project_git_push", (String)"Git push - project changes");
            }

            public SmartLogTail getLog() {
                return this.logTailBuilder.get();
            }
        }, 0L, new TypeToken<FutureResponse<GitRemoteCommands.GitCommandResult>>(){}));
    }

    @AuditedCall(value={"msgType", "project-git-full-status", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/projects/git/get-full-status"})
    public void getFullStatus(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        ProjectGitController.writeJSON((HttpServletResponse)resp, (Object)this.projectsGitService.getFullStatus_NT(projectKey));
    }

    @AuditedCall(value={"msgType", "project-git-delete-branches", "projectKey", "${projectKey}", "forceDelete", "${forceDelete}", "remoteName", "${remoteName}", "remoteDelete", "${remoteDelete}"})
    @RequestMapping(value={"/api/projects/git/delete-branches"})
    public void deleteBranches(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam List<String> branchNames, @RequestParam boolean forceDelete, @RequestParam(defaultValue="origin") String remoteName, @RequestParam boolean remoteDelete) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.ADMIN);
        }
        GitModel.GitBranches existingBranches = this.projectsGitService.listBranches_NT(projectKey);
        for (String branchName : branchNames) {
            try {
                if (existingBranches.local.contains(branchName)) {
                    this.projectsGitService.deleteLocalBranch_NT(projectKey, branchName, forceDelete);
                }
                if (!StringUtils.isNotBlank((String)remoteName) || !existingBranches.remote.contains(remoteName + "/" + branchName)) continue;
                this.projectsGitService.deleteRemoteBranch_NT(authCtx, projectKey, branchName, forceDelete, remoteDelete, remoteName);
            }
            catch (NotMergedException e) {
                logger.info((Object)"Cannot delete branch as it contains unmerged changes", (Throwable)e);
                throw new CodedException((InfoMessage.MessageCode)GitCodes.ERR_GIT_DELETE_UNMERGED_BRANCH_FAILED, String.format("To delete '%s', select the option to delete branches even if they have not been merged, and try again.", branchName));
            }
        }
        ProjectGitController.writeJSON((HttpServletResponse)resp, (Object)"ok");
    }

    @AuditedCall(value={"msgType", "project-git-reset-to-upstream", "projectKey", "${projectKey}", "remoteName", "${remoteName}", "branchName", "${branchName}"})
    @RequestMapping(value={"/api/projects/git/reset-to-upstream"})
    public void resetToUpstream(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String remoteName, @RequestParam String branchName) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.ADMIN);
        }
        this.projectsGitService.resetToUpstream_NT(authCtx, projectKey, remoteName, branchName);
        ProjectGitController.writeJSON((HttpServletResponse)resp, (Object)"ok");
    }

    @AuditedCall(value={"msgType", "project-git-reset-to-head", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/projects/git/reset-to-head"})
    public void resetToHead(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.ADMIN);
        }
        this.projectsGitService.resetToHead_NT(authCtx, projectKey);
        ProjectGitController.writeJSON((HttpServletResponse)resp, (Object)"ok");
    }

    @AuditedCall(value={"msgType", "project-git-list-branches", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/projects/git/list-branches"})
    public void listBranches(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
        }
        Set<String> branches = this.projectsGitService.listAvailableBranches_NT(projectKey, false);
        ProjectGitController.writeJSON((HttpServletResponse)resp, branches);
    }

    @AuditedCall(value={"msgType", "project-git-list-branches-by-type", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/projects/git/list-branches-by-type"})
    public void listAllBranches(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
        }
        ProjectGitController.writeJSON((HttpServletResponse)resp, this.projectsGitService.listAvailableBranchesByType_NT(projectKey, false));
    }

    @AuditedCall(value={"msgType", "project-git-switch-branch", "projectKey", "${projectKey}", "branchName", "${branchName}", "clearOutputDatasets", "${clearOutputDatasets}"})
    @RequestMapping(value={"/api/projects/git/switch-branch"})
    public void switchBranch(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String branchName, @RequestParam boolean clearOutputDatasets) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.ADMIN);
        }
        DKUtils.SmartLogTailBuilder logTailBuilder = new DKUtils.SmartLogTailBuilder();
        SwitchBranchResult result = new SwitchBranchResult();
        GitRemoteCommands.GitCommandResult gitCommandResult = this.projectsGitService.checkoutBranch_NT(authCtx, projectKey, branchName.replaceFirst("^origin/", ""), logTailBuilder);
        result.commandSucceeded = gitCommandResult.commandSucceeded;
        result.commandError = gitCommandResult.commandError;
        result.messages = gitCommandResult.messages;
        result.log = logTailBuilder.get();
        if (result.commandSucceeded && clearOutputDatasets) {
            for (SerializedDataset dataset : this.listOutputDatasets(projectKey)) {
                InfoMessage.InfoMessages messages = this.datasetsDeletionService.clearDatasetData_NT(authCtx, Dataset.fromSerialized(dataset), false, true);
                result.messages.mergeFrom(messages);
            }
        }
        result.messages.summarize();
        ProjectGitController.writeJSON((HttpServletResponse)resp, (Object)result);
    }

    @AuditedCall(value={"msgType", "project-git-create-branch", "projectKey", "${projectKey}", "branchName", "${branchName}", "commitId", "${commitId}"})
    @RequestMapping(value={"/api/projects/git/create-branch"})
    public void createBranch(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String branchName, @RequestParam(required=false) String commitId) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.ADMIN);
        }
        if (!Repository.isValidRefName((String)("origin/" + branchName))) {
            throw new IllegalArgumentException("Unable to create branch because its name contains invalid characters: " + branchName);
        }
        try {
            if (!this.isUniqueBranchName(branchName, projectKey)) {
                throw new IllegalArgumentException("Unable to create branch because another branch with the same name already exists: " + branchName);
            }
        }
        catch (IOException | GitAPIException e) {
            logger.error((Object)("Unable to create branch: there was a problem accessing remote git branches for project " + projectKey), e);
            throw e;
        }
        ProjectGitController.writeJSON((HttpServletResponse)resp, (Object)this.projectsGitService.createBranch_NT(authCtx, projectKey, projectKey, branchName, commitId));
    }

    @AuditedCall(value={"msgType", "project-git-set-remote-repository", "projectKey", "${projectKey}", "remoteName", "${remoteName}", "remoteUrl", "${remoteUrl}"})
    @RequestMapping(value={"/api/projects/git/set-remote"}, method={RequestMethod.POST})
    public void setRemote(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String remoteName, @RequestParam String remoteUrl) throws Exception {
        boolean useRemoteGit;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.ADMIN);
            SerializedProject project = this.projectsService.getMandatoryUnsafe(projectKey);
            useRemoteGit = project != null && project.settings.useRemoteGit != null && project.settings.useRemoteGit != false;
        }
        String result = this.projectsGitService.addOrSetRepository_NT(projectKey, remoteName, remoteUrl, authCtx);
        this.projectsGitService.setUpstreamForLocalBranches_NT(authCtx, remoteName, projectKey);
        if (StringUtils.isNotBlank((String)remoteUrl) && !useRemoteGit) {
            try (RWTransaction rwt = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
                SerializedProject project = this.projectsService.getMandatory(projectKey);
                project.settings.useRemoteGit = true;
                this.projectsService.save(project, TaggableObjectChangedEvent.ProjectEditSubtype.LOCAL_SETTINGS_ONLY);
                rwt.commit("Setup git remote repository");
            }
        }
        ProjectGitController.writeJSON((HttpServletResponse)resp, (Object)result);
    }

    @AuditedCall(value={"msgType", "project-git-remove-remote-repository", "projectKey", "${projectKey}", "remoteName", "${remoteName}"})
    @RequestMapping(value={"/api/projects/git/rm-remote"})
    public void removeRemote(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String remoteName) throws Exception {
        boolean useRemoteGit;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.ADMIN);
            SerializedProject project = this.projectsService.getMandatoryUnsafe(projectKey);
            useRemoteGit = project != null && project.settings.useRemoteGit != null && project.settings.useRemoteGit != false;
        }
        String result = this.projectsGitService.removeRemoteRepository_NT(projectKey, remoteName, authCtx);
        if (useRemoteGit) {
            try (RWTransaction rwt = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
                SerializedProject project = this.projectsService.getMandatory(projectKey);
                project.settings.useRemoteGit = null;
                this.projectsService.save(project, TaggableObjectChangedEvent.ProjectEditSubtype.LOCAL_SETTINGS_ONLY);
                rwt.commit("Clear git remote repository");
            }
        }
        ProjectGitController.writeJSON((HttpServletResponse)resp, (Object)result);
    }

    @AuditedCall(value={"msgType", "project-get-ext-libs", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/git/get-project-external-libraries"})
    public void getExternalLibraries(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            ProjectGitController.writeJSON((HttpServletResponse)resp, (Object)this.gitRefsService.getProjectExternalLibraries(projectKey));
        }
    }

    @AuditedCall(value={"msgType", "project-set-git-ref", "projectKey", "${projectKey}", "gitReferencePath", "${gitReferencePath}"})
    @RequestMapping(value={"/api/git/set-project-git-ref"})
    @ResponseBody
    public GitReferencePath setProjectGitReference(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String gitReference, @RequestParam String gitReferencePath, @RequestParam String addPythonPath) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            this.licenseEnforcementService.checkGitInProjectLibrariesAllowed(t.getUser());
            GitModel.GitReference parsedGitRef = (GitModel.GitReference)JSON.parse((String)gitReference, GitModel.GitReference.class);
            RelFile libDirectory = AdminEditionController.GlobalCodeZone.LIB.getPath(projectKey);
            if (!libDirectory.appendPath_withoutDirectoryTraversalCheck(gitReferencePath).isStrictChildOf(libDirectory)) {
                throw new IllegalArgumentException("Supplied git reference path is invalid");
            }
            String refPath = this.gitRefsService.setProjectGitReference(projectKey, parsedGitRef, gitReferencePath, "true".equals(addPythonPath));
            t.commit("Set git ref");
            GitReferencePath gitReferencePath2 = new GitReferencePath(refPath);
            return gitReferencePath2;
        }
    }

    @AuditedCall(value={"msgType", "project-rm-git-ref", "projectKey", "${projectKey}", "gitReference", "${gitReferencePath}", "deleteDirectory", "${deleteDirectory}"})
    @RequestMapping(value={"/api/git/rm-project-git-ref"})
    public void removeProjectGitReference(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String gitReferencePath, @RequestParam boolean deleteDirectory) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            this.licenseEnforcementService.checkGitInProjectLibrariesAllowed(t.getUser());
            this.gitRefsService.removeProjectGitReference(projectKey, gitReferencePath, deleteDirectory);
            t.commit("rm git ref");
        }
    }

    @AuditedCall(value={"msgType", "project-pull-git-ref", "projectKey", "${projectKey}", "gitReference", "${gitReferencePath}"})
    @RequestMapping(value={"/api/git/pull-project-git-ref"})
    public void pullProjectGitReference(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String gitReferencePath) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            authCtx = this.authService.getMandatoryUser(req);
            this.licenseEnforcementService.checkGitInProjectLibrariesAllowed(authCtx);
        }
        ProjectGitController.writeJSON((HttpServletResponse)resp, this.gitRefsService.startPullProjectGitRef_NT(projectKey, gitReferencePath, authCtx));
    }

    @AuditedCall(value={"msgType", "get-project-git-refs", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/git/pull-project-git-refs"})
    public void pullProjectGitReferences(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            this.licenseEnforcementService.checkGitInProjectLibrariesAllowed(authCtx);
        }
        ProjectGitController.writeJSON((HttpServletResponse)resp, this.gitRefsService.startPullProjectGitRefs_NT(projectKey, authCtx));
    }

    @AuditedCall(value={"msgType", "project-push-git-ref", "projectKey", "${projectKey}", "commitMessage", "${commitMessage}", "gitReference", "${gitReferencePath}"})
    @RequestMapping(value={"/api/git/push-project-git-refs"})
    @ResponseBody
    public FutureResponse<InfoMessage.InfoMessages> pushProjectGitReferences(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String commitMessage, @RequestParam(required=false) String gitReferencePath) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            authCtx = this.authService.getMandatoryUser(req);
            this.licenseEnforcementService.checkGitInProjectLibrariesAllowed(authCtx);
        }
        if (gitReferencePath != null) {
            return this.gitRefsService.startPushProjectGitRef_NT(projectKey, commitMessage, gitReferencePath, authCtx);
        }
        return this.gitRefsService.startPushProjectGitRefs_NT(projectKey, commitMessage, authCtx);
    }

    @AuditedCall(value={"msgType", "revert-all-files", "projectKey", "${projectKey}", "gitLib", "${gitLib}"})
    @RequestMapping(value={"/api/git/revert-all-files"})
    @ResponseBody
    public void revertAllFiles(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String gitLib) throws IOException, DKUSecurityException, CodedException {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            authCtx = this.authService.getMandatoryUser(req);
            this.licenseEnforcementService.checkGitInProjectLibrariesAllowed(authCtx);
        }
        this.gitRefsService.revertLibrary(projectKey, gitLib, authCtx);
    }

    @AuditedCall(value={"msgType", "project-git-get-dirty", "projectKey", "${projectKey}", "gitLib", "${gitLib}"})
    @RequestMapping(value={"/api/projects/git/get-dirty"})
    public void getDirty(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam(required=false) String gitLib) throws IOException, DKUSecurityException, CodedException {
        boolean result = false;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            if (gitLib == null || gitLib.isEmpty()) {
                Map<String, GitModel.GitReference> projectGitReferences = this.gitRefsService.getProjectGitReferences(projectKey);
                result = projectGitReferences.values().stream().anyMatch(gitReference -> gitReference.isDirty);
            } else {
                GitModel.GitReference projectGitReference = this.gitRefsService.getProjectGitReference(projectKey, gitLib);
                if (projectGitReference != null) {
                    result = projectGitReference.isDirty;
                }
            }
        }
        ProjectGitController.writeJSON((HttpServletResponse)resp, (Object)result);
    }

    @AuditedCall(value={"msgType", "project-git-set-dirty-multiple", "projectKey", "${projectKey}", "gitLibs", "${gitLibs}"})
    @RequestMapping(value={"/api/projects/git/set-dirty"})
    public void setDirtyMultiple(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String gitLibs) throws IOException, DKUSecurityException, CodedException {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
        }
        String[] libs = (String[])JSON.parse((String)gitLibs, String[].class);
        this.gitRefsService.setDirty(projectKey, libs, authCtx);
    }

    @AuditedCall(value={"msgType", "mark-as-resolved", "projectKey", "${projectKey}", "fileName", "${fileName}", "gitLibPath", "${gitLibPath}"})
    @RequestMapping(value={"/api/git/mark-as-resolved"})
    @ResponseBody
    public void markAsResolved(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String fileName, @RequestParam String gitLibPath) throws IOException, DKUSecurityException, CodedException {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            authCtx = this.authService.getMandatoryUser(req);
        }
        this.gitRefsService.markAsResolved(projectKey, fileName, gitLibPath, authCtx);
    }

    @AuditedCall(value={"msgType", "project-git-list-projects-matching-remote-repository", "projectKey", "${projectKey}", "branchName", "${branchName}"})
    @RequestMapping(value={"/api/projects/git/list-projects-matching-remote-repository"})
    public void listProjectsMatchingRemoteRepository(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String branchName) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.ADMIN);
        }
        ArrayList<ProjectMatchingRemoteRepository> result = new ArrayList<ProjectMatchingRemoteRepository>();
        GitModel.GitFullStatus gitStatus = this.projectsGitService.getFullStatus_NT(projectKey);
        if (StringUtils.isNotBlank((String)branchName) && gitStatus.remotes != null && !gitStatus.remotes.isEmpty()) {
            ArrayList<SerializedProject> matchingProjects = new ArrayList<SerializedProject>();
            try (Transaction ignored = this.transactionService.beginRead();){
                for (SerializedProject currentProject : this.projectsService.listAllUnsafe()) {
                    if (currentProject.projectKey.equals(projectKey) || currentProject.settings.useRemoteGit == null || !currentProject.settings.useRemoteGit.booleanValue() || !this.permissionsService.hasProjectPrivilege(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF)) continue;
                    matchingProjects.add(currentProject);
                }
            }
            for (SerializedProject currentProject : matchingProjects) {
                GitModel.GitFullStatus currentProjectGitStatus = this.projectsGitService.getFullStatus_NT(currentProject.projectKey);
                if (!branchName.equals(currentProjectGitStatus.currentBranch) || currentProjectGitStatus.remotes == null || !ProjectGitController.matchRemote((List<GitModel.GitRemote>)currentProjectGitStatus.remotes, gitStatus.remotes)) continue;
                result.add(new ProjectMatchingRemoteRepository(currentProject));
            }
        }
        ProjectGitController.writeJSON((HttpServletResponse)resp, result);
    }

    private boolean isUniqueBranchName(String branchName, String projectKey) throws IOException, GitAPIException {
        GitModel.GitBranches existingBranches = this.projectsGitService.listBranches_NT(projectKey);
        return !existingBranches.remote.contains(branchName);
    }

    private static boolean matchRemote(List<GitModel.GitRemote> list1, List<GitModel.GitRemote> list2) {
        for (GitModel.GitRemote remote2 : list2) {
            if (!ProjectGitController.matchRemote(list1, remote2)) continue;
            return true;
        }
        return false;
    }

    private static boolean matchRemote(List<GitModel.GitRemote> remotes, GitModel.GitRemote remote) {
        if (remote != null && remote.url != null) {
            for (GitModel.GitRemote gitRemote : remotes) {
                if (!remote.url.equals(gitRemote.url)) continue;
                return true;
            }
        }
        return false;
    }

    private Collection<SerializedDataset> listOutputDatasets(@RequestParam String projectKey) throws IOException {
        try (Transaction t = this.transactionService.beginRead();){
            HashMap<String, SerializedDataset> datasetToClear = new HashMap<String, SerializedDataset>();
            for (SerializedRecipe recipe : this.recipesDAO.list(projectKey)) {
                for (SerializedRecipe.RecipeOutput flatOutput : recipe.getFlatOutputs()) {
                    SerializedDataset dataset = (SerializedDataset)this.datasetsDAO.getOrNull(flatOutput.getLoc(projectKey));
                    if (dataset == null || datasetToClear.containsKey(dataset.getId())) continue;
                    datasetToClear.put(dataset.getId(), dataset);
                }
            }
            Collection collection = datasetToClear.values();
            return collection;
        }
    }

    public static class DSSVersionForCommitResponse {
        public String dssVersion;
        public boolean commitFromPreviousDSSVersion;

        public DSSVersionForCommitResponse(String dssVersion, boolean commitFromPreviousDSSVersion) {
            this.dssVersion = dssVersion;
            this.commitFromPreviousDSSVersion = commitFromPreviousDSSVersion;
        }
    }

    private static class SwitchBranchResult {
        public SmartLogTail log;
        public InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
        public boolean commandSucceeded;
        public SerializedError commandError;

        private SwitchBranchResult() {
        }
    }

    public static class GitReferencePath {
        public String refPath;

        public GitReferencePath() {
        }

        public GitReferencePath(String refPath) {
            this.refPath = refPath;
        }
    }

    private static class ProjectMatchingRemoteRepository {
        public final String projectKey;
        public final String projectName;

        ProjectMatchingRemoteRepository(SerializedProject project) {
            this.projectKey = project.projectKey;
            this.projectName = project.name;
        }
    }
}

