/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers.analysis;

import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.prediction.DeephubImagesDataService;
import com.dataiku.dip.analysis.ml.prediction.PredictedDataService;
import com.dataiku.dip.analysis.ml.prediction.PredictionPivotTablesService;
import com.dataiku.dip.expressions.Expression;
import com.dataiku.dip.futures.DSSFuturePayloadUtils;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.FutureThread;
import com.dataiku.dip.pivot.backend.dss.aggregators.LinoColumnFactory;
import com.dataiku.dip.pivot.backend.model.PivotTableRequest;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.shaker.ShakerUtils;
import com.dataiku.dip.shaker.filter.FilterRequest;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.shaker.server.MemScriptRunner;
import com.dataiku.dip.shaker.server.SerializedMemTableV2;
import com.dataiku.dip.shaker.server.SerializedTableChunk;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.google.gson.reflect.TypeToken;
import com.google.refine.udaf.UdafControlFunctionRegistry;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.log4j.NDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class AnalysisPredictedDataController
extends DIPInternalControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private FutureService futureService;
    @Autowired
    private PredictedDataService predictedDataService;
    @Autowired
    private DeephubImagesDataService deephubImagesDataService;
    @Autowired
    private PredictionPivotTablesService predictionPivotTablesService;
    @Autowired
    private VariablesService variablesService;
    private static final Logger logger = Logger.getLogger((String)"dku.analysis");

    public static FuturePayload buildFuturePayload(FullModelId fmi) {
        FuturePayload fp = new FuturePayload();
        fp.action = "refresh_predicted";
        fp.targets.add(DSSFuturePayloadUtils.forFMI(fmi).withPart("predicted"));
        fp.displayName = "Refreshing predicted values table";
        return fp;
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/analysis/predicted/refresh-table"})
    public void refreshTable(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullModelId, @RequestParam String displayScript, @RequestParam(value="allowCache", required=false, defaultValue="false") boolean allowCache, @RequestParam(value="filters", required=false, defaultValue="") String filters) throws Exception {
        FullModelId fmi = FullModelId.parse(fullModelId);
        SerializedShakerScript sss = (SerializedShakerScript)JSON.parse((String)displayScript, SerializedShakerScript.class);
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, fmi.getTaskLoc().analysisProjectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            RefreshTableFutureThread ft = new RefreshTableFutureThread((DSSAuthCtx)user, allowCache, fmi, sss, (FilterRequest)JSON.parse((String)filters, FilterRequest.class));
            AnalysisPredictedDataController.writeJSON((HttpServletResponse)resp, this.futureService.runFuture(ft, 2000L, new TypeToken<FutureResponse<SerializedMemTableV2>>(){}));
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/analysis/predicted/get-table-chunk"})
    public void getTableChunk(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullModelId, @RequestParam String displayScript, @RequestParam int firstRow, @RequestParam int nbRows, @RequestParam int firstCol, @RequestParam int nbCols, @RequestParam String filters) throws Exception {
        FullModelId fmi = FullModelId.parse(fullModelId);
        SerializedShakerScript sss = (SerializedShakerScript)JSON.parse((String)displayScript, SerializedShakerScript.class);
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, fmi.getTaskLoc().analysisProjectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        MemScriptRunner.TableWithReport twr = this.predictedDataService.getUncachedFiltered_NT(fmi, sss, (FilterRequest)JSON.parse((String)filters, FilterRequest.class));
        SerializedTableChunk stc = new SerializedTableChunk(firstRow, nbRows, firstCol, nbCols);
        stc.fill(twr.table, twr.filters, sss.coloring, sss.columnsSelection);
        AnalysisPredictedDataController.writeJSON((HttpServletResponse)resp, (Object)stc);
    }

    @AuditedCall(value={"msgType", "predicted-refresh-images-feed-data", "fullModelId", "${fullModelId}"})
    @RequestMapping(value={"api/analysis/predicted/refresh-images-data-sample"})
    public void refreshPredictedImages(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullModelId, @RequestParam int nbRows, @RequestParam(required=false) DeephubImagesDataService.ComputerVisionPredictedFilter filters) throws Exception {
        FullModelId fmi = FullModelId.parse(fullModelId);
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, fmi.getProjectKey(), Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        SerializedMemTableV2 smt = this.deephubImagesDataService.refreshPredictedImagesDataSample(fmi, filters, nbRows);
        AnalysisPredictedDataController.writeJSON((HttpServletResponse)resp, (Object)smt);
    }

    @AuditedCall(value={"msgType", "predicted-refresh-images-feed-data", "fullModelId", "${fullModelId}"})
    @RequestMapping(value={"api/analysis/predicted/get-images-data-chunk"})
    public void getPredictedImagesChunk(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullModelId, @RequestParam int firstRow, @RequestParam(required=false) Integer nbRows, @RequestParam(required=false) DeephubImagesDataService.ComputerVisionPredictedFilter filters) throws Exception {
        FullModelId fmi = FullModelId.parse(fullModelId);
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, fmi.getProjectKey(), Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        SerializedTableChunk stc = this.deephubImagesDataService.getPredictedImagesDataChunk(fmi, firstRow, nbRows, filters);
        AnalysisPredictedDataController.writeJSON((HttpServletResponse)resp, (Object)stc);
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/analysis/predicted/detailed-column-analysis"})
    public void detailedColumnAnalysis(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullModelId, @RequestParam String data, @RequestParam String column, @RequestParam int alphanumMaxResults) throws Exception {
        FullModelId fmi = FullModelId.parse(fullModelId);
        SerializedShakerScript ss = (SerializedShakerScript)JSON.parse((String)data, SerializedShakerScript.class);
        ss.contextProjectKey = fmi.getProjectKey();
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, fmi.getProjectKey(), Privileges.ProjectLevelPrivilegeType.READ_CONF);
            ShakerUtils.checkScriptCodePermission(user, ss);
        }
        AnalysisPredictedDataController.writeJSON((HttpServletResponse)resp, (Object)this.predictedDataService.getDetailedColumnAnalysis(fmi, ss, column, alphanumMaxResults));
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/analysis/predicted/charts-get-columns-summary"})
    public void predictedChartsGetColumnSummary(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullModelId) throws Exception {
        FullModelId fmi = FullModelId.parse(fullModelId);
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, fmi.getProjectKey(), Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        AnalysisPredictedDataController.writeJSON((HttpServletResponse)resp, (Object)this.predictionPivotTablesService.getColumnSummary_NT(fmi));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AuditNotNeeded
    @RequestMapping(value={"/api/analysis/predicted/charts-get-pivot-response"})
    public void predictedChartsGetPivotResponse(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullModelId, @RequestParam String request, @RequestParam String requestedSampleId) throws Exception {
        NDC.push((String)("pivot-" + fullModelId));
        try {
            AuthCtx user;
            FullModelId fmi = FullModelId.parse(fullModelId);
            try (Transaction t = this.transactionService.beginRead();){
                this.projectsService.checkPerm(req, fmi.getProjectKey(), Privileges.ProjectLevelPrivilegeType.READ_CONF);
                user = this.authService.getMandatoryUser(req);
            }
            PivotTableRequest preq = (PivotTableRequest)JSON.parse((String)request, PivotTableRequest.class);
            AnalysisPredictedDataController.writeJSON((HttpServletResponse)resp, this.predictionPivotTablesService.getResponse_NT(preq, fmi, user));
        }
        finally {
            NDC.pop();
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/analysis/predicted/fix-expression"})
    public void fixExpression(HttpServletRequest req, HttpServletResponse resp, String fullModelId, String expression) throws Exception {
        FullModelId fmi = FullModelId.parse(fullModelId);
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, fmi.getProjectKey(), Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        VariablesContext vc = this.variablesService.getContext(fmi.getProjectKey());
        LinoColumnFactory columnsFactory = this.predictionPivotTablesService.getColumnsFactory(fmi);
        if (columnsFactory == null) {
            AnalysisPredictedDataController.writeJSON((HttpServletResponse)resp, (Object)expression);
            return;
        }
        Expression expr = new Expression(expression, UdafControlFunctionRegistry.getInstance());
        expr.setColumnFactory(columnsFactory);
        expr.setVariablesContext(vc);
        expr.fixupPlus();
        AnalysisPredictedDataController.writeJSON((HttpServletResponse)resp, (Object)expr.getString());
    }

    class RefreshTableFutureThread
    extends FutureThread<SerializedMemTableV2> {
        final FullModelId fmi;
        final SerializedShakerScript displayScript;
        final FilterRequest frequest;
        final boolean allowCache;
        final FuturePayload futurePayload;
        SerializedMemTableV2 result;

        public RefreshTableFutureThread(DSSAuthCtx user, boolean allowCache, FullModelId fmi, SerializedShakerScript sss, FilterRequest filterRequest) {
            super(user);
            this.result = new SerializedMemTableV2();
            this.allowCache = allowCache;
            this.fmi = fmi;
            this.displayScript = sss;
            this.frequest = filterRequest;
            this.futurePayload = AnalysisPredictedDataController.buildFuturePayload(fmi);
        }

        public SerializedMemTableV2 getResult() {
            return this.result;
        }

        public FuturePayload getPayload() {
            return this.futurePayload;
        }

        public double getDangerosity() {
            return 0.0;
        }

        public void execute() throws Exception {
            NDC.push((String)("refresh-pml-table: " + String.valueOf(this.fmi)));
            try {
                MemScriptRunner.TableWithReport twr = AnalysisPredictedDataController.this.predictedDataService.getUncachedFiltered_NT(this.fmi, this.displayScript, this.frequest);
                this.result.fill(twr, this.displayScript, 64, 32);
            }
            catch (Exception e) {
                logger.error((Object)"Failed to get table data", (Throwable)e);
                throw e;
            }
            finally {
                NDC.pop();
            }
        }
    }
}

