/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.datasets;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.memimpl.MemColumn;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamRowFactory;
import com.dataiku.dip.datasets.EditableDatasetConfig;
import com.dataiku.dip.datasets.inline.InlineDatasetHandler;
import com.dataiku.dip.output.InlineDataOutputWriter;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.utils.ErrorContext;
import javax.annotation.Nullable;

public class EditableDatasetProcessorOutput
implements ProcessorOutput {
    private final Dataset dataset;
    private final InlineDatasetHandler dsHandler;
    private final InlineDataOutputWriter dataOutput;
    private final InlineDataOutputWriter changesOutput;
    final RowFactory rf = new StreamRowFactory();
    final ColumnFactory cf = new StreamColumnFactory();
    private MemTable inputDSChanges;
    private final int maxRows;
    private int emittedRowCount;
    private int rowIndex;

    public EditableDatasetProcessorOutput(InlineDatasetHandler dsHandler, int maxRows) throws Exception {
        this.dsHandler = dsHandler;
        this.dataset = dsHandler.getDataset();
        this.dataOutput = dsHandler.buildDataOutput(null, 0, 0, null).getWriter(Output.WriteMode.OVERWRITE);
        this.dataOutput.init(this.cf);
        if (this.dataset.getParamsAs(EditableDatasetConfig.class).keepTrackOfChanges()) {
            this.changesOutput = dsHandler.buildChangesOutput(null, 0, 0, null).getWriter(Output.WriteMode.OVERWRITE);
            this.changesOutput.init(this.cf);
        } else {
            this.changesOutput = null;
        }
        this.maxRows = maxRows;
        this.emittedRowCount = 0;
    }

    public void importChangesFrom(@Nullable MemTable inputDSChanges) {
        this.inputDSChanges = inputDSChanges;
        this.rowIndex = 0;
    }

    public void emitRow(Row row) throws Exception {
        if (this.emittedRowCount >= this.maxRows) {
            throw ErrorContext.iaef((String)"Editable datasets should not have more than %d records.", (Object)this.maxRows, (Object[])new Object[0]);
        }
        this.emitDataRow(row);
        if (this.changesOutput != null) {
            this.emitChangesRow();
        }
        ++this.emittedRowCount;
    }

    private void emitDataRow(Row row) throws Exception {
        Row drow = this.rf.row();
        for (SchemaColumn sc : this.dataset.getSchema().columns) {
            String colName = sc.getName();
            Column col = this.cf.column(colName);
            drow.put(col, row.get(col));
        }
        this.dataOutput.emitRow(drow);
    }

    private void emitChangesRow() throws Exception {
        if (this.inputDSChanges != null && this.rowIndex >= this.inputDSChanges.nrows()) {
            throw ErrorContext.iae((String)"Provided input dataset changes should have the same number of rows as the input dataset itself.");
        }
        Row crow = this.rf.row();
        for (SchemaColumn sc : this.dataset.getSchema().columns) {
            String colName = sc.getName();
            Column col = this.cf.column(colName);
            if (this.inputDSChanges != null && this.inputDSChanges.getColumn(colName) != null) {
                Row changesRow = this.inputDSChanges.rows.get(this.rowIndex);
                MemColumn changesCol = this.inputDSChanges.getColumn(colName);
                crow.put(col, changesRow.get((Column)changesCol));
                continue;
            }
            crow.put(col, false);
        }
        this.changesOutput.emitRow(crow);
        ++this.rowIndex;
    }

    public void lastRowEmitted() throws Exception {
        this.dataOutput.lastRowEmitted();
        if (this.changesOutput != null) {
            this.changesOutput.lastRowEmitted();
        } else {
            this.dsHandler.clearChanges();
        }
    }

    public void cancel() throws Exception {
        this.dataOutput.cancel();
        if (this.changesOutput != null) {
            this.changesOutput.cancel();
        }
    }

    public void setMaxMemoryUsed(long size) {
        this.dataOutput.setMaxMemoryUsed(size);
        if (this.changesOutput != null) {
            this.changesOutput.setMaxMemoryUsed(size);
        }
    }
}

