/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.datastory;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.datastory.DatastoryIntegrationService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PermissionsService;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.licensing.LicenseEnforcementService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class DatastoryIntegrationController
extends DIPInternalControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private PermissionsService permissionsService;
    @Autowired
    private DatastoryIntegrationService dataStoryIntegrationService;
    @Autowired
    private LicenseEnforcementService licenseEnforcementService;

    @AuditedCall(value={"msgType", "datastory-integration-check"})
    @RequestMapping(value={"/api/admin/datastory-integration-check"})
    public void checkIntegration(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        AuthCtx authCtx;
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        this.permissionsService.checkAdmin(authCtx);
        if (!this.licenseEnforcementService.getFeaturesStatus().storiesAllowed) {
            throw new SecurityException("Stories usage is not authorized by your license");
        }
        InfoMessage.InfoMessages infoMessages = this.dataStoryIntegrationService.testDatastoryIntegration(authCtx);
        DatastoryIntegrationController.writeJSON((HttpServletResponse)resp, (Object)infoMessages);
    }
}

