/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.intercom.t;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.MLTaskLoc;
import com.dataiku.dip.analysis.ml.distributed.workers.WorkerInfos;
import com.dataiku.dip.analysis.ml.distributed.workers.WorkerService;
import com.dataiku.dip.analysis.ml.prediction.CustomPythonPredictionAlgoService;
import com.dataiku.dip.analysis.ml.prediction.LoadedCustomPythonPredictionAlgoDesc;
import com.dataiku.dip.analysis.model.prediction.PostTrainPredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.PreTrainPredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.algorithms.PredictionAlgorithmMeta;
import com.dataiku.dip.analysis.model.prediction.assertions.MLAssertionsParams;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.containers.exec.ContainerExecUtils;
import com.dataiku.dip.containers.exec.WorkloadType;
import com.dataiku.dip.dataflow.pipeline.OverridesHelper;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.auth.TicketAuthService;
import com.dataiku.dip.security.impersonation.FilesystemACLUtils;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.JSON;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class MachineLearningIntercomController
extends DIPInternalControllerBase {
    @Autowired
    CustomPythonPredictionAlgoService pythonPredictionModelService;
    @Autowired
    private TicketAuthService authService;
    @Autowired
    private WorkerService workerService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private FutureService futureService;
    public static final int DEFAULT_MAX_NB_TIMESERIES_IN_FORECAST_CHARTS = 1000;
    public static final int DEFAULT_MAX_COLUMNS_TO_EXPLAIN = 50;

    @AuditNotNeeded
    @RequestMapping(value={"/api/tintercom/ml/prediction/regridify-to-pretrain"})
    public void setActive(HttpServletRequest req, HttpServletResponse resp, @RequestParam String preTrain, @RequestParam String postTrain) throws Exception {
        PreTrainPredictionModelingParams preTrainObj = (PreTrainPredictionModelingParams)JSON.parse((String)preTrain, PreTrainPredictionModelingParams.class);
        PostTrainPredictionModelingParams postTrainObj = (PostTrainPredictionModelingParams)JSON.parse((String)postTrain, PostTrainPredictionModelingParams.class);
        PredictionAlgorithmMeta meta = preTrainObj.algorithm.meta;
        PreTrainPredictionModelingParams ptpmp = meta.regridifyToPreTrain(postTrainObj, preTrainObj);
        MachineLearningIntercomController.writeJSON((HttpServletResponse)resp, (Object)ptpmp);
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/tintercom/ml/plugins/get-algo-params"})
    public void getAlgoParams(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam String algoId) throws Exception {
        this.authService.getAndUseMandTicket(req).close();
        LoadedCustomPythonPredictionAlgoDesc modelDesc = this.pythonPredictionModelService.get(pluginId, algoId);
        MachineLearningIntercomController.writeJSON((HttpServletResponse)resp, (Object)modelDesc.desc);
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/tintercom/ml/available-container-configurations"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> getAvailableContainerConfigurations(HttpServletRequest req, @RequestParam String type) throws Exception {
        try (APITicketService.TicketUsage tu = this.authService.getAndUseMandTicket(req);){
            ContainerExecRuntimeConfig.Container containerType = ContainerExecRuntimeConfig.Container.valueOf(type);
            List<String> list = ContainerExecUtils.getAllowedContainerNames(tu.getAuthCtx(), Collections.singletonList(containerType), WorkloadType.USER_CODE);
            return list;
        }
    }

    @AuditedCall(value={"msgType", "mlhp-remote-worker-request", "workerPoolId", "${workerPoolId}"})
    @RequestMapping(value={"/api/tintercom/ml/distributed/request-worker"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public WorkerInfos requestWorker(HttpServletRequest req, @RequestParam String workerPoolId, @RequestParam String workerId) throws Exception {
        try (APITicketService.TicketUsage tu = this.authService.getAndUseMandTicket(req);){
            WorkerInfos workerInfos = this.workerService.getWorkerPool(tu.getAuthCtx(), workerPoolId).requestWorker(workerId);
            return workerInfos;
        }
    }

    @AuditedCall(value={"msgType", "mlhp-remote-worker-release", "workerPoolId", "${workerPoolId}"})
    @RequestMapping(value={"/api/tintercom/ml/distributed/release-worker"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public void releaseWorker(HttpServletRequest req, @RequestParam String workerPoolId, @RequestParam String workerId) throws Exception {
        try (APITicketService.TicketUsage tu = this.authService.getAndUseMandTicket(req);){
            this.workerService.getWorkerPool(tu.getAuthCtx(), workerPoolId).releaseWorker(workerId);
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/tintercom/ml/generate-steps-from-filters"})
    public void generateStepsFromFilters(HttpServletResponse resp, @RequestParam OverridesHelper.Request request) throws Exception {
        OverridesHelper.Response scriptData = OverridesHelper.generateScriptData(request);
        MachineLearningIntercomController.writeJSON((HttpServletResponse)resp, (Object)scriptData);
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/tintercom/ml/generate-steps-from-assertions"})
    public void generateStepsFromAssertions(HttpServletResponse resp, @RequestParam List<MLAssertionsParams.MLAssertion> assertions) throws Exception {
        MachineLearningIntercomController.writeJSON((HttpServletResponse)resp, (Object)MLAssertionsParams.generateScriptData(assertions));
    }

    @AuditedCall(value={"msgType", "ml-prediction-model-get-max-nb-timeseries-in-forecast-charts"})
    @RequestMapping(value={"/api/tintercom/ml/prediction/get-max-nb-timeseries-in-forecast-charts"})
    @ResponseBody
    public int getMaxNbTimeseriesInForecastCharts(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try (APITicketService.TicketUsage tu = this.authService.getAndUseMandTicket(req);){
            int n = ApplicationConfigurator.getParams().getIntParam("dku.ml.timeseries.maxNbTimeseriesInForecastCharts", Integer.valueOf(1000));
            return n;
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/tintercom/ml/prediction/get-max-columns-to-explain"})
    @ResponseBody
    public int getMaxColumnsToExplain(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try (APITicketService.TicketUsage tu = this.authService.getAndUseMandTicket(req);){
            int n = ApplicationConfigurator.getParams().getIntParam("dku.ml.ufi.maxColumnsToExplain", Integer.valueOf(50));
            return n;
        }
    }

    @AuditedCall(value={"msgType", "ml-prediction-grant-fs-read-acls", "projectKey", "${projectKey}", "analysisId", "${analysisId}", "mlTaskId", "${mlTaskId}", "sessionId", "${sessionId}", "preprocessingId", "${preprocessingId}", "modelId", "${modelId}"})
    @RequestMapping(value={"/api/tintercom/ml/grant-fs-read-acls"})
    public void grantFSReadACLs(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fmi) throws Exception {
        try (APITicketService.TicketUsage ticketUsage = this.authService.getAndUseMandTicket(req);){
            AuthCtx authCtx = ticketUsage.getAuthCtx();
            FullModelId parsedFmi = FullModelId.parse(fmi);
            try (Transaction t = this.transactionService.beginRead();){
                this.projectsService.failIfNoReadAccess(authCtx, parsedFmi.getUnderlyingStore(), parsedFmi.getProjectKey());
            }
            if (parsedFmi.exists()) {
                FilesystemACLUtils.grantFSReadACLs(authCtx, parsedFmi.getProjectKey(), parsedFmi.getFolderEnsuringSecurity());
            }
        }
    }

    @AuditedCall(value={"msgType", "ml-get-model-folders-info", "fmi", "${fmi}"})
    @RequestMapping(value={"/api/tintercom/ml/get-model-folders-info"})
    @ResponseBody
    public ModelFoldersInfo getModelFoldersInfo(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fmi) throws Exception {
        try (APITicketService.TicketUsage ignored = this.authService.getAndUseMandTicket(req);){
            FullModelId parsedFmi = FullModelId.parse(fmi);
            ModelFoldersInfo modelFoldersInfo = ModelFoldersInfo.fromFullModelId(parsedFmi);
            return modelFoldersInfo;
        }
    }

    @AuditedCall(value={"msgType", "ml-get-model-partitions-fmis", "fmi", "${fmi}"})
    @RequestMapping(value={"/api/tintercom/ml/get-model-partitions-fmis"})
    @ResponseBody
    public Map<String, String> getModelPartitionsFmis(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fmi) throws Exception {
        try (APITicketService.TicketUsage ignored = this.authService.getAndUseMandTicket(req);){
            FullModelId parsedFmi = FullModelId.parse(fmi);
            Map<String, String> map = parsedFmi.getPartitionsFmiStrings();
            return map;
        }
    }

    @AuditedCall(value={"msgType", "ml-get-model-type-info", "fmi", "${fmi}"})
    @RequestMapping(value={"/api/tintercom/ml/get-model-type-info"})
    @ResponseBody
    public ModelTypeInfo getModelTypeInfo(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fmi) throws Exception {
        try (APITicketService.TicketUsage ignored = this.authService.getAndUseMandTicket(req);){
            FullModelId parsedFmi = FullModelId.parse(fmi);
            ModelTypeInfo modelTypeInfo = ModelTypeInfo.fromFullModelId(parsedFmi);
            return modelTypeInfo;
        }
    }

    public static class ModelFoldersInfo {
        public final String sessionFolder;
        public final String modelFolder;
        public final String preprocessingFolder;
        public final String splitFolder;
        @Nullable
        public final String splitDescFilename;

        public ModelFoldersInfo(String sessionFolder, String modelFolder, String preprocessingFolder, String splitFolder, String splitDescFilename) {
            this.sessionFolder = sessionFolder;
            this.modelFolder = modelFolder;
            this.preprocessingFolder = preprocessingFolder;
            this.splitFolder = splitFolder;
            this.splitDescFilename = splitDescFilename;
        }

        public static ModelFoldersInfo fromFullModelId(FullModelId fmi) throws IOException {
            String splitDescFilename = null;
            File splitDescFile = fmi.getSplitDescFile();
            if (splitDescFile != null) {
                splitDescFilename = splitDescFile.getName();
            }
            return new ModelFoldersInfo(fmi.getSessionFolder().getAbsolutePath(), fmi.getModelFolder().getAbsolutePath(), fmi.getPreprocessingFolder().getAbsolutePath(), fmi.getSplitFolder().getAbsolutePath(), splitDescFilename);
        }
    }

    public static class ModelTypeInfo {
        public final FullModelId.Type type;
        public final String projectKey;
        @Nullable
        public final String analysisId;
        @Nullable
        public final String mlTaskId;
        @Nullable
        public final String savedModelId;
        public final boolean isPartitionedBaseModel;

        public ModelTypeInfo(FullModelId.Type type, String projectKey, @Nullable String analysisId, @Nullable String mlTaskId, @Nullable String savedModelId, boolean isPartitionedBaseModel) {
            this.type = type;
            this.projectKey = projectKey;
            this.analysisId = analysisId;
            this.mlTaskId = mlTaskId;
            this.savedModelId = savedModelId;
            this.isPartitionedBaseModel = isPartitionedBaseModel;
        }

        public static ModelTypeInfo fromFullModelId(FullModelId fmi) throws IOException {
            FullModelId.Type type = fmi.getType();
            String smId = null;
            if (type.equals((Object)FullModelId.Type.SAVED)) {
                smId = fmi.getSavedModelID();
            }
            String analysisId = null;
            String mlTaskId = null;
            if (type.equals((Object)FullModelId.Type.ANALYSIS)) {
                MLTaskLoc taskLoc = fmi.getTaskLoc();
                analysisId = taskLoc.analysisId;
                mlTaskId = taskLoc.mlTaskId;
            }
            return new ModelTypeInfo(type, fmi.getProjectKey(), analysisId, mlTaskId, smId, fmi.isPartitionedBaseModel());
        }
    }
}

