/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.notifications;

import com.dataiku.dip.server.notifications.DSSEvent;
import com.dataiku.dip.server.notifications.Notification;
import com.dataiku.dip.server.notifications.frontend.BroadcastEvent;
import com.dataiku.dip.server.notifications.frontend.LogEvent;
import com.dataiku.dip.server.notifications.frontend.PingEvent;
import com.dataiku.dip.server.notifications.frontend.TimeoutableTaskKeepAlive;
import com.dataiku.dip.server.notifications.frontend.UIIdleStateChangedEvent;
import com.dataiku.dip.server.notifications.frontend.UIStateChangedEvent;
import com.dataiku.dip.server.notifications.frontend.WatchListChangedEvent;
import com.dataiku.dip.util.GPUMonitoringService;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

public class EventRegistry {
    private static Map<String, Class<? extends DSSEvent>> map = new HashMap<String, Class<? extends DSSEvent>>();

    public static void register(String type, Class<? extends DSSEvent> eventClass) {
        map.put(type, eventClass);
    }

    public static Class<? extends DSSEvent> getClassForType(String type) {
        Class<? extends DSSEvent> clazz = map.get(type);
        if (clazz == null) {
            throw new IllegalArgumentException("The event type " + type + " doesn't exist.");
        }
        return clazz;
    }

    public static boolean canBeDeserialized(String type) {
        return map.containsKey(type);
    }

    public static void loadClass() {
    }

    static {
        EventRegistry.register("ping", PingEvent.class);
        EventRegistry.register("ui-state-changed", UIStateChangedEvent.class);
        EventRegistry.register("ui-idle-state-changed", UIIdleStateChangedEvent.class);
        EventRegistry.register("watch-list-changed", WatchListChangedEvent.class);
        EventRegistry.register("ui-broadcast", BroadcastEvent.class);
        EventRegistry.register("log-event", LogEvent.class);
        EventRegistry.register("timeoutable-task-keepalive", TimeoutableTaskKeepAlive.class);
        EventRegistry.register("gpu-monitoring-start", GPUMonitoringService.GpuStatsStartEvent.class);
        JSON.registerAdapter(Notification.class, (Object)new JsonDeserializer<Notification>(){

            public Notification deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
                JsonObject jsonObj = jsonElement.getAsJsonObject();
                if (jsonObj.has("type")) {
                    Class<? extends DSSEvent> clazz = EventRegistry.getClassForType(jsonObj.getAsJsonPrimitive("type").getAsString());
                    DSSEvent evt = (DSSEvent)jsonDeserializationContext.deserialize(jsonObj.get("event"), clazz);
                    return Notification.of(evt);
                }
                throw new RuntimeException("Unable to deserialize invalid event.");
            }
        });
    }
}

