/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.notifications.emails;

import com.dataiku.dip.plugins.PluginStoreService;
import com.dataiku.dip.plugins.model.StorePluginsList;
import com.dataiku.dip.security.model.PublicUser;
import com.dataiku.dip.server.notifications.EmailNotificationsSender;
import com.dataiku.dip.server.notifications.backend.AbstractRequestEvent;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UserSettingsService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import freemarker.template.TemplateException;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractPluginRequestEmailBuilder<T extends AbstractRequestEvent> {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UsersService usersService;
    @Autowired
    private PluginStoreService storePluginService;
    protected static final Logger logger = Logger.getLogger((String)"dku.notifications.plugin.request.granted");

    abstract String makeSubject(T var1, PublicUser var2, String var3);

    protected abstract String makeBody(T var1, PublicUser var2, String var3) throws IOException, TemplateException;

    protected abstract String getRequestTypeLabel(T var1);

    protected void sendToUser(T evt, String user) throws Exception {
        PublicUser srcUser;
        PublicUser dstUser;
        try (Transaction ignored = this.transactionService.beginRead();){
            dstUser = this.usersService.getPublicUser(user);
            srcUser = this.usersService.getPublicUser(evt.getUserLogin());
        }
        if (StringUtils.isBlank((String)dstUser.email)) {
            return;
        }
        StorePluginsList.StorePlugin storePluginDesc = this.storePluginService.getStorePluginDesc(((AbstractRequestEvent)evt).getObjectId()).orElseThrow(() -> new IllegalArgumentException("No plugin found for id " + evt.getObjectId()));
        UserSettingsService.EmailNotificationsSettings params = new UserSettingsService.EmailNotificationsSettings();
        params.enabled = true;
        params.subject = "Dataiku \u2022 " + this.makeSubject(evt, srcUser, storePluginDesc.meta.label);
        EmailNotificationsSender sender = new EmailNotificationsSender();
        logger.info((Object)("Sending email to " + dstUser.login));
        sender.sendToUser(dstUser.email, params, this.makeBody(evt, srcUser, storePluginDesc.meta.label));
    }
}

