/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.recipes;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataflow.exec.QueryGenerationUtils;
import com.dataiku.dip.dataflow.exec.filter.FilterDesc;
import com.dataiku.dip.datasets.DatasetSelection;
import com.dataiku.dip.partitioning.DimensionValue;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.sql.H2SQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.ExpressionUtils;
import com.dataiku.dip.sql.queries.QueryAst;
import com.dataiku.dip.sql.queries.SelectQueryBuilder;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;

public class SamplingQueryGenerator {
    protected ExpressionBuilder.ExpressionBuilderFactory ef = new ExpressionBuilder.ExpressionBuilderFactory();
    protected FilterDesc filter;
    protected Dataset source;
    protected Dataset outputDataset;
    protected SQLUtils.SQLTable sqlTable;
    private final DatasetSelection selection;
    protected PartitioningScheme sourcePartitionScheme;
    protected List<Partition> sourcePartitions;
    protected PartitioningScheme targetPartitionScheme;
    private Partition targetPartition;
    static DKULogger logger = DKULogger.getLogger((String)"dku.recipes.sampling");

    public SamplingQueryGenerator(FilterDesc filter, Dataset source, Dataset outputDataset, SQLUtils.SQLTable sqlTable, DatasetSelection selection) {
        this.outputDataset = outputDataset;
        Preconditions.checkNotNull((Object)source);
        this.filter = filter;
        this.source = source;
        this.sqlTable = sqlTable;
        this.selection = selection;
    }

    public void setPartitioning(PartitioningScheme sourcePartitionScheme, List<Partition> sourcePartitions, PartitioningScheme targetPartitionScheme, Partition targetPartition) {
        this.sourcePartitionScheme = sourcePartitionScheme;
        this.sourcePartitions = sourcePartitions;
        this.targetPartitionScheme = targetPartitionScheme;
        this.targetPartition = targetPartition;
    }

    public String generateSQL(SQLDialect dialect) {
        return this.generateQuery(dialect).toSQL(dialect);
    }

    public static boolean handlesSamplingMethod(DatasetSelection selection, SQLDialect dialect) {
        return SamplingQueryGenerator.getRandomSampleClauseLocation(selection, dialect) != SQLDialect.RandomSampleClauseLocation.NOT_SUPPORTED;
    }

    private static SQLDialect.RandomSampleClauseLocation getRandomSampleClauseLocation(DatasetSelection selection, SQLDialect dialect) {
        if (selection == null) {
            return SQLDialect.RandomSampleClauseLocation.NOT_SUPPORTED;
        }
        return dialect.getRandomSampleClauseLocation(selection.samplingMethod, selection.maxRecords, selection.targetRatio, selection.seed);
    }

    public SelectQueryBuilder generateQuery(SQLDialect dialect) {
        Schema producedSchema;
        Schema selectedSchema;
        Schema inputSchema = this.source.getSchema();
        if (inputSchema == null) {
            throw ErrorContext.iae((String)"Input dataset has no schema");
        }
        SelectQueryBuilder query = new SelectQueryBuilder();
        boolean ignoreFilterTranslationError = dialect instanceof H2SQLDialect;
        SQLDialect.RandomSampleClauseLocation randomSampleClauseLocation = SamplingQueryGenerator.getRandomSampleClauseLocation(this.selection, dialect);
        QueryAst.SampleClause sample = null;
        if (randomSampleClauseLocation != SQLDialect.RandomSampleClauseLocation.NOT_SUPPORTED) {
            logger.debug((Object)"Random sampling will be done in database");
            sample = QueryAst.SampleClause.sampleClause(this.selection);
        }
        query.from(this.sqlTable, null, randomSampleClauseLocation == SQLDialect.RandomSampleClauseLocation.FROM ? sample : null);
        QueryGenerationUtils.preFilter(query, this.filter, dialect, this.source, ignoreFilterTranslationError);
        HashMap partitionValues = Maps.newHashMap();
        if (this.targetPartition != null) {
            partitionValues.putAll(this.targetPartition.getDimensionValues());
        }
        if (this.outputDataset != null) {
            selectedSchema = new Schema();
            producedSchema = new Schema();
            boolean canCheckUsingLowercase = true;
            HashMap lowercasedColumns = Maps.newHashMap();
            for (SchemaColumn c2 : inputSchema.getColumns()) {
                String lowercased = c2.getName().toLowerCase();
                if (lowercasedColumns.containsKey(lowercased)) {
                    canCheckUsingLowercase = false;
                    break;
                }
                lowercasedColumns.put(lowercased, c2);
            }
            for (SchemaColumn column : this.outputDataset.getSchema().getColumns()) {
                SchemaColumn inputColumn = canCheckUsingLowercase ? (SchemaColumn)lowercasedColumns.get(column.getName().toLowerCase()) : inputSchema.getColumn(column.getName());
                if (inputColumn == null) {
                    if (!partitionValues.containsKey(column.getName())) {
                        throw ErrorContext.iae((String)("Column " + column.getName() + " not in input"));
                    }
                    producedSchema.addColumn(column);
                    selectedSchema.addColumn(column);
                    continue;
                }
                producedSchema.addColumn(column);
                selectedSchema.addColumn(inputColumn);
            }
        } else {
            selectedSchema = inputSchema;
            producedSchema = inputSchema;
        }
        SQLDialect.InsertIntoCaster insertIntoCaster = dialect.getInsertIntoCaster(this.outputDataset);
        for (int i = 0; i < selectedSchema.getColumns().size(); ++i) {
            SchemaColumn schemaColumn = (SchemaColumn)selectedSchema.getColumns().get(i);
            SchemaColumn outputColumn = (SchemaColumn)producedSchema.getColumns().get(i);
            ExpressionBuilder col = partitionValues.containsKey(schemaColumn.getName()) ? this.ef.dstPartitionValue(schemaColumn, (DimensionValue)partitionValues.get(schemaColumn.getName()), dialect) : ExpressionUtils.getAdjustedColumn(this.ef.col(schemaColumn.getName()), schemaColumn, this.source, dialect);
            query.select(insertIntoCaster.castIfNeeded(col, outputColumn), outputColumn.getName());
        }
        if (this.sourcePartitionScheme != null && this.sqlTable.isTrueTable()) {
            ExpressionBuilder partitionFilterExpression = ExpressionUtils.getPartitionFilterClause(this.sourcePartitionScheme, this.source, this.sourcePartitions, dialect);
            query.where(partitionFilterExpression);
        }
        if (randomSampleClauseLocation == SQLDialect.RandomSampleClauseLocation.WHERE) {
            query.where(new ExpressionBuilder.ExpressionBuilderFactory().expr(dialect.getRandomSampleClause(sample)));
        } else if (randomSampleClauseLocation == SQLDialect.RandomSampleClauseLocation.ORDER_BY_AND_LIMIT) {
            query.order(new ExpressionBuilder.ExpressionBuilderFactory().expr(dialect.getRandomSampleClause(sample)));
            query.limit(this.selection.maxRecords);
        }
        return query;
    }
}

