/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.services.IJupyterService;
import com.dataiku.dip.server.services.JupyterUtils;
import com.dataiku.dip.server.services.SQLNotebooksService;
import com.dataiku.dip.sqlnotebooks.SQLNotebook;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DatasetNotebookService {
    @Autowired
    private SQLNotebooksService sqlNbService;
    @Autowired
    private IJupyterService jupyterNbService;
    @Autowired
    private SQLNotebooksService sqlNotebooksService;

    public SimpleNotebook getRecipeNotebookUnsafe(String projectKey, String recipeName) throws IOException {
        for (JupyterUtils.JupyterNotebookListEntry jupy : this.jupyterNbService.listUnsafe(DSSAuthCtx.newNone(), projectKey)) {
            if (!recipeName.equals(jupy.associatedRecipe)) continue;
            return new SimpleNotebook(jupy);
        }
        for (SQLNotebook sqlNotebook : this.sqlNotebooksService.listWithoutTimelineUnsafe(projectKey)) {
            if (!recipeName.equals(sqlNotebook.recipeId)) continue;
            return new SimpleNotebook(sqlNotebook);
        }
        return null;
    }

    public List<SimpleNotebook> listDatasetNotebooks(String projectKey, String datasetSmartName) throws IOException {
        return this.listDatasetNotebooks(projectKey, datasetSmartName, false);
    }

    public List<SimpleNotebook> listDatasetNotebooksUnsafe(String projectKey, String datasetSmartName) throws IOException {
        return this.listDatasetNotebooks(projectKey, datasetSmartName, true);
    }

    protected List<SimpleNotebook> listDatasetNotebooks(String projectKey, String datasetSmartName, boolean unsafe) throws IOException {
        SimpleNotebook nb;
        List<JupyterUtils.JupyterNotebookListEntry> jupyters;
        List<SQLNotebook> sqls;
        if (unsafe) {
            sqls = this.sqlNbService.listWithoutTimelineUnsafe(projectKey);
            jupyters = this.jupyterNbService.listUnsafe(DSSAuthCtx.newNone(), projectKey);
        } else {
            sqls = this.sqlNbService.listWithoutTimeline(projectKey);
            jupyters = this.jupyterNbService.listSimple(DSSAuthCtx.newNone(), projectKey);
        }
        LinkedList<SimpleNotebook> results = new LinkedList<SimpleNotebook>();
        for (SQLNotebook sql : sqls) {
            if (!datasetSmartName.equals(sql.analyzedDataset)) continue;
            nb = new SimpleNotebook(sql);
            results.add(nb);
        }
        for (JupyterUtils.JupyterNotebookListEntry jupy : jupyters) {
            if (!datasetSmartName.equals(jupy.analyzedDataset)) continue;
            nb = new SimpleNotebook(jupy);
            results.add(nb);
        }
        return results;
    }

    public static class SimpleNotebook {
        public String projectKey;
        public long lastModified;
        public String creator;
        public String name;
        public NotebookType type;
        public String id;
        public String connection;
        public String language;
        public String associatedRecipe;
        public String analyzedDataset;

        SimpleNotebook(JupyterUtils.JupyterNotebookListEntry jupy) {
            this.type = NotebookType.JUPYTER;
            this.projectKey = jupy.projectKey;
            this.associatedRecipe = jupy.associatedRecipe;
            this.analyzedDataset = jupy.analyzedDataset;
            this.lastModified = jupy.lastModifiedOn;
            this.creator = jupy.creator;
            this.name = jupy.name;
            this.id = jupy.getId();
            this.language = jupy.language;
        }

        SimpleNotebook(SQLNotebook sql) {
            this.type = NotebookType.SQL;
            this.projectKey = sql.projectKey;
            this.analyzedDataset = sql.analyzedDataset;
            if (sql.creationTag != null) {
                this.creator = sql.creationTag.getLastAuthor();
            }
            if (sql.versionTag != null) {
                this.lastModified = sql.versionTag.getLastModifiedOn();
            }
            this.name = sql.name;
            this.id = sql.id;
            this.connection = sql.connection;
        }
    }

    public static enum NotebookType {
        SQL,
        JUPYTER;

    }
}

