/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.staticdata;

import com.dataiku.dip.formats.FormatFactory;
import com.dataiku.dip.formats.FormatMeta;
import com.dataiku.dip.formats.custom.CustomJavaFormatMeta;
import com.dataiku.dip.formats.custom.CustomPythonFormatMeta;
import com.dataiku.dip.i18n.TranslationService;
import com.dataiku.dip.server.staticdata.AbstractExpressionSyntax;
import java.util.HashMap;
import java.util.Map;

public class DatasetFormatTypes
extends AbstractExpressionSyntax {
    public DatasetFormatTypes(TranslationService translationService, String lang) {
        super(translationService, lang);
    }

    @Override
    public String getKey() {
        return "datasetFormatTypes";
    }

    @Override
    public Object getData() {
        return this.getFormatTypes();
    }

    private Map<String, FormatFactory.SerializedFormatType> getFormatTypes() {
        HashMap<String, FormatFactory.SerializedFormatType> types = new HashMap<String, FormatFactory.SerializedFormatType>();
        for (FormatMeta<?, ?> type : FormatFactory.getAllMeta()) {
            FormatMeta customType;
            if (type instanceof CustomPythonFormatMeta) {
                customType = (CustomPythonFormatMeta)type;
                if (!((CustomPythonFormatMeta)customType).canBeDatasetFormat()) continue;
                types.put(type.getType(), new FormatFactory.SerializedCustomFormatType((CustomPythonFormatMeta)customType, this.translationService, this.lang));
                continue;
            }
            if (type instanceof CustomJavaFormatMeta) {
                customType = (CustomJavaFormatMeta)type;
                if (!((CustomJavaFormatMeta)customType).canBeDatasetFormat()) continue;
                types.put(type.getType(), new FormatFactory.SerializedCustomFormatType((CustomJavaFormatMeta)customType, this.translationService, this.lang));
                continue;
            }
            types.put(type.getType(), new FormatFactory.SerializedFormatType(type, this.translationService, this.lang));
        }
        return types;
    }
}

