/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.memimpl.MemColumn;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.server.recipes.ShakerRecipeService;
import com.dataiku.dip.shaker.types.Boolean;
import com.dataiku.dip.shaker.types.Date;
import com.dataiku.dip.shaker.types.DateOnly;
import com.dataiku.dip.shaker.types.DatetimeNoTz;
import com.dataiku.dip.shaker.types.GeoPoint;
import com.dataiku.dip.shaker.types.GeometryMeaning;
import com.dataiku.dip.shaker.types.JSONArrayMeaning;
import com.dataiku.dip.shaker.types.JSONObjectMeaning;
import com.dataiku.dip.utils.DKULogger;

public class TableToSchema {
    private static DKULogger logger = DKULogger.getLogger((String)"dku.shaker.schema");

    public static Schema inferSchemaForML(MemTable table, boolean safe, String forOutputDatasetType) {
        Schema schema = new Schema();
        for (Column c2 : table.columns()) {
            MemColumn mc = (MemColumn)c2;
            SchemaColumn newCol = new SchemaColumn(c2.getName(), Type.STRING);
            if (mc.selectedType != null) {
                boolean advancedTypePossible = !safe || safe && mc.selectedType.nbFails == 0;
                logger.info((Object)("Column " + mc.getName() + " meaning=" + mc.selectedType.type.getMeaningId() + " fail=" + mc.selectedType.nbFails));
                if (mc.selectedType.type instanceof Date) {
                    if (advancedTypePossible) {
                        newCol.setType(Type.DATE);
                    } else {
                        newCol.downcastedToStringFromMeaning = "Date";
                    }
                } else if (mc.selectedType.type instanceof DateOnly) {
                    if (advancedTypePossible) {
                        newCol.setType(Type.DATEONLY);
                    } else {
                        newCol.downcastedToStringFromMeaning = "DateOnly";
                    }
                } else if (mc.selectedType.type instanceof DatetimeNoTz) {
                    if (advancedTypePossible) {
                        newCol.setType(Type.DATETIMENOTZ);
                    } else {
                        newCol.downcastedToStringFromMeaning = "DatetimeNoTz";
                    }
                } else if (mc.selectedType.type instanceof Boolean) {
                    if (safe && mc.selectedType.nbFails == 0 || !safe) {
                        newCol.setType(Type.BOOLEAN);
                    } else {
                        newCol.downcastedToStringFromMeaning = "Boolean";
                    }
                } else if (mc.selectedType.type instanceof JSONArrayMeaning) {
                    if (safe && mc.selectedType.nbFails == 0 || !safe) {
                        newCol.setType(Type.STRING);
                    } else {
                        newCol.downcastedToStringFromMeaning = "Array";
                    }
                } else if (mc.selectedType.type.isLong()) {
                    if (safe && mc.selectedType.nbFails == 0 || !safe) {
                        newCol.setType(Type.BIGINT);
                    } else {
                        newCol.downcastedToStringFromMeaning = mc.selectedType.type.getMeaningId();
                    }
                } else if (mc.selectedType.type.isDouble()) {
                    if (safe && mc.selectedType.nbFails == 0 || !safe) {
                        newCol.setType(Type.DOUBLE);
                    } else {
                        newCol.downcastedToStringFromMeaning = mc.selectedType.type.getMeaningId();
                    }
                }
            }
            if (forOutputDatasetType != null) {
                ShakerRecipeService.fixupImpossibleStorageTypes(forOutputDatasetType, newCol);
            }
            schema.addColumn(newCol);
        }
        return schema;
    }

    public static Schema inferSchemaSimple(MemTable table, boolean safe) {
        Schema schema = new Schema();
        for (Column c2 : table.columns()) {
            boolean advancedTypePossible;
            MemColumn mc = (MemColumn)c2;
            SchemaColumn newCol = new SchemaColumn(c2.getName(), Type.STRING);
            boolean bl = advancedTypePossible = !safe || safe && mc.selectedType.nbFails == 0;
            if (mc.selectedType != null) {
                if (mc.selectedType.type instanceof Date) {
                    if (advancedTypePossible) {
                        newCol.setType(Type.DATE);
                    } else {
                        newCol.downcastedToStringFromMeaning = "Date";
                    }
                } else if (mc.selectedType.type instanceof DateOnly) {
                    if (advancedTypePossible) {
                        newCol.setType(Type.DATEONLY);
                    } else {
                        newCol.downcastedToStringFromMeaning = "DateOnly";
                    }
                } else if (mc.selectedType.type instanceof DatetimeNoTz) {
                    if (advancedTypePossible) {
                        newCol.setType(Type.DATETIMENOTZ);
                    } else {
                        newCol.downcastedToStringFromMeaning = "DatetimeNoTz";
                    }
                } else if (mc.selectedType.type instanceof GeoPoint) {
                    if (safe && mc.selectedType.nbFails == 0 || !safe) {
                        newCol.setType(Type.GEOPOINT);
                    } else {
                        newCol.downcastedToStringFromMeaning = "GeoPoint";
                    }
                } else if (mc.selectedType.type instanceof GeometryMeaning) {
                    if (safe && mc.selectedType.nbFails == 0 || !safe) {
                        newCol.setType(Type.GEOMETRY);
                    } else {
                        newCol.downcastedToStringFromMeaning = "Geometry";
                    }
                } else if (mc.selectedType.type instanceof Boolean) {
                    if (safe && mc.selectedType.nbFails == 0 || !safe) {
                        newCol.setType(Type.BOOLEAN);
                    } else {
                        newCol.downcastedToStringFromMeaning = "Boolean";
                    }
                } else if (mc.selectedType.type instanceof JSONObjectMeaning) {
                    if (safe && mc.selectedType.nbFails == 0 || !safe) {
                        newCol.setType(Type.OBJECT);
                    } else {
                        newCol.downcastedToStringFromMeaning = "Object";
                    }
                } else if (mc.selectedType.type instanceof JSONArrayMeaning) {
                    if (safe && mc.selectedType.nbFails == 0 || !safe) {
                        newCol.setType(Type.ARRAY);
                    } else {
                        newCol.downcastedToStringFromMeaning = "Array";
                    }
                } else if (mc.selectedType.type.isLong()) {
                    if (safe && mc.selectedType.nbFails == 0 || !safe) {
                        newCol.setType(Type.BIGINT);
                    } else {
                        newCol.downcastedToStringFromMeaning = mc.selectedType.type.getMeaningId();
                    }
                } else if (mc.selectedType.type.isDouble()) {
                    if (safe && mc.selectedType.nbFails == 0 || !safe) {
                        newCol.setType(Type.DOUBLE);
                    } else {
                        newCol.downcastedToStringFromMeaning = mc.selectedType.type.getMeaningId();
                    }
                }
            }
            schema.addColumn(newCol);
        }
        return schema;
    }
}

