/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.model;

import com.dataiku.dip.exceptions.UnavailableTypeException;
import com.dataiku.dip.shaker.ProcessorWithRecordedReport;
import com.dataiku.dip.shaker.model.GroupScriptStep;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.ScriptStep;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.dip.variables.OverrideTable;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public enum ScriptStepDeserializer implements JSON.Adapter<ScriptStep>
{
    INSTANCE;

    private static final Map<String, Class<? extends StepParams>> typeToParamType;
    private static final Logger logger;

    public static void registerStepParams(String type, Class<? extends StepParams> stepParamClass) {
        typeToParamType.put(type, stepParamClass);
    }

    public ScriptStep deserialize(JsonElement jsonElement, Type scriptType, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        JsonElement designTimeReportJson;
        JsonElement secondaryColorJson;
        JsonElement mainColorJson;
        JsonElement alwaysShowCommentJson;
        JsonElement commentJson;
        JsonElement previewJson;
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        JsonElement mtElt = jsonObj.get("metaType");
        if (mtElt == null) {
            mtElt = new JsonPrimitive(ScriptStep.MetaType.PROCESSOR.toString());
        }
        ProcessorScriptStep genericStep = null;
        if (mtElt.getAsString().equals(ScriptStep.MetaType.PROCESSOR.toString())) {
            String type;
            scriptStep = new ProcessorScriptStep();
            scriptStep.metaType = ScriptStep.MetaType.PROCESSOR;
            genericStep = scriptStep;
            scriptStep.type = type = jsonObj.get("type").getAsString();
            Class<? extends StepParams> stepParamClass = typeToParamType.get(type);
            if (stepParamClass == null) {
                String pluginId = "unknown";
                if (type.startsWith("jython-processor-")) {
                    String[] typeElements = type.split("-");
                    if (typeElements.length > 2) {
                        pluginId = typeElements[2];
                    }
                } else {
                    String[] typeElements = type.split("_");
                    if (typeElements.length > 1) {
                        pluginId = typeElements[1];
                    }
                }
                throw UnavailableTypeException.fromTypeAndPlugin(type, pluginId);
            }
            JsonElement paramJson = jsonObj.get("params");
            scriptStep.params = (StepParams)jsonDeserializationContext.deserialize(paramJson, stepParamClass);
        } else if (mtElt.getAsString().equals(ScriptStep.MetaType.GROUP.toString())) {
            JsonElement stepsJson;
            scriptStep = new GroupScriptStep();
            ((GroupScriptStep)scriptStep).metaType = ScriptStep.MetaType.GROUP;
            genericStep = scriptStep;
            JsonElement nameJson = jsonObj.get("name");
            if (nameJson != null) {
                ((GroupScriptStep)scriptStep).name = nameJson.getAsString();
            }
            if ((stepsJson = jsonObj.get("steps")) != null) {
                JsonArray arr = stepsJson.getAsJsonArray();
                for (JsonElement stepElt : arr) {
                    ProcessorScriptStep o = (ProcessorScriptStep)jsonDeserializationContext.deserialize(stepElt, ScriptStep.class);
                    ((GroupScriptStep)scriptStep).steps.add(o);
                }
            }
        } else {
            throw new NotImplementedException();
        }
        JsonElement disabledJson = jsonObj.get("disabled");
        if (disabledJson != null) {
            genericStep.disabled = disabledJson.getAsBoolean();
        }
        if ((previewJson = jsonObj.get("preview")) != null) {
            genericStep.preview = previewJson.getAsBoolean();
        }
        if ((commentJson = jsonObj.get("comment")) != null) {
            genericStep.comment = commentJson.getAsString();
        }
        if ((alwaysShowCommentJson = jsonObj.get("alwaysShowComment")) != null) {
            genericStep.alwaysShowComment = alwaysShowCommentJson.getAsBoolean();
        }
        if ((mainColorJson = jsonObj.get("mainColor")) != null) {
            genericStep.mainColor = mainColorJson.getAsString();
        }
        if ((secondaryColorJson = jsonObj.get("secondaryColor")) != null) {
            genericStep.secondaryColor = secondaryColorJson.getAsString();
        }
        if ((designTimeReportJson = jsonObj.get("designTimeReport")) != null && !designTimeReportJson.isJsonNull()) {
            genericStep.designTimeReport = (ProcessorWithRecordedReport.ProcessorRecordedReport)jsonDeserializationContext.deserialize(designTimeReportJson, ProcessorWithRecordedReport.ProcessorRecordedReport.class);
        }
        if (jsonObj.has("overrideTable")) {
            genericStep.overrideTable = (OverrideTable)jsonDeserializationContext.deserialize(jsonObj.get("overrideTable"), OverrideTable.class);
        }
        return genericStep;
    }

    public JsonElement serialize(ScriptStep step, Type type, JsonSerializationContext ctx) {
        return ctx.serialize((Object)step);
    }

    static {
        typeToParamType = Collections.synchronizedMap(new HashMap());
        logger = Logger.getLogger((String)"dku.serialization");
    }
}

