/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.model;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.datasets.ColoringDefinition;
import com.dataiku.dip.datasets.DatasetSelectionToMemTable;
import com.dataiku.dip.datasets.SamplingParam;
import com.dataiku.dip.datasets.StreamableDatasetSelection;
import com.dataiku.dip.metrics.MetricsEngineDesc;
import com.dataiku.dip.recipes.ParamsWithSelectableCodeEnv;
import com.dataiku.dip.recipes.SelectableCodeEnvContainer;
import com.dataiku.dip.shaker.model.GroupScriptStep;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.ScriptStep;
import com.dataiku.dip.shaker.processors.BaseProcessorsFactory;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.transform.ColumnReorder;
import com.dataiku.dip.shaker.processors.udf.MetaWithRemoteCodeEnv;
import com.dataiku.dip.shaker.processors.udf.ParamsWithRemoteCodeEnv;
import com.dataiku.dip.shaker.server.DataService;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.j2ts.annotations.UIModel;
import com.dataiku.j2ts.annotations.UINullable;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

@UIModel
public class SerializedShakerScript
implements SelectableCodeEnvContainer {
    public List<ScriptStep> steps = new ArrayList<ScriptStep>();
    public long maxProcessedMemTableBytes = -1L;
    @JSON.FileTransient
    public ShakerOrigin origin;
    @UINullable
    @JSON.FileTransient
    public String contextProjectKey;
    @UINullable
    public FullSampleStatisticsConfig fullSampleStatistics;
    public DisplayedColumnsSelection columnsSelection = new DisplayedColumnsSelection();
    public List<ColumnMovement> columnOrder = Lists.newArrayList();
    public Map<String, Integer> columnWidthsByName = new HashMap<String, Integer>();
    public Map<String, Boolean> columnUseScientificNotationByName = new HashMap<String, Boolean>();
    public TableColoring coloring = new TableColoring();
    public List<TableSorting> sorting = Lists.newArrayList();
    public Map<String, AnalysisColumnData> analysisColumnData = new HashMap<String, AnalysisColumnData>();
    @UINullable
    public DataService.ShakerRecipeSchema recipeSchema;
    public ShakerExplorationSampleSettings explorationSampling = new ShakerExplorationSampleSettings();
    public RefreshableStreamableSelection vizSampling = new RefreshableStreamableSelection();
    public JsonObject exploreUIParams = new JsonObject();
    public String globalSearchQuery = "";
    public JsonArray explorationFilters = new JsonArray();
    public PreviewMode previewMode = PreviewMode.ALL_ROWS;
    private static Logger logger = Logger.getLogger((String)"dip.shaker");

    public SerializedShakerScript() {
        this.explorationSampling.selection = DatasetSelectionToMemTable.newHead10K();
    }

    public String getProjectKey(Dataset ds) {
        if (StringUtils.isBlank((CharSequence)this.contextProjectKey)) {
            return ds.getProjectKey();
        }
        return this.contextProjectKey;
    }

    public String getProjectKey(StreamingEndpoint se) {
        if (StringUtils.isBlank((CharSequence)this.contextProjectKey)) {
            return se.getProjectKey();
        }
        return this.contextProjectKey;
    }

    public void expand(VariablesContext vc) {
        for (int i = 0; i < this.steps.size(); ++i) {
            ScriptStep step = this.steps.get(i);
            this.steps.set(i, step.expand(vc, i));
        }
    }

    public RefreshableStreamableSelection getExpandedVizSampling() {
        if (this.vizSampling.selection != null) {
            return this.vizSampling;
        }
        assert (this.explorationSampling.selection != null);
        RefreshableStreamableSelection expanded = new RefreshableStreamableSelection();
        expanded.selection = (StreamableDatasetSelection)((Object)JSON.parse((String)JSON.json((Object)((Object)this.explorationSampling.selection)), StreamableDatasetSelection.class));
        if (expanded.selection.samplingMethod == SamplingParam.SamplingMethod.RANDOM_FIXED_NB) {
            expanded.selection.useMemTable = true;
        }
        expanded.autoRefreshSample = this.vizSampling.autoRefreshSample;
        expanded._refreshTrigger = this.vizSampling._refreshTrigger;
        return expanded;
    }

    public SerializedShakerScript deepCopy() {
        return (SerializedShakerScript)JSON.deepCopy((Object)this);
    }

    public SerializedShakerScript expandedDeepCopy(VariablesContext vc) {
        SerializedShakerScript copy = this.deepCopy();
        copy.expand(vc);
        return copy;
    }

    @Override
    public List<ParamsWithSelectableCodeEnv> collectCodeEnvUsers() {
        ArrayList users = Lists.newArrayList();
        users.addAll(SerializedShakerScript.collectCodeEnvUsers(this.steps));
        return users;
    }

    public static List<ParamsWithSelectableCodeEnv> collectCodeEnvUsers(List<? extends ScriptStep> steps) {
        ArrayList users = Lists.newArrayList();
        block6: for (ScriptStep scriptStep : steps) {
            switch (scriptStep.metaType) {
                case GROUP: {
                    users.addAll(SerializedShakerScript.collectCodeEnvUsers(((GroupScriptStep)scriptStep).steps));
                    break;
                }
                case PROCESSOR: {
                    ProcessorScriptStep pss = (ProcessorScriptStep)scriptStep;
                    try {
                        ProcessorMeta<?, ?> meta = BaseProcessorsFactory.getMeta(pss);
                        if (!ParamsWithSelectableCodeEnv.class.isAssignableFrom(meta.stepParamClass())) continue block6;
                        users.add((ParamsWithSelectableCodeEnv)pss.params);
                        break;
                    }
                    catch (Exception e) {
                        logger.warn((Object)("Failed to check if step has a code env (type " + pss.type + ")"), (Throwable)e);
                    }
                }
            }
        }
        return users;
    }

    public static List<Pair<MetaWithRemoteCodeEnv, ParamsWithRemoteCodeEnv>> collectRemoteCodeEnvs(List<? extends ScriptStep> steps) {
        ArrayList users = Lists.newArrayList();
        block6: for (ScriptStep scriptStep : steps) {
            switch (scriptStep.metaType) {
                case GROUP: {
                    users.addAll(SerializedShakerScript.collectRemoteCodeEnvs(((GroupScriptStep)scriptStep).steps));
                    break;
                }
                case PROCESSOR: {
                    ProcessorScriptStep pss = (ProcessorScriptStep)scriptStep;
                    try {
                        ProcessorMeta<?, ?> meta = BaseProcessorsFactory.getMeta(pss);
                        if (!ParamsWithRemoteCodeEnv.class.isAssignableFrom(meta.stepParamClass())) continue block6;
                        users.add(new Pair((Object)((MetaWithRemoteCodeEnv)((Object)meta)), (Object)((ParamsWithRemoteCodeEnv)pss.params)));
                        break;
                    }
                    catch (Exception e) {
                        logger.warn((Object)("Failed to check if step has a code env (type " + pss.type + ")"), (Throwable)e);
                    }
                }
            }
        }
        return users;
    }

    public static class DisplayedColumnsSelection {
        public DisplayedColumnsMode mode = DisplayedColumnsMode.ALL;
        @UINullable
        public List<DisplayedColumn> list = null;

        public DisplayedColumn getColumn(String name) {
            if (this.list == null) {
                return null;
            }
            for (DisplayedColumn dc : this.list) {
                if (!dc.name.equals(name)) continue;
                return dc;
            }
            return null;
        }

        public int getColumnIndex(String name) {
            if (this.list == null) {
                return -1;
            }
            for (int i = 0; i < this.list.size(); ++i) {
                if (!this.list.get((int)i).name.equals(name)) continue;
                return i;
            }
            return -1;
        }

        public void applyColumnOrder(List<ColumnMovement> columnMovements) {
            block6: for (ColumnMovement movement : columnMovements) {
                DisplayedColumn movedColumn = this.getColumn(movement.movedColumn);
                if (movedColumn == null) continue;
                this.list.remove(movedColumn);
                switch (movement.reorderAction) {
                    case AT_START: {
                        this.list.add(0, movedColumn);
                        continue block6;
                    }
                    case BEFORE_COLUMN: {
                        if (StringUtils.isBlank((CharSequence)movement.referenceColumn)) {
                            throw ErrorContext.iae((String)"Other column is mandatory when the new position is set to 'Before another column'.");
                        }
                        int indexReferenceCol = this.getColumnIndex(movement.referenceColumn);
                        if (indexReferenceCol != -1) {
                            this.list.add(indexReferenceCol, movedColumn);
                            continue block6;
                        }
                        this.list.add(movedColumn);
                        continue block6;
                    }
                    case AFTER_COLUMN: {
                        if (StringUtils.isBlank((CharSequence)movement.referenceColumn)) {
                            throw ErrorContext.iae((String)"Other column is mandatory when the new position is set to 'After another column'.");
                        }
                        int indexReferenceCol = this.getColumnIndex(movement.referenceColumn);
                        if (indexReferenceCol != -1) {
                            this.list.add(indexReferenceCol + 1, movedColumn);
                            continue block6;
                        }
                        this.list.add(movedColumn);
                        continue block6;
                    }
                    case AT_END: {
                        this.list.add(movedColumn);
                        continue block6;
                    }
                }
                throw new IllegalStateException("Unhandled reorder action: " + String.valueOf(movement.reorderAction));
            }
        }
    }

    public static class TableColoring {
        public ColoringDefinition.TableColoringScheme scheme = ColoringDefinition.TableColoringScheme.MEANING_AND_STATUS;
        public List<String> individualColumns = new ArrayList<String>();
        @UINullable
        public List<ColoringDefinition.ColumnRules> individualColumnsRules = new ArrayList<ColoringDefinition.ColumnRules>();
        @UINullable
        public String singleColumn;
        @UINullable
        public String singleValue;
        public ColoringDefinition.ValueColoringMode valueColoringMode = ColoringDefinition.ValueColoringMode.HASH;
        public List<ColoringDefinition.ColoringGroup> coloringGroups = new ArrayList<ColoringDefinition.ColoringGroup>();
    }

    public static class ShakerExplorationSampleSettings {
        public DatasetSelectionToMemTable selection;
        public boolean autoRefreshSample;
        public long _refreshTrigger = 0L;

        public ShakerExplorationSampleSettings withSelection(DatasetSelectionToMemTable selection) {
            this.selection = selection;
            return this;
        }

        public ShakerExplorationSampleSettings withAutoRefreshSample(boolean autoRefreshSample) {
            this.autoRefreshSample = autoRefreshSample;
            return this;
        }
    }

    public static class RefreshableStreamableSelection {
        public StreamableDatasetSelection selection = new StreamableDatasetSelection();
        public boolean autoRefreshSample;
        public long _refreshTrigger = 0L;
    }

    public static enum PreviewMode {
        IMPACTED_ONLY,
        ALL_ROWS;

    }

    public static class AnalysisColumnData {
        public String meaning;
        public String comment;
        public JsonObject customFields;
        public boolean isColumnEdited;
    }

    public static enum ShakerOrigin {
        DATASET_EXPLORE,
        ANALYSIS,
        PREPARE_RECIPE,
        FLOW_PREVIEW;

    }

    public static enum ChartsEngine {
        LINO,
        SQL,
        SPARKSQL;

    }

    public static class FullSampleStatisticsConfig {
        public MetricsEngineDesc.MetricsEngineConfig engineConfig = new MetricsEngineDesc.MetricsEngineConfig();
        public boolean basic = true;
        public boolean countDistinct = true;
        public boolean advanced = true;
        public boolean percentile;
        public boolean validity;
        public boolean updateOnAnalyzeBoxOpen;
        public boolean computeCostFreeMetrics;
        public Integer numberTopValues = 10;
    }

    public static class ColumnMovement {
        public ColumnReorder.ReorderAction reorderAction;
        public String movedColumn;
        public String referenceColumn;
    }

    public static enum DisplayedColumnsMode {
        ALL,
        SELECT;

    }

    public static class DisplayedColumn {
        public String name;
        public boolean d;
    }

    public static class TableSorting {
        public String column;
        public boolean ascending;
    }
}

