/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.reshaping;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.SingleInputSingleOutputRowProcessor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Melt
extends SingleInputSingleOutputRowProcessor {
    String[] idColumns;
    boolean includeMissingValues;
    Column variableColumn;
    Column valueColumn;
    Set<String> idColNames = new HashSet<String>();
    List<Column> idCDs = new ArrayList<Column>();

    public Melt(String[] idColumns, boolean includeMissingValues) {
        this.idColumns = idColumns;
        this.includeMissingValues = includeMissingValues;
        for (String s : idColumns) {
            this.idColNames.add(s);
        }
    }

    public void init() {
        for (String col : this.idColumns) {
            this.idCDs.add(this.getCf().column(col, Processor.ProcessorRole.INPUT_COLUMN));
        }
        this.variableColumn = this.getCf().column("variable", Processor.ProcessorRole.OUTPUT_COLUMN);
        this.valueColumn = this.getCf().column("value", Processor.ProcessorRole.OUTPUT_COLUMN);
    }

    public void processRow(Row row) throws Exception {
        for (Column c2 : this.getCf().columns()) {
            if (c2.getName().equals("variable") || c2.getName().equals("value") || this.idColNames.contains(c2.getName())) continue;
            Row orow = this.getRf().row();
            for (Column idC : this.idCDs) {
                orow.put(idC, row.get(idC));
            }
            orow.put(this.variableColumn, c2.getName());
            orow.put(this.valueColumn, row.get(c2));
            this.getProcessorOutput().emitRow(orow);
        }
    }

    public void postProcess() throws Exception {
        this.getProcessorOutput().lastRowEmitted();
        for (Column c2 : this.getCf().columns()) {
            if (c2.getName().equals("variable") || c2.getName().equals("value") || this.idColNames.contains(c2.getName())) continue;
            this.getCf().deleteColumn(c2.getName());
        }
    }
}

