/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.server;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.datasets.DatasetSelection;
import com.dataiku.dip.pivot.backend.PivotTablesService;
import com.dataiku.dip.pivot.backend.dss.LinoPivotTablesService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.shaker.SampleBuilder;
import com.dataiku.dip.shaker.model.ChartsOnDatasetDataSpec;
import com.dataiku.dip.shaker.model.ShakerSamplingUtils;
import com.dataiku.dip.shaker.server.SampleMetadata;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.utils.DKULogger;
import java.io.File;
import org.springframework.stereotype.Service;

@Service
public class ChartSampleMetaDataService {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.charts.sampling.metadata");

    public SampleMetadata getChartSampleMetaData_NT(AuthCtx authCtx, Dataset dataset, ChartsOnDatasetDataSpec dataSpec, MemTable mt) throws Exception {
        TransactionContext.assertNoAttachedTransaction();
        PivotTablesService.expandSampleSettingsFromScriptIfNeeded(dataSpec);
        if (dataset.getPartitioningSchema() != null && !dataset.getPartitioningSchema().isPartitioned() && dataSpec.sampleSettings.selection != null) {
            dataSpec.sampleSettings.selection.partitionSelectionMethod = DatasetSelection.PartitionSelectionMethod.ALL;
        }
        String sampleId = ShakerSamplingUtils.computeSampleId(authCtx, dataset, dataSpec.sampleSettings, dataSpec.script.steps, mt);
        return this.getChartSampleMetaData_NT(dataset, dataSpec, sampleId);
    }

    public SampleMetadata getChartSampleMetaData_NT(Dataset dataset, ChartsOnDatasetDataSpec dataSpec, String sampleId) {
        TransactionContext.assertNoAttachedTransaction();
        logger.info((Object)("Lookup cache requestedSampleId: " + sampleId));
        String datasetPath = dataset.getProjectKey() + "_" + dataset.getName();
        File cacheFolder = LinoPivotTablesService.getLinoCacheFolder(datasetPath, sampleId, dataSpec.sampleSettings._refreshTrigger);
        return SampleBuilder.getSampleMetadata(new File(cacheFolder, "sampling.metadata.json"));
    }
}

