/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql;

import com.dataiku.dip.pivot.backend.sql.utils.QueryUtils;
import com.dataiku.dip.sql.DatePart;
import com.dataiku.dip.sql.DateRounding;
import com.dataiku.dip.sql.GenericSQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.queries.QueryAst;
import com.dataiku.dip.sql.queries.QueryUtils;
import com.dataiku.dip.sql.queries.QuotedPortionFinderFactory;
import com.dataiku.dip.sql.queries.QuotedPortionFinders;
import com.dataiku.dip.utils.NotImplementedException;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;

public class SAPHANASQLDialect
extends GenericSQLDialect {
    @Override
    public String datePartExpression(String inputDateExpression, DatePart part) {
        switch (part) {
            case DAY_OF_MONTH: {
                return "EXTRACT(DAY FROM (" + inputDateExpression + "))";
            }
            case HOUR_OF_DAY: {
                return "EXTRACT(HOUR FROM (" + inputDateExpression + "))";
            }
            case MINUTE_OF_HOUR: {
                return "EXTRACT(MINUTE FROM (" + inputDateExpression + "))";
            }
            case SECOND_OF_MINUTE: {
                return "FLOOR(EXTRACT(SECOND FROM (" + inputDateExpression + ")))";
            }
            case MILLISECOND_OF_SECOND: {
                return "FLOOR(MOD(EXTRACT(SECOND FROM (" + inputDateExpression + ")) * 1000, 1000))";
            }
            case MONTH_OF_YEAR: {
                return "EXTRACT(MONTH FROM (" + inputDateExpression + "))";
            }
            case WEEK_OF_YEAR: {
                return "WEEK(" + inputDateExpression + ")";
            }
            case QUARTER_OF_YEAR: {
                return "(1 + ((EXTRACT(MONTH FROM (" + inputDateExpression + ")) - 1) / 3))";
            }
            case YEAR: {
                return "EXTRACT(YEAR FROM (" + inputDateExpression + "))";
            }
            case DAY_OF_WEEK: {
                return "WEEKDAY(" + inputDateExpression + ") + 1";
            }
        }
        throw new NotImplementedException(String.format("Date part '%s' is not supported on HANA", part));
    }

    @Override
    public String dateTrunc(String inputDateExpression, DateRounding rounding) {
        String dateAtGmt = inputDateExpression;
        switch (rounding) {
            case DAY: {
                return "date_trunc('DAY'," + dateAtGmt + ")";
            }
            case HOUR: {
                return "date_trunc('HOUR'," + dateAtGmt + ")";
            }
            case WEEK: {
                return "date_trunc('WEEK'," + dateAtGmt + ")";
            }
            case MONTH: {
                return "date_trunc('MONTH'," + dateAtGmt + ")";
            }
            case YEAR: {
                return "date_trunc('YEAR'," + dateAtGmt + ")";
            }
            case QUARTER: {
                return "date_trunc('QUARTER'," + dateAtGmt + ")";
            }
            case MINUTE: {
                return "date_trunc('MINUTE'," + dateAtGmt + ")";
            }
            case SECOND: {
                return "date_trunc('SECOND'," + dateAtGmt + ")";
            }
        }
        throw new Error("unreachable");
    }

    @Override
    public String getSafeRandomTemporaryTableName(String prefix) {
        return QueryUtils.safeRandomIdentifier("#" + prefix);
    }

    @Override
    public String createTemporaryTable(SQLUtils.SQLTable table, String columnListExpr) {
        return "CREATE LOCAL TEMPORARY TABLE " + this.getQuotedTableFullName(table) + "(" + columnListExpr + ")";
    }

    @Override
    public String[] createTemporaryTableAs(SQLUtils.SQLTable table, String selectExpr) {
        return new String[]{"CREATE LOCAL TEMPORARY TABLE " + this.getQuotedTableFullName(table) + " AS (" + selectExpr + ")"};
    }

    @Override
    public int getIdentifiersMaxLength() {
        return 127;
    }

    @Override
    public boolean supportsIndexing() {
        return false;
    }

    @Override
    public String captureGroup(int group) {
        return "\\" + group;
    }

    @Override
    public String getLimitedQuery(String query, long size) {
        return this.getLimitedQueryUsingLimit(query, size);
    }

    @Override
    public QuotedPortionFinderFactory[] getSemicolonExclusionPortionFinders() {
        return new QuotedPortionFinderFactory[]{QuotedPortionFinders.SingleLineCommentFinder.META, QuotedPortionFinders.MultiLineCommentFinder.META, QuotedPortionFinders.SingleQuotedNoEscapeFinder.META, QuotedPortionFinders.DoubleQuotedNoEscapeFinder.META, QuotedPortionFinders.OracleQuotedStringLiteralFinder.META};
    }

    @Override
    public String getColumnExpressionForBoolean(String booleanExpression) {
        return "cast(CASE WHEN " + booleanExpression + " THEN 1 ELSE 0 END as boolean)";
    }

    @Override
    protected void initOperators() {
        super.initOperators();
        this.addGenericFunction(QueryUtils.OperatorType.STDDEV_SAMP, "STDDEV_SAMP", QueryUtils.Arity.UNARY);
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.CONCAT, QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateMinNumberOfParameters(args, 2);
                String first = this.toSQLNoBrackets(args[0]);
                String second = args.length > 2 ? this.apply(Arrays.copyOfRange(args, 1, args.length)) : this.toSQLNoBrackets(args[1]);
                return "CONCAT(" + first + ", " + second + ")";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.TRANSLATE, QueryUtils.Arity.NARY){

            private String replace(String str, String x, String y) {
                return "REPLACE(" + str + ", " + SAPHANASQLDialect.this.quoteString(x) + ", " + SAPHANASQLDialect.this.quoteString(y) + ")";
            }

            @Override
            public boolean checkNumberOfParameters(int nArgs) {
                return nArgs == 3;
            }

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String ret = this.toSQLNoBrackets(args[0]);
                String from = this.getParamAs(args[1], String.class);
                String to = this.getParamAs(args[2], String.class);
                for (int i = 0; i < from.length() && i < to.length(); ++i) {
                    ret = this.replace(ret, from.substring(i, i + 1), to.substring(i, i + 1));
                }
                return ret;
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.UNIQUE_ID, QueryUtils.Arity.NO_ARG){

            @Override
            public String apply(QueryAst.Expr[] args) {
                return "ROW_NUMBER() OVER ()";
            }
        });
        this.addGenericFunction(QueryUtils.OperatorType.SUBSTR, "SUBSTRING", QueryUtils.Arity.NARY);
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.PERCENTILE_CONT, QueryUtils.Arity.BINARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String column = this.toSQLNoBrackets(args[0]);
                double percentile = this.getParamAs(args[1], Double.class);
                return "PERCENTILE_CONT(" + percentile + ") WITHIN GROUP (ORDER BY " + column + ")";
            }
        });
    }

    @Override
    public int getMaxPossibleVarcharLen() {
        return 5000;
    }

    @Override
    public SQLDialect.NaturalJoinSupport getNaturalJoinSupport() {
        return SQLDialect.NaturalJoinSupport.NONE;
    }

    @Override
    public boolean supportsInDatabaseCharts() {
        return true;
    }

    @Override
    public String getId() {
        return "SAPHANA";
    }

    @Override
    public List<String> getTableTypesWithoutOverrides(SQLDialect.GetTableTypesReason reason) {
        return Lists.newArrayList((Object[])new String[]{"TABLE", "VIEW", "OLAP VIEW", "CALC VIEW", "JOIN VIEW"});
    }
}

