/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql.queries;

import com.dataiku.dip.dataflow.exec.window.WindowRecipePayloadParams;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.sql.ImpalaSQLDialect;
import com.dataiku.dip.sql.OracleSQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SparkSQLDialect;
import com.dataiku.dip.sql.TeradataSQLDialect;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.QueryAst;
import com.dataiku.dip.sql.queries.QueryUtils;
import com.dataiku.dip.sql.queries.QueryWriter;
import com.dataiku.dip.sql.queries.QueryWritingGuardian;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.dataiku.dss.shadelib.org.joda.time.LocalDate;
import com.dataiku.dss.shadelib.org.joda.time.LocalDateTime;
import com.dataiku.dss.shadelib.org.joda.time.ReadableInstant;
import com.dataiku.dss.shadelib.org.joda.time.ReadablePartial;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.collections4.list.TreeList;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class QuerySQLWriter
implements QueryWriter {
    public SQLDialect dialect;
    StringBuilder output;
    Indenter indenter = new Indenter();
    HashMap<QueryAst.Window, String> windows = new HashMap();
    public static final Pattern isoFormatScreener = Pattern.compile("^[0-9]{4}\\-[0-9]{2}\\-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}.*$");
    public static final Pattern sqlFormatScreener = Pattern.compile("^[0-9]{4}\\-[0-9]{2}\\-[0-9]{2} [0-9]{2}:[0-9]{2}:[0-9]{2}.*$");
    final DateTimeFormatter isoFormatter = DKUtils.getISODateFormatter().withZoneUTC();
    final DateTimeFormatter sqlFormatter = DKUtils.getDateFormatter((String)"yyyy-MM-dd HH:mm:ss").withZoneUTC();
    final DateTimeFormatter sqlDateFormatter = DKUtils.getDateFormatter((String)"yyyy-MM-dd").withZoneUTC();
    static Logger logger = Logger.getLogger((String)"dku.sql.writer");

    public QuerySQLWriter(SQLDialect dialect) {
        assert (dialect != null);
        this.dialect = dialect;
    }

    void init() {
        this.output = new StringBuilder();
    }

    public static String generateSafeSQL(SQLDialect dialect, QueryAst.Expr expression) {
        try (QueryWritingGuardian guardian = new QueryWritingGuardian();){
            QuerySQLWriter writer = new QuerySQLWriter(dialect);
            String string = writer.toSQL(expression);
            return string;
        }
    }

    @Override
    public String toSQL(QueryAst.Expr expr) {
        this.init();
        this.write(expr);
        return this.output.toString();
    }

    void write(QueryAst.SelectQuery query) {
        this.writeComment(query.comment);
        this.writeCTEs(query.with);
        if (this.dialect.getLimitMethod() == SQLDialect.LimitMethod.WRAP_QUERY && query.limit != null) {
            this.write("SELECT * FROM (");
            this.indenter.startBlock();
            this.indenter.newLine(this.output);
        }
        this.write("SELECT");
        if (query.distinct) {
            this.write(" DISTINCT");
        }
        this.write(' ');
        if (this.dialect.getLimitMethod() == SQLDialect.LimitMethod.TOP && query.limit != null) {
            if (this.dialect instanceof TeradataSQLDialect) {
                this.write("TOP " + query.limit + " ");
            } else {
                this.write("TOP(" + query.limit + ") ");
            }
        }
        this.indenter.startBlock();
        this.writeSelectList(query.selectList);
        this.writeFromClause(query.from);
        this.writeJoinClause(query.join);
        this.writeConditions("WHERE", query.where, "AND");
        this.writeGroups(query.groupBy);
        this.writeConditions("HAVING", query.having, "AND");
        this.writeWindows();
        this.writeOrders(query.orderBy);
        this.writeOrdersAndLimit(query.limit, query.orderBy);
        this.indenter.endBlock();
        if (this.dialect.getLimitMethod() == SQLDialect.LimitMethod.WRAP_QUERY && query.limit != null) {
            this.indenter.newLine(this.output);
            this.write(") ");
            this.write(this.dialect.quoteIdentifier("__wrapped_subquery__"));
            this.write(" WHERE ");
            this.write(this.dialect.limitQueryUsingWhere(query.limit));
            this.indenter.endBlock();
        }
    }

    void write(QueryAst.InlineQuery query) {
        this.write(query.sql);
    }

    void write(QueryAst.CaseExpr caseExpr) {
        this.write("CASE ");
        this.indenter.startBlock();
        boolean oneCasePerLine = caseExpr.items.size() < 7;
        for (QueryAst.CaseExpr.WhenItem item : caseExpr.items) {
            if (oneCasePerLine) {
                this.indenter.newLine(this.output);
            } else {
                this.write(" ");
            }
            this.write("WHEN ");
            this.write(item.when);
            this.write(" THEN ");
            this.write(item.then);
        }
        if (caseExpr.elseValue != null) {
            this.indenter.newLine(this.output);
            this.write("ELSE ");
            this.write(caseExpr.elseValue);
        }
        this.indenter.endBlock();
        this.indenter.newLine(this.output);
        this.write("END");
    }

    void writeCTEs(List<QueryAst.TableLike> ctes) {
        if (ctes.size() > 0) {
            if (!this.dialect.supportsCTEs()) {
                throw new QueryUtils.SQLGenerationException("SQL database does not support CTEs (WITH clause): " + this.dialect.getClass().getName());
            }
            this.write("WITH ");
            this.indenter.startBlock();
            for (int i = 0; i < ctes.size(); ++i) {
                QueryAst.TableLike cte = ctes.get(i);
                this.indenter.newLine(this.output);
                this.write(cte, AliasPosition.BEFORE);
                if (i >= ctes.size() - 1) continue;
                this.write(",");
            }
            this.indenter.endBlock();
            this.indenter.newLine(this.output);
            this.indenter.newLine(this.output);
        }
    }

    void writeSelectList(List<QueryAst.SelectRef> selectList) {
        boolean first = true;
        this.indenter.startBlock();
        if (selectList.size() == 0) {
            this.write("*");
        } else if (selectList.size() > 1) {
            this.indenter.newLine(this.output);
        }
        for (QueryAst.SelectRef item : selectList) {
            if (!first) {
                this.write(",");
                this.indenter.newLine(this.output);
            }
            if (QueryUtils.isBooleanCondition(item.expr)) {
                this.write(new QueryAst.OperatorExpr(QueryUtils.OperatorType.CAST_BOOL_TO_COLUMN, item.expr));
            } else {
                this.write(item.expr);
            }
            if (StringUtils.isNotBlank((String)item.alias)) {
                this.write(" AS ");
                this.write(this.dialect.quoteIdentifier(item.alias));
            }
            first = false;
        }
        this.indenter.endBlock();
    }

    void write(QueryAst.TableLike tableLike, AliasPosition aliasPosition) {
        if (tableLike instanceof QueryAst.Table) {
            QueryAst.Table table = (QueryAst.Table)tableLike;
            this.write(this.dialect.getQuotedTableFullName(table.catalog, table.schema, table.name));
            if (StringUtils.isNotBlank((String)table.alias)) {
                this.write(' ');
                this.write(this.dialect.quoteIdentifier(table.alias));
            }
            if (table.sample != null) {
                if (this.dialect.getRandomSampleClauseLocation(table.sample.samplingMethod, table.sample.seed) != SQLDialect.RandomSampleClauseLocation.FROM) {
                    throw new QueryUtils.SQLGenerationException("SQL database " + this.dialect.getClass().getSimpleName() + " does not support sampling method in the from clause: " + String.valueOf(table.sample.samplingMethod));
                }
                this.indenter.startBlock();
                this.indenter.newLine(this.output);
                this.write(this.dialect.getRandomSampleClause(table.sample));
                this.indenter.endBlock();
            }
        } else if (tableLike instanceof QueryAst.TableVariableReference) {
            QueryAst.TableVariableReference tvr = (QueryAst.TableVariableReference)tableLike;
            this.write(tvr.getVar());
        } else if (tableLike instanceof QueryAst.SelectQuery) {
            QueryAst.SelectQuery subquery = (QueryAst.SelectQuery)tableLike;
            if (StringUtils.isNotBlank((String)subquery.alias) && aliasPosition == AliasPosition.BEFORE) {
                this.write(this.dialect.quoteIdentifier(subquery.alias));
                this.write(" AS ");
                this.write(' ');
            }
            this.write('(');
            this.indenter.startBlock();
            this.indenter.newLine(this.output);
            this.write(subquery);
            this.indenter.newLine(this.output);
            this.write(')');
            if (StringUtils.isNotBlank((String)subquery.alias) && aliasPosition == AliasPosition.AFTER) {
                this.write(' ');
                this.write(this.dialect.quoteIdentifier(subquery.alias));
            }
            this.indenter.endBlock();
        } else if (tableLike instanceof QueryAst.InlineQuery) {
            QueryAst.InlineQuery subquery = (QueryAst.InlineQuery)tableLike;
            if (StringUtils.isNotBlank((String)subquery.alias) && aliasPosition == AliasPosition.BEFORE) {
                this.write(this.dialect.quoteIdentifier(subquery.alias));
                if (this.dialect.requiresColumnNamesInCTEs()) {
                    this.write(' ');
                    if (subquery.columnNames != null && subquery.columnNames.size() > 0) {
                        this.write('(');
                        this.indenter.startBlock();
                        this.indenter.newLine(this.output);
                        boolean first = true;
                        for (String columnName : subquery.columnNames) {
                            if (!first) {
                                this.write(',');
                            }
                            this.write(' ');
                            this.write(this.dialect.quoteIdentifier(columnName));
                            first = false;
                        }
                        this.indenter.newLine(this.output);
                        this.write(')');
                        this.indenter.endBlock();
                    }
                }
                this.write(" AS ");
                this.write(' ');
            }
            this.write('(');
            this.indenter.startBlock();
            this.indenter.newLine(this.output);
            this.write(subquery);
            this.indenter.newLine(this.output);
            this.write(')');
            if (StringUtils.isNotBlank((String)subquery.alias) && aliasPosition == AliasPosition.AFTER) {
                this.write(' ');
                this.write(this.dialect.quoteIdentifier(subquery.alias));
            }
            this.indenter.endBlock();
        } else if (tableLike instanceof QueryAst.CombinedTableLikes) {
            QueryAst.CombinedTableLikes ctl = (QueryAst.CombinedTableLikes)tableLike;
            boolean first = true;
            if (StringUtils.isNotBlank((String)tableLike.getAlias())) {
                this.write('(');
                this.indenter.startBlock();
                this.indenter.newLine(this.output);
            }
            for (QueryAst.TableLike tl : ctl.tables) {
                if (!first) {
                    this.indenter.newLine(this.output);
                    this.write(this.getSqlOperator(ctl.operator));
                    this.indenter.newLine(this.output);
                }
                if (tl instanceof QueryAst.SelectQuery) {
                    this.write((QueryAst.SelectQuery)tl);
                } else {
                    this.write(tl, null);
                }
                first = false;
            }
            if (StringUtils.isNotBlank((String)tableLike.getAlias())) {
                this.indenter.endBlock();
                this.indenter.newLine(this.output);
                this.write(')');
            }
            if (StringUtils.isNotBlank((String)ctl.alias)) {
                this.write(' ');
                this.write(this.dialect.quoteIdentifier(ctl.alias));
            }
        }
    }

    private void write(QueryAst.Window window) {
        boolean first = true;
        boolean partitioned = window.partitionExpressions != null && window.partitionExpressions.size() > 0;
        boolean ordered = window.orderExpressions != null && window.orderExpressions.size() > 0;
        this.write('(');
        if (partitioned) {
            this.write("PARTITION BY ");
            for (QueryAst.Expr column : window.partitionExpressions) {
                if (!first) {
                    this.write(", ");
                }
                this.write(column);
                first = false;
            }
        }
        if (partitioned && ordered) {
            this.write(' ');
        }
        if (ordered) {
            this.write("ORDER BY ");
            for (int i = 0; i < window.orderExpressions.size(); ++i) {
                if (i > 0) {
                    this.write(", ");
                }
                if (window.dateDiffUnit != null && this.dialect instanceof OracleSQLDialect) {
                    ExpressionBuilder.ExpressionBuilderFactory ef = new ExpressionBuilder.ExpressionBuilderFactory();
                    ExpressionBuilder eb = ef.expr(window.orderExpressions.get(i)).castToDate();
                    this.write(eb.expr);
                } else {
                    this.write(window.orderExpressions.get(i));
                }
                this.write(' ');
                QueryAst.OrderType orderType = window.orderTypes != null ? window.orderTypes.get(i) : null;
                this.write(orderType == QueryAst.OrderType.DESC ? "DESC" : "ASC");
                if (!this.dialect.supportsNullsOrdering()) continue;
                this.write(" NULLS ");
                this.write(orderType == QueryAst.OrderType.DESC ? "LAST" : "FIRST");
            }
        }
        if (window.frameMode != null) {
            this.write(' ');
            this.write(window.frameMode.toString());
            this.write(" BETWEEN ");
            this.writeWindowFrameBound(window.frameStart, window.getFrameStartDirection().toString(), window.dateDiffUnit);
            this.write(" AND ");
            this.writeWindowFrameBound(window.frameEnd, window.getFrameEndDirection().toString(), window.dateDiffUnit);
        }
        this.write(')');
    }

    private void writeWindowFrameBound(String bound, String role, WindowRecipePayloadParams.DateDiffUnit unit) {
        if (bound == null) {
            if (!this.dialect.supportsWindowUnboundedFrame()) {
                throw new QueryUtils.SQLGenerationException("SQL database does not support unbounded frame in a window clause: " + this.dialect.getClass().getSimpleName());
            }
            this.write("UNBOUNDED ");
            this.write(role);
        } else if ("0".equals(bound) || "0.0".equals(bound) || "-0.0".equals(bound) || "CURRENT ROW".equals(bound)) {
            if (!this.dialect.supportsWindowCurrentRowFrame()) {
                throw new QueryUtils.SQLGenerationException("SQL database does not support current row bound in a window clause: " + this.dialect.getClass().getSimpleName());
            }
            this.write("CURRENT ROW");
        } else if (unit != null) {
            if (!this.dialect.supportsWindowTimeRangeFrame()) {
                throw new QueryUtils.SQLGenerationException("SQL database does not support time frame in a window clause: " + this.dialect.getClass().getSimpleName());
            }
            this.write(this.dialect.timeRange(bound, unit.toString()));
            this.write(' ');
            this.write(role);
        } else {
            if (!this.dialect.supportsWindowNormalRangeFrame()) {
                throw new QueryUtils.SQLGenerationException("SQL database does not support normal frame in a window clause: " + this.dialect.getClass().getSimpleName());
            }
            this.write(bound);
            this.write(' ');
            this.write(role);
        }
    }

    private void writeOverClause(QueryAst.Window window) {
        if (window != null) {
            this.write(" OVER ");
            if (this.dialect.supportsNamedWindows()) {
                if (this.windows.get(window) == null) {
                    this.windows.put(window, "sql_window" + (String)(this.windows.keySet().size() == 0 ? "" : "_" + this.windows.keySet().size()));
                }
                this.write(this.windows.get(window));
            } else {
                this.write(window);
            }
        }
    }

    private void writeWindows() {
        if (this.windows.keySet().size() > 0) {
            this.indenter.newLine(this.output);
            this.write("WINDOW ");
            this.indenter.startBlock();
            boolean first = true;
            if (this.windows.keySet().size() > 1) {
                this.indenter.newLine(this.output);
            }
            for (QueryAst.Window window : this.windows.keySet()) {
                if (!first) {
                    this.write(',');
                    this.indenter.newLine(this.output);
                }
                this.write(this.windows.get(window));
                this.write(" AS ");
                this.write(window);
                first = false;
            }
            this.indenter.endBlock();
            this.windows = new HashMap();
        }
    }

    void writeFromClause(QueryAst.TableLike from) {
        if (from == null) {
            logger.trace((Object)"No from clause in the SQL query");
            this.write(' ');
            this.write(this.dialect.emptyFromClause());
        } else {
            this.indenter.newLine(this.output);
            this.write("FROM ");
            this.write(from, AliasPosition.AFTER);
            if (from instanceof QueryAst.WithComment) {
                this.write(' ');
                this.writeCommentNoEOL(((QueryAst.WithComment)((Object)from)).getComment());
            }
        }
    }

    void writeJoinClause(List<QueryAst.JoinClause> joins) {
        for (QueryAst.JoinClause join : joins) {
            this.indenter.newLine(this.output);
            if (join.type == null) {
                throw new QueryUtils.SQLGenerationException("No join type specified");
            }
            if (this.dialect.getNaturalJoinSupport() == SQLDialect.NaturalJoinSupport.NONE) {
                switch (join.type) {
                    case NATURAL_FULL: 
                    case NATURAL_LEFT: 
                    case NATURAL_RIGHT: 
                    case NATURAL_INNER: {
                        throw new QueryUtils.SQLGenerationException("This SQL engine does not support natural joins");
                    }
                }
            }
            if (this.dialect.getNaturalJoinSupport() == SQLDialect.NaturalJoinSupport.INNER_ONLY) {
                switch (join.type) {
                    case NATURAL_FULL: 
                    case NATURAL_LEFT: 
                    case NATURAL_RIGHT: {
                        throw new QueryUtils.SQLGenerationException("This SQL engine only supports INNER natural joins");
                    }
                }
            }
            switch (join.type) {
                case LEFT: {
                    this.write("LEFT JOIN ");
                    break;
                }
                case RIGHT: {
                    this.write("RIGHT JOIN ");
                    break;
                }
                case INNER: {
                    this.write("INNER JOIN ");
                    break;
                }
                case FULL: {
                    this.write("FULL OUTER JOIN ");
                    break;
                }
                case CROSS: {
                    this.write("CROSS JOIN ");
                    break;
                }
                case NATURAL_FULL: {
                    this.write("NATURAL FULL JOIN ");
                    break;
                }
                case NATURAL_INNER: {
                    this.write(this.dialect.isNaturalJoinImplicitlyInner() ? "NATURAL JOIN" : "NATURAL INNER JOIN ");
                    break;
                }
                case NATURAL_LEFT: {
                    this.write("NATURAL LEFT JOIN ");
                    break;
                }
                case NATURAL_RIGHT: {
                    this.write("NATURAL RIGHT JOIN ");
                }
            }
            this.write(join.tableLike, AliasPosition.AFTER);
            this.indenter.startBlock();
            if (join.type.requiresOnClause && join.on != null && join.on.size() > 0) {
                this.writeConditions("ON", join.on, join.operatorBetweenConditions);
            }
            this.indenter.endBlock();
        }
    }

    void writeGroups(List<QueryAst.GroupClause> groups) {
        if (groups.size() > 0) {
            this.indenter.newLine(this.output);
            this.write("GROUP BY ");
            boolean first = true;
            for (QueryAst.GroupClause group : groups) {
                if (!first) {
                    this.write(", ");
                }
                this.write(group.expr);
                first = false;
            }
        }
    }

    void writeOrders(List<QueryAst.OrderClause> orders) {
        if (!orders.isEmpty()) {
            this.indenter.newLine(this.output);
            this.write("ORDER BY ");
            boolean first = true;
            for (QueryAst.OrderClause order : orders) {
                if (!first) {
                    this.write(", ");
                }
                this.write(order.expr);
                this.write(' ');
                this.write(order.orderType == QueryAst.OrderType.DESC ? "DESC" : "ASC");
                if (this.dialect.supportsNullsOrdering()) {
                    this.write(" NULLS ");
                    if (order.nullOrder != null) {
                        this.write(order.nullOrder == QueryAst.OrderType.DESC ? "LAST" : "FIRST");
                    } else {
                        this.write(order.orderType == QueryAst.OrderType.DESC ? "LAST" : "FIRST");
                    }
                }
                first = false;
            }
        }
    }

    void writeConditions(String keyword, List<QueryAst.Expr> conditions, String operatorBetweenConditions) {
        if (!conditions.isEmpty()) {
            this.indenter.newLine(this.output);
            this.write(keyword);
            this.write(' ');
            this.indenter.startBlock();
            boolean first = true;
            for (QueryAst.Expr condition : conditions) {
                if (!first) {
                    this.indenter.newLine(this.output);
                    this.write(operatorBetweenConditions + " ");
                }
                if (conditions.size() == 1) {
                    this.write(condition);
                } else {
                    this.write('(');
                    this.write(condition);
                    this.write(')');
                }
                first = false;
            }
            this.indenter.endBlock();
        }
    }

    void writeOrdersAndLimit(Long maxNbRecords, List<QueryAst.OrderClause> orders) {
        if (this.dialect.getLimitMethod() == SQLDialect.LimitMethod.LIMIT && maxNbRecords != null) {
            this.indenter.newLine(this.output);
            this.write("LIMIT " + maxNbRecords);
        } else if (this.dialect.getLimitMethod() == SQLDialect.LimitMethod.SAMPLE && maxNbRecords != null) {
            this.indenter.newLine(this.output);
            this.write("SAMPLE " + maxNbRecords);
        } else if (this.dialect instanceof ImpalaSQLDialect && orders.size() > 0) {
            this.indenter.newLine(this.output);
            this.write("LIMIT " + ((ImpalaSQLDialect)this.dialect).getDefaultLimit());
        }
    }

    void writeLimitInWhere(Long maxNbRecords, boolean alreadyHasWhereClause) {
        if (maxNbRecords != null) {
            this.indenter.newLine(this.output);
            if (!alreadyHasWhereClause) {
                this.write("WHERE ");
            } else {
                this.write("AND ");
            }
            this.write(this.dialect.limitQueryUsingWhere(maxNbRecords));
        }
    }

    void writeComment(String comment) {
        if (StringUtils.isNotBlank((String)comment)) {
            this.write("-- " + comment);
            this.indenter.newLine(this.output);
        }
    }

    void writeCommentNoEOL(String comment) {
        if (StringUtils.isNotBlank((String)comment)) {
            this.write("-- " + comment);
        }
    }

    void write(QueryAst.Expr expr) {
        if (expr instanceof QueryAst.Column) {
            this.write((QueryAst.Column)expr);
        } else if (expr instanceof QueryAst.CaseExpr) {
            this.write((QueryAst.CaseExpr)expr);
        } else if (expr instanceof QueryAst.ConstExpr) {
            this.write((QueryAst.ConstExpr)expr);
        } else if (expr instanceof QueryAst.InlineExpr) {
            this.write((QueryAst.InlineExpr)expr);
        } else if (expr instanceof QueryAst.ListExpr) {
            this.write((QueryAst.ListExpr)expr);
        } else if (expr instanceof QueryAst.Comment) {
            this.write((QueryAst.Comment)expr);
        } else if (expr instanceof QueryAst.OperatorExpr) {
            this.write((QueryAst.OperatorExpr)expr);
        } else if (expr instanceof QueryAst.SelectQuery) {
            this.write((QueryAst.SelectQuery)expr);
        } else if (expr instanceof QueryAst.InlineQuery) {
            this.write((QueryAst.InlineQuery)expr);
        } else if (expr instanceof QueryAst.CombinedTableLikes) {
            this.write((QueryAst.CombinedTableLikes)expr, null);
        } else if (expr instanceof QueryAst.TableLike) {
            this.writeName((QueryAst.TableLike)((Object)expr));
        } else {
            throw new QueryUtils.SQLGenerationException("Cannot write Expr of type " + expr.getClass().getName());
        }
    }

    void write(String str) {
        this.output.append(str);
        QueryWritingGuardian.updateAboveMark(this.output.length());
    }

    void write(char c2) {
        this.output.append(c2);
        QueryWritingGuardian.updateAboveMark(this.output.length());
    }

    private void write(QueryAst.InlineExpr ie) {
        if (ie.windows != null) {
            TreeList tree = new TreeList();
            tree.add(0, (Object)ie.expr);
            for (String key : ie.windows.keySet()) {
                for (int i = 0; i < tree.size(); ++i) {
                    String str;
                    if (!(tree.get(i) instanceof String) || !(str = (String)tree.get(i)).contains(key)) continue;
                    tree.remove(i);
                    String[] parts = str.split("\\Q" + key + "\\E");
                    for (int p = 0; p < parts.length; ++p) {
                        tree.add(i++, (Object)parts[p]);
                        if (p + 1 >= parts.length && !str.endsWith(key)) continue;
                        tree.add(i++, (Object)ie.windows.get(key));
                    }
                }
            }
            for (Object e : tree) {
                if (e instanceof QueryAst.Window) {
                    this.write((QueryAst.Window)e);
                    continue;
                }
                this.write((String)e);
            }
        } else {
            this.write(ie.expr);
        }
    }

    private void write(QueryAst.Comment cmt) {
        this.write("-- " + cmt.value);
    }

    void writeName(QueryAst.TableLike tableLike) {
        if (StringUtils.isNotBlank((String)tableLike.getAlias())) {
            this.write(this.dialect.quoteIdentifier(tableLike.getAlias()));
        } else if (tableLike instanceof QueryAst.Table) {
            QueryAst.Table table = (QueryAst.Table)tableLike;
            this.write(this.dialect.getQuotedTableFullName(table.catalog, table.schema, table.name));
        }
    }

    void write(QueryAst.Column col) {
        if (StringUtils.isNotBlank((String)col.name)) {
            if (col.table != null) {
                this.writeName(col.table);
                this.write('.');
            }
            if ("*".equals(col.name)) {
                this.write('*');
            } else {
                this.write(this.dialect.quoteIdentifier(col.name));
            }
        } else {
            this.write("NULL");
        }
    }

    void write(QueryAst.ConstExpr expr) {
        block25: {
            Object value = expr.value;
            if (value == null) {
                this.write("NULL");
            } else if (value instanceof String) {
                boolean explicitelyWantsString;
                String strValue = (String)value;
                boolean bl = explicitelyWantsString = expr.outputType != null && expr.outputType.dssType == Type.STRING;
                if (strValue != null && !explicitelyWantsString && isoFormatScreener.matcher(strValue).matches()) {
                    try {
                        DateTime date = this.isoFormatter.parseDateTime(strValue);
                        String sqlTime = this.sqlFormatter.print((ReadableInstant)date);
                        if (this.dialect instanceof SparkSQLDialect && expr.outputType.useCurrentTZForQuoteDate) {
                            this.write(((SparkSQLDialect)this.dialect).quoteDateAsDeltaPartitionValue(sqlTime));
                            break block25;
                        }
                        this.write(this.dialect.quoteDate(sqlTime));
                    }
                    catch (IllegalArgumentException e) {
                        this.write(this.dialect.quoteString(strValue));
                    }
                } else if (strValue != null && !explicitelyWantsString && sqlFormatScreener.matcher(strValue).matches()) {
                    try {
                        this.write(this.dialect.quoteDatetimeNoTz(strValue));
                    }
                    catch (IllegalArgumentException e) {
                        this.write(this.dialect.quoteString(strValue));
                    }
                } else {
                    this.write(this.dialect.quoteString(strValue));
                }
            } else if (value instanceof Number) {
                this.write(value.toString());
            } else if (value instanceof DateTime) {
                this.write(this.dialect.quoteDate(this.sqlFormatter.print((ReadableInstant)((DateTime)value))));
            } else if (value instanceof LocalDate) {
                this.write(this.dialect.quoteDateOnly(this.sqlDateFormatter.print((ReadablePartial)((LocalDate)value))));
            } else if (value instanceof LocalDateTime) {
                this.write(this.dialect.quoteDatetimeNoTz(this.sqlFormatter.print(((LocalDateTime)value).toDateTime(DateTimeZone.UTC).getMillis())));
            } else if (value instanceof Boolean) {
                this.write(this.dialect.booleanRepr((Boolean)value));
            } else if (value instanceof Pattern) {
                this.write(this.dialect.quoteString(value.toString()));
            } else {
                throw new QueryUtils.SQLGenerationException("SQL Write error: cannot write value of type " + String.valueOf(value.getClass()));
            }
        }
    }

    void write(QueryAst.ListExpr expr) {
        this.write("(");
        boolean first = true;
        for (QueryAst.Expr item : expr.items) {
            if (!first) {
                this.write(",");
            }
            this.write(item);
            first = false;
        }
        this.write(")");
    }

    void write(QueryAst.OperatorExpr expr) {
        this.dialect.checkWindowForAnalyticFunction(expr.op, expr.window);
        QueryAst.Expr[] args = expr.args.toArray(new QueryAst.Expr[0]);
        this.write(this.dialect.applyOperator(expr.op, args));
        this.writeOverClause(expr.window);
    }

    private String getSqlOperator(QueryAst.QuerySetOperator operator) {
        switch (operator) {
            case UNION: {
                return this.getOperatorFromDialect((QueryUtils.OperatorType)QueryUtils.OperatorType.UNION).name;
            }
            case UNION_ALL: {
                return this.getOperatorFromDialect((QueryUtils.OperatorType)QueryUtils.OperatorType.UNION_ALL).name;
            }
        }
        return operator.toString();
    }

    private QueryUtils.AbstractOperator getOperatorFromDialect(QueryUtils.OperatorType operator) {
        QueryUtils.AbstractOperator sqlOperator = this.dialect.getOperator(operator);
        if (sqlOperator == null) {
            throw new IllegalStateException(String.format("Operator %s is not supported on %s database", new Object[]{operator, this.dialect.getId()}));
        }
        return sqlOperator;
    }

    private static class Indenter {
        private int indentLevel = 0;

        private Indenter() {
        }

        public void newLine(StringBuilder s) {
            s.append("\n");
            for (int i = 0; i < this.indentLevel; ++i) {
                s.append("  ");
            }
        }

        public void startBlock() {
            ++this.indentLevel;
        }

        public void endBlock() {
            --this.indentLevel;
        }
    }

    private static enum AliasPosition {
        BEFORE,
        AFTER;

    }
}

