/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.streaming.endpoints.sqs;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.streaming.endpoints.StringBasedFormats;
import com.dataiku.dip.streaming.endpoints.sqs.SQSFormatDeserializer;
import com.dataiku.dip.streaming.endpoints.sqs.SQSFormatSerializer;
import com.dataiku.dip.utils.DKULogger;

public class JSONSQSFormat {
    private static DKULogger logger = DKULogger.getLogger((String)"dku.streaming.sqs.json");

    public static class JSONSQSFormatSerializer
    implements SQSFormatSerializer {
        private final JSONSQSFormatParams params;
        private StringBasedFormats.JSONLineFormatSerializer serializer;

        public JSONSQSFormatSerializer(JSONSQSFormatParams params) {
            this.params = params;
        }

        @Override
        public void init(ColumnFactory cf, Schema schema) {
            this.serializer = new StringBasedFormats.JSONLineFormatSerializer(cf, schema, null);
        }

        @Override
        public String serialize(Row row) {
            return this.serializer.serialize(row);
        }
    }

    public static class JSONSQSFormatDeserializer
    implements SQSFormatDeserializer {
        private final JSONSQSFormatParams params;
        private RowFactory rf;
        private StringBasedFormats.JSONLineFormatDeserializer deserializer;

        public JSONSQSFormatDeserializer(JSONSQSFormatParams params) {
            this.params = params;
        }

        @Override
        public void init(ColumnFactory cf, RowFactory rf, Schema schema) {
            this.rf = rf;
            this.deserializer = new StringBasedFormats.JSONLineFormatDeserializer(cf, null);
        }

        @Override
        public Row deserialize(String record) {
            Row row = this.rf.row();
            this.deserializer.deserialize(record, row);
            return row;
        }
    }

    public static class JSONSQSFormatParams {
    }
}

