/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.variables;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.BackendVariablesService;
import com.dataiku.dip.variables.HierarchicalVariablesContext;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class AddableVariablesService
extends VariablesService {
    @Autowired
    private TransactionService ts;
    private List<File> additionalFiles = new ArrayList<File>();

    public void clearAll() {
        this.additionalFiles.clear();
    }

    public void addFile(File file) {
        this.additionalFiles.add(file);
    }

    private void addConfigFile(HierarchicalVariablesContext context, String path) throws IOException {
        if (TransactionContext.hasAttachedTransaction()) {
            TransactionRef t = TransactionContext.retrieveRead();
            AddableVariablesService.addLevel(context, t, "variables.json");
        } else {
            try (Transaction t = this.ts.beginRead();){
                AddableVariablesService.addLevel(context, (TransactionRef)t, "variables.json");
            }
        }
    }

    @Override
    public VariablesContext getGlobalContext() {
        try {
            HierarchicalVariablesContext hvc = new HierarchicalVariablesContext();
            hvc.addLevel(BackendVariablesService.getGlobalBuiltinLevel());
            this.addConfigFile(hvc, "variables.json");
            File localVariables = ApplicationConfigurator.getFile((String)"local/variables.json");
            if (localVariables.exists()) {
                hvc.addLevel((JsonObject)JSON.parseFile((File)localVariables, JsonObject.class));
            }
            for (File f : this.additionalFiles) {
                if (!f.exists()) continue;
                hvc.addLevel((JsonObject)JSON.parseFile((File)f, JsonObject.class));
            }
            return hvc;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to read variables", e);
        }
    }

    @Override
    public VariablesContext getGlobalContextAndUserLogin(AuthCtx authCtx) {
        return this.getGlobalContext();
    }

    @Override
    public VariablesContext getContextAndUserLogin(String projectKey, AuthCtx authCtx) {
        return this.getContext(projectKey);
    }

    @Override
    public VariablesContext getContext(String projectKey) {
        try {
            HierarchicalVariablesContext hvc = new HierarchicalVariablesContext();
            hvc.addLevel(BackendVariablesService.getGlobalBuiltinLevel());
            this.addConfigFile(hvc, "variables.json");
            File localVariables = ApplicationConfigurator.getFile((String)"local/variables.json");
            if (localVariables.exists()) {
                hvc.addLevel((JsonObject)JSON.parseFile((File)localVariables, JsonObject.class));
            }
            this.addConfigFile(hvc, "projects/" + projectKey + "/variables.json");
            for (File f : this.additionalFiles) {
                if (!f.exists()) continue;
                hvc.addLevel((JsonObject)JSON.parseFile((File)f, JsonObject.class));
            }
            return hvc;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to read variables", e);
        }
    }

    @Override
    public VariablesContext getForConnection(DSSConnection connection, AuthCtx authCtx) {
        try {
            HierarchicalVariablesContext hvc = new HierarchicalVariablesContext();
            hvc.addLevel(BackendVariablesService.getGlobalBuiltinLevel());
            this.addConfigFile(hvc, "variables.json");
            File localVariables = ApplicationConfigurator.getFile((String)"local/variables.json");
            if (localVariables.exists()) {
                hvc.addLevel((JsonObject)JSON.parseFile((File)localVariables, JsonObject.class));
            }
            for (File f : this.additionalFiles) {
                if (!f.exists()) continue;
                hvc.addLevel((JsonObject)JSON.parseFile((File)f, JsonObject.class));
            }
            return hvc;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to read variables", e);
        }
    }

    @Override
    public VariablesContext getForEverything(DSSConnection connection, AuthCtx authCtx, String projectKey) {
        return this.getContext(projectKey);
    }

    @Override
    public VariablesContext getForConnectionAndProject(DSSConnection connection, AuthCtx authCtx, String projectKey) {
        return this.getContext(projectKey);
    }
}

