/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.webapps.codestudio;

import com.dataiku.dip.codestudio.object.CodeStudioObject;
import com.dataiku.dip.dao.CodeStudioObjectsDAO;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dip.webapps.WebApp;
import com.dataiku.dip.webapps.WebAppHandler;
import com.dataiku.dip.webapps.codestudio.CodeStudioWebAppMeta;
import java.io.File;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;

public class CodeStudioWebAppHandler
extends WebAppHandler {
    @Autowired
    protected VariablesService variablesService;
    protected CodeStudioWebAppMeta.CodeStudioWebAppParams params;
    protected static DKULogger logger = DKULogger.getLogger((String)"dku.webapps.codestudio");

    public CodeStudioWebAppHandler(WebApp webapp) {
        this.webapp = webapp;
        this.params = webapp.getParamsAs(CodeStudioWebAppMeta.CodeStudioWebAppParams.class);
        SpringUtils.getInstance().autowire((Object)this);
    }

    @Override
    public void initWebApp() throws IOException {
    }

    @Override
    public void initWebAppTemplate(String templateId, File templateDir) throws IOException {
        logger.info((Object)("Init webapp with template: " + templateId));
    }

    @Override
    public void readCodeFiles() {
        try {
            this.params.projectKey = this.webapp.projectKey;
            CodeStudioObject codeStudio = (CodeStudioObject)((CodeStudioObjectsDAO)SpringUtils.getBean(CodeStudioObjectsDAO.class)).getMandatoryUnsafe(this.webapp.projectKey, this.params.codeStudioId);
            this.params.libName = codeStudio.libName;
            this.params.codeStudioName = codeStudio.name;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read web app.", e);
        }
    }

    @Override
    public void writeCodeFiles() throws IOException {
    }

    @Override
    public void deleteCodeFiles() throws IOException {
    }

    @Override
    public void initCustomWebApp() throws IOException {
    }
}

