/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.webapps.codestudio;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.codestudio.CodeStudioMeta;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.trust.FingerprintService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.webapps.WebApp;
import com.dataiku.dip.webapps.WebAppHandler;
import com.dataiku.dip.webapps.WebAppMeta;
import com.dataiku.dip.webapps.backend.WebAppBackend;
import com.dataiku.dip.webapps.backend.WebAppBackendInstance;
import com.dataiku.dip.webapps.backend.WebAppBackendRunner;
import com.dataiku.dip.webapps.codestudio.CodeStudioWebAppHandler;
import com.dataiku.dip.webapps.codestudio.backend.CodeStudioWebAppBackendRunner;
import com.dataiku.dip.webapps.plugins.WebAppDesc;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.binary.Base64;

public class CodeStudioWebAppMeta
implements WebAppMeta {
    public static final String TYPE = "CODE_STUDIO_AS_WEBAPP";
    public static final CodeStudioWebAppMeta META = new CodeStudioWebAppMeta();

    @Override
    public Class<? extends WebApp.WebAppParams> getParamsClass() {
        return CodeStudioWebAppParams.class;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public boolean isCustomWebApp() {
        return false;
    }

    @Override
    public WebAppBackendRunner buildRunner(WebApp webApp, WebAppBackend webAppBackend, JsonObject variables, AuthCtx user, WebAppBackendInstance webAppBackendInstance) {
        try {
            return new CodeStudioWebAppBackendRunner(webApp, webAppBackend, variables, user, webAppBackendInstance);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to build code-studio-as-webapp runner", e);
        }
    }

    @Override
    public WebAppHandler buildHandler(WebApp webapp) {
        return new CodeStudioWebAppHandler(webapp);
    }

    @Override
    public WebAppDesc getWebAppDesc() {
        return null;
    }

    @Override
    public List<Object> getHashElements(WebApp webApp) {
        CodeStudioWebAppParams params = webApp.getParamsAs(CodeStudioWebAppParams.class);
        ArrayList ret = Lists.newArrayList();
        ret.add(params.codeStudioId);
        return ret;
    }

    public static class CodeStudioWebAppParams
    extends WebApp.WebAppParams {
        public String codeStudioId;
        public CodeStudioMeta.ExposedCodeStudioPort exposedPort;
        public boolean autoStartBackend;
        public boolean backendAPIAccessEnabled;
        @JSON.FileTransient
        public String projectKey;
        @JSON.FileTransient
        public String codeStudioName;
        @JSON.FileTransient
        public String libName;

        @Override
        public boolean isBackendEnabled() {
            return true;
        }

        @Override
        public boolean isAutoStartBackend() {
            return this.autoStartBackend;
        }

        @Override
        public JsonObject getSensitiveSettings(AuthCtx authCtx) throws IOException, DKUSecurityException {
            String login = authCtx.getAssociatedDSSUserMand();
            JsonObject ret = super.getSensitiveSettings(authCtx);
            ret.addProperty("codeStudioId", this.codeStudioId);
            RelFile codeStudioVersionedPath = new RelFile(new String[]{"projects", this.projectKey, "code_studios", this.codeStudioId});
            RelFile projectVersionedPath = new RelFile(new String[]{"projects", this.projectKey, "lib"});
            RelFile userVersionedPath = new RelFile(new String[]{"user-data", login});
            byte[] versionedHash = ((FingerprintService)SpringUtils.getBean(FingerprintService.class)).computeDirectoriesFingerprint(Lists.newArrayList((Object[])new RelFile[]{codeStudioVersionedPath, projectVersionedPath, userVersionedPath}));
            ret.addProperty("versioned", Base64.encodeBase64String((byte[])versionedHash));
            byte[] projectsResourcesHash = ((FingerprintService)SpringUtils.getBean(FingerprintService.class)).computeResourcesDirectoryFingerprint(ApplicationConfigurator.getFile((String[])new String[]{"lib", "projects", this.projectKey}));
            ret.addProperty("projectsResources", Base64.encodeBase64String((byte[])projectsResourcesHash));
            byte[] codeStudioResourcesHash = ((FingerprintService)SpringUtils.getBean(FingerprintService.class)).computeResourcesDirectoryFingerprint(ApplicationConfigurator.getFile((String[])new String[]{"lib", "code_studio", this.projectKey, this.libName}));
            ret.addProperty("codeStudioResources", Base64.encodeBase64String((byte[])codeStudioResourcesHash));
            byte[] userResourcesHash = ((FingerprintService)SpringUtils.getBean(FingerprintService.class)).computeResourcesDirectoryFingerprint(ApplicationConfigurator.getFile((String[])new String[]{"lib", "user-data", login}));
            ret.addProperty("userResources", Base64.encodeBase64String((byte[])userResourcesHash));
            return ret;
        }

        @Override
        public boolean isLoadingPythonLibraries() {
            return true;
        }

        @Override
        public boolean isLoadingRLibraries() {
            return true;
        }
    }
}

