/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.webapps.codestudio.backend;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.apideployer.datamodel.config.K8SAPIDeploymentInfra;
import com.dataiku.dip.cluster.Cluster;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.codestudio.CodeStudioMeta;
import com.dataiku.dip.codestudio.CodeStudioRegistry;
import com.dataiku.dip.codestudio.object.CodeStudioObject;
import com.dataiku.dip.codestudio.runtime.CodeStudioRuntime;
import com.dataiku.dip.codestudio.runtime.CodeStudioSyncZones;
import com.dataiku.dip.codestudio.template.CodeStudioTemplate;
import com.dataiku.dip.codestudio.template.CodeStudioTemplateImagesHandler;
import com.dataiku.dip.codestudio.template.CodeStudioTemplatesService;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.containers.exec.KubernetesExecUtils;
import com.dataiku.dip.containers.exec.YamlUtils;
import com.dataiku.dip.dataflow.exec.EnvironmentStash;
import com.dataiku.dip.exposition.ExposedEndpointConsumer;
import com.dataiku.dip.remoterun.RemoteRunEnvDef;
import com.dataiku.dip.remoterun.RemoteRunsRegistry;
import com.dataiku.dip.resourceusage.ComputeResourceUsage;
import com.dataiku.dip.resourceusage.k8s.IK8SContainerLimits;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.util.JsonUtils;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.PathUtils;
import com.dataiku.dip.webapps.WebApp;
import com.dataiku.dip.webapps.WebAppLaunchInfo;
import com.dataiku.dip.webapps.WebAppSecurityInfo;
import com.dataiku.dip.webapps.backend.AbstractWebAppKubernetesKernel;
import com.dataiku.dip.webapps.backend.WebAppBackend;
import com.dataiku.dip.webapps.backend.WebAppBackendInfra;
import com.dataiku.dip.webapps.backend.WebAppBackendInstance;
import com.dataiku.dip.webapps.backend.WebAppBackendKernel;
import com.dataiku.dip.webapps.codestudio.CodeStudioWebAppMeta;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class CodeStudioWebAppKubernetesKernel
extends AbstractWebAppKubernetesKernel {
    private final WebAppBackend backend;
    private final CodeStudioObject codeStudio;
    private final CodeStudioTemplate template;
    private final CodeStudioMeta.ExposedCodeStudioPort exposedPort;
    private CodeStudioRuntime.ContainerForwardedPort forwardedPort;
    public String readinessProbeUrl;
    private List<CodeStudioMeta.SyncZoneInstance> syncedZones = Lists.newArrayList();
    static DKULogger logger = DKULogger.getLogger((String)"dku.webapps.codestudio");

    public CodeStudioWebAppKubernetesKernel(WebApp webApp, ContainerExecRuntimeConfig containerConfig, WebAppBackend backend, CodeStudioObject codeStudio, CodeStudioTemplate template, AuthCtx authCtx, JsonObject userVariables, WebAppLaunchInfo launchInfo, WebAppSecurityInfo securityInfo, File workingDir, APITicketService.Ticket ticket, DKUtils.LineSubscriptionAttacher mainLog, DKUtils.SmartLogTailBuilder smartLogTailBuilder) {
        super(webApp, containerConfig, authCtx, userVariables, launchInfo, securityInfo, workingDir, ticket, mainLog, smartLogTailBuilder);
        this.backend = backend;
        this.codeStudio = codeStudio;
        this.template = template;
        this.exposedPort = ((CodeStudioWebAppMeta.CodeStudioWebAppParams)webApp.params).exposedPort;
    }

    @Override
    protected Object getCommand() {
        return null;
    }

    @Override
    protected String getReadinessProbe() {
        return null;
    }

    @Override
    protected RemoteRunsRegistry.ExecutionType getExecutionType() {
        return RemoteRunsRegistry.ExecutionType.CODE_STUDIO;
    }

    @Override
    protected CodeEnvModel.EnvLang getEnvLang() {
        return null;
    }

    public CodeStudioMeta.SyncZoneInstance getZone(String zoneId) throws Exception {
        return this.syncedZones.stream().filter(z -> zoneId.equals(z.id)).findFirst().orElseThrow(() -> new Exception("No zone " + zoneId));
    }

    @Override
    public WebAppBackendKernel.MainKernelProcess prepareRun(WebAppBackendInstance webAppBackendInstance, ExposedEndpointConsumer.ExposedEndpoint expectedExposedEndpoint) throws Exception {
        boolean webappIsPublic;
        this.webAppBackendInstance = webAppBackendInstance;
        KubernetesExecUtils.LabelsAndAnnotations laa = KubernetesExecUtils.getIdentifiersBasedOnCRUContext(this.authCtx, this.executionId, this.containerConfig);
        CodeStudioMeta meta = CodeStudioRegistry.getMeta(this.template);
        CodeStudioMeta.CodeStudioWebAppLaunchEnv launchEnv = new CodeStudioMeta.CodeStudioWebAppLaunchEnv();
        launchEnv.projectKey = this.codeStudio.projectKey;
        launchEnv.apiTicket = this.ticket.getSecret();
        launchEnv.workingDir = this.workingDir.getAbsolutePath();
        launchEnv.executionId = this.executionId;
        launchEnv.containerConfig = this.containerConfig;
        launchEnv.baseUrlLNT = PathUtils.makeLeadingNoTrailing((String)this.backend.getBackendUrl(expectedExposedEndpoint));
        launchEnv.baseUrlLNTPerPort = "${baseUrl}";
        launchEnv.labels = laa.getLabels();
        launchEnv.annotations = laa.annotations;
        launchEnv.launchedFrom = CodeStudioMeta.CodeStudioLaunchedFrom.WEBAPP;
        launchEnv.exposedPortToDisplay = this.exposedPort != null ? Integer.valueOf(this.exposedPort.port) : null;
        CodeStudioTemplatesService.CodeStudioTemplateImageBuilt imageBuilt = CodeStudioTemplatesService.getLatest(this.template, this.containerConfig.name);
        if (imageBuilt == null) {
            throw new IllegalArgumentException("No image build recorded for this Code Studio template");
        }
        String dssVersionTag = DKUApp.getDSSVersionTag();
        if (!dssVersionTag.equals(imageBuilt.dssVersion)) {
            throw new IllegalStateException("The code studio template must be rebuilt");
        }
        launchEnv.templateImage = CodeStudioTemplateImagesHandler.getCodeStudioImageName(this.template) + ":dss-" + dssVersionTag + "-" + imageBuilt.buildId;
        launchEnv.publiclyExposed = webappIsPublic = this.securityInfo == null || !this.securityInfo.hideAccessToken && !this.securityInfo.backendCheckAccess;
        CodeStudioMeta.CodeStudioLaunchSpec launchSpec = meta.getLaunchSpec(this.authCtx, this.template, launchEnv);
        logger.debug((Object)("Got launchSpec\n" + JSON.pretty((Object)launchSpec)));
        if (!"deployment".equalsIgnoreCase(launchSpec.k8sHeadObjectType)) {
            throw new Exception("Only Code Studios using a deployment as main K8S object can be used as webapps");
        }
        if (launchSpec.entrypoints.isEmpty()) {
            throw new Exception("The Code Studio template must define at least one entrypoint, and activate it for Webapps");
        }
        Optional<CodeStudioMeta.ExposedCodeStudioPort> specPort = launchSpec.exposedPorts.stream().filter(p -> p.port == launchEnv.exposedPortToDisplay).findFirst();
        if (!specPort.isPresent()) {
            throw new Exception("The Exposed port requested by the Webapp does not exist in the Code Studio template. Maybe the template was changed ?");
        }
        CodeStudioMeta.ExposedCodeStudioPort exposedCodeStudioPort = specPort.get();
        this.forwardedPort = new CodeStudioRuntime.ContainerForwardedPort(exposedCodeStudioPort.port);
        int tcpProbePort = 0;
        this.readinessProbeUrl = StringUtils.defaultIfBlank((String)exposedCodeStudioPort.readinessProbeUrl, (String)launchSpec.readinessProbeUrl);
        logger.info((Object)("Using readiness probe url : " + this.readinessProbeUrl + " (launch spec's probe url : " + launchSpec.readinessProbeUrl + ")"));
        if (StringUtils.isNotBlank((String)this.readinessProbeUrl)) {
            KubernetesExecUtils.HttpGetActionParts probeParts = KubernetesExecUtils.getProbeParts(this.readinessProbeUrl);
            if (StringUtils.isNotBlank((String)probeParts.path) && !"/".equals(probeParts.path)) {
                this.readinessProbeUrl = probeParts.path;
            }
            if (launchSpec.useTcpReadiness) {
                tcpProbePort = probeParts.port;
            }
        }
        if (exposedCodeStudioPort.containerPort != null) {
            this.forwardedPort.outsidePort = exposedCodeStudioPort.containerPort;
        }
        this.backend.setProxiedUrlSuffix(exposedCodeStudioPort.proxiedUrlSuffix);
        YamlUtils yamlUtils = new YamlUtils();
        List<Object> specElts = yamlUtils.yamlToJsonElements(launchSpec.yaml);
        specElts = specElts.stream().map(e -> this.transformIfNeeded((JsonElement)e, launchSpec.k8sHeadObjectType, launchSpec.k8sHeadObjectName)).collect(Collectors.toList());
        launchSpec.yaml = yamlUtils.jsonElementsToYam(specElts);
        CodeStudioRuntime.CodeStudioRunDefinition codeStudioDefinition = new CodeStudioRuntime.CodeStudioRunDefinition();
        codeStudioDefinition.entrypoints = launchSpec.entrypoints;
        codeStudioDefinition.projectKey = this.codeStudio.projectKey;
        codeStudioDefinition.codeStudioId = this.codeStudio.id;
        codeStudioDefinition.baseUrl = launchEnv.baseUrlLNT;
        codeStudioDefinition.syncedZones = launchSpec.syncedZones.stream().filter(z -> CodeStudioSyncZones.lookup(z.zone).canWebapp()).map(JSON::deepCopy).collect(Collectors.toList());
        for (CodeStudioMeta.SyncZoneInstance zone : codeStudioDefinition.syncedZones) {
            zone.id = zone.zone + "_" + SecretKeyGenerator.generate((int)6);
        }
        codeStudioDefinition.excludedFromSync = launchSpec.excludedFromSync;
        codeStudioDefinition.fileAdjustmentScript = launchSpec.fileAdjustmentScript;
        codeStudioDefinition.handleCommands = false;
        codeStudioDefinition.webAppId = this.webApp.id;
        codeStudioDefinition.ports = Lists.newArrayList((Object[])new CodeStudioRuntime.ContainerForwardedPort[]{this.forwardedPort});
        codeStudioDefinition.readinessProbeUrl = this.readinessProbeUrl;
        codeStudioDefinition.tcpProbePort = tcpProbePort;
        codeStudioDefinition.securityInfo = this.securityInfo;
        RemoteRunsRegistry.add(this.executionId, this.authCtx, this.webApp.projectKey, this.workingDir.getPath(), this.workingDir.getPath(), this.getExecutionType(), JSON.json((Object)codeStudioDefinition), "", Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
        this.syncedZones = codeStudioDefinition.syncedZones;
        RemoteRunEnvDef envResource = new RemoteRunEnvDef();
        envResource.runsRemotely = false;
        envResource.cwd = this.workingDir.getAbsolutePath();
        EnvironmentStash envStash = this.getEnvironmentForRemoteKernel();
        if (this.userVariables != null) {
            envStash.customVariables = (Map)JSON.parse((JsonElement)this.userVariables, (TypeToken)new TypeToken<Map<String, Object>>(){});
        }
        if (this.launchInfo.pluginId != null) {
            envStash.env.put("DKU_PLUGIN_ID", this.launchInfo.pluginId);
            WebAppBackend.putResourceFolderEnvironmentVariable(envStash.env, "/home/dataiku/plugin/resource");
        }
        if (this.launchInfo.config != null) {
            envStash.env.put("DKU_CUSTOM_WEBAPP_CONFIG", JSON.json((Object)this.launchInfo.config));
        }
        if (this.launchInfo.pluginConfig != null) {
            envStash.env.put("DKU_PLUGIN_CONFIG", JSON.pretty((Object)this.launchInfo.pluginConfig));
        }
        envStash.copyToRemoteRunEnvDef(envResource, false, false, false);
        envResource.env.remove("DKU_SOURCE_LIB_R_PATH");
        envResource.jobId = this.executionId;
        RemoteRunsRegistry.get((String)this.executionId).envResource = envResource;
        logger.infoV("Executing webapp on Kubernetes with config=%s, using image '%s', executionId=%s", new Object[]{this.containerConfig.name, launchEnv.templateImage, this.executionId});
        File secretFile = new File(this.workingDir, "secret_" + this.executionId + ".yaml");
        File deploymentFile = new File(this.workingDir, "deployment_" + this.executionId + ".yaml");
        File autoscalerFile = new File(this.workingDir, "hpa_" + this.executionId + ".yaml");
        this.deploymentStartFiles = Lists.newArrayList((Object[])new String[]{"-f", secretFile.getAbsolutePath(), "-f", deploymentFile.getAbsolutePath()});
        if (this.webApp.params.infra.scaling.hpa) {
            this.deploymentStartFiles.add("-f");
            this.deploymentStartFiles.add(autoscalerFile.getAbsolutePath());
        }
        String k8sClusterId = new ClusterSelector().getClusterForProject(this.webApp.projectKey, Cluster.ClusterArchitecture.KUBERNETES);
        K8SAPIDeploymentInfra.K8SContainerLimits k8sContainerLimits = this.containerConfig.kubernetesResources;
        this.cru = ComputeResourceUsage.forSingleK8SJob((String)k8sClusterId, (String)this.executionId, (IK8SContainerLimits)k8sContainerLimits).reportStartNoFail();
        String[] cmd = KubernetesExecUtils.getKubeCtlApplyCommand(this.authCtx, this.webApp.projectKey, this.containerConfig, this.deploymentStartFiles.toArray(new String[0]));
        ProcessBuilder startProcessBuilder = new ProcessBuilder(new String[0]);
        startProcessBuilder.directory(this.workingDir);
        startProcessBuilder.command(cmd);
        startProcessBuilder.environment().putAll(KubernetesExecUtils.getKubeCtlEnv(this.containerConfig));
        String secretDesc = KubernetesExecUtils.getTicketSecretConf(this.executionId, this.ticket.getSecret());
        WebAppBackendInfra infra = this.webApp.params.infra;
        DKUFileUtils.writeFileUTF8((File)secretFile, (String)secretDesc);
        DKUFileUtils.writeFileUTF8((File)deploymentFile, (String)launchSpec.yaml);
        if (this.webApp.params.infra.scaling.hpa) {
            String autoscalerDesc = KubernetesExecUtils.getAutoscalerConf(this.executionId, launchSpec.k8sHeadObjectName, this.containerConfig, infra.scaling);
            DKUFileUtils.writeFileUTF8((File)autoscalerFile, (String)autoscalerDesc);
        }
        DKUtils.ExecOutputConsumer startEoc = new DKUtils.ExecOutputConsumer().withErrorConsumer((DKUtils.ExecSubscription)new DKUtils.TailerLineSubscription(this.smartLogTailBuilder)).withOutputConsumer((DKUtils.ExecSubscription)new DKUtils.TailerLineSubscription(this.smartLogTailBuilder));
        startEoc.withOutputConsumer((DKUtils.ExecSubscription)this.mainLog.getSubSubscription("[k8s] ")).withErrorConsumer((DKUtils.ExecSubscription)this.mainLog.getSubSubscription("[k8s] "));
        return new WebAppBackendKernel.KubernetesMainKernelProcess(startProcessBuilder, startEoc, this.executionId, this.forwardedPort.outsidePort, launchSpec.k8sHeadObjectName, this.authCtx, this.webApp.projectKey, this.webApp.id);
    }

    private JsonElement transformIfNeeded(JsonElement elt, String k8sHeadObjectType, String k8sHeadObjectName) {
        if (elt instanceof JsonObject) {
            JsonObject obj = elt.getAsJsonObject();
            if (obj.has("kind") && !obj.get("kind").isJsonNull() && k8sHeadObjectType.equalsIgnoreCase(obj.getAsJsonPrimitive("kind").getAsString())) {
                String name = JsonUtils.getOrNullStr(obj, "metadata", "name");
                if (StringUtils.equals((String)k8sHeadObjectName, (String)name)) {
                    return this.transform(obj);
                }
                return elt;
            }
            return elt;
        }
        return elt;
    }

    private JsonObject transform(JsonObject obj) {
        JsonObject templateLabels;
        JsonObject templateMetadata;
        CodeStudioWebAppMeta.CodeStudioWebAppParams params = this.webApp.getParamsAs(CodeStudioWebAppMeta.CodeStudioWebAppParams.class);
        JsonObject spec = obj.getAsJsonObject("spec");
        if (spec.has("replicas")) {
            spec.remove("replicas");
        }
        spec.addProperty("replicas", (Number)params.infra.scaling.initialReplicas);
        if (spec.has("selector")) {
            spec.remove("selector");
        }
        spec.add("selector", (JsonElement)new JsonObject());
        spec.getAsJsonObject("selector").add("matchLabels", (JsonElement)new JsonObject());
        spec.getAsJsonObject("selector").getAsJsonObject("matchLabels").addProperty("dataiku.com/dku-execution-id", this.executionId);
        JsonObject templateObj = spec.getAsJsonObject("template");
        if (!templateObj.has("metadata")) {
            templateObj.add("metadata", (JsonElement)new JsonObject());
        }
        if (!(templateMetadata = templateObj.getAsJsonObject("metadata")).has("labels")) {
            templateMetadata.add("labels", (JsonElement)new JsonObject());
        }
        if ((templateLabels = templateMetadata.getAsJsonObject("labels")).has("dataiku.com/dku-execution-id")) {
            templateLabels.remove("dataiku.com/dku-execution-id");
        }
        templateLabels.addProperty("dataiku.com/dku-execution-id", this.executionId);
        return obj;
    }
}

