/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr;

import com.dataiku.dip.variables.VariablesContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.refine.expr.HasFields;
import java.util.Properties;
import org.apache.log4j.Logger;

public class WrappedVariables
implements HasFields {
    private final VariablesContext vc;
    private static final Logger logger = Logger.getLogger((String)"dip.grep.wrappedvariables");

    public WrappedVariables(VariablesContext vc) {
        this.vc = vc;
    }

    public boolean hasValue(String name) {
        return this.vc.has(name);
    }

    @Override
    public Object getField(String name, Properties bindings) {
        logger.trace((Object)("get " + name));
        JsonElement obj = this.vc.lookup(name);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("-> " + String.valueOf(obj)));
        }
        if (obj.isJsonArray()) {
            return obj.getAsJsonArray();
        }
        if (obj.isJsonPrimitive()) {
            JsonPrimitive primitive = obj.getAsJsonPrimitive();
            if (primitive.isJsonNull()) {
                return null;
            }
            if (primitive.isBoolean()) {
                return primitive.getAsBoolean();
            }
            if (primitive.isNumber()) {
                return primitive.getAsDouble();
            }
            if (primitive.isString()) {
                return primitive.getAsString();
            }
            return primitive;
        }
        return obj;
    }

    @Override
    public boolean fieldAlsoHasFields(String name) {
        return false;
    }
}

