/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.grel.controls;

import com.google.refine.expr.Evaluable;
import com.google.refine.expr.ExpressionUtils;
import com.google.refine.grel.Control;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.GrelControlFunctionRegistry;
import com.google.refine.grel.ast.VariableExpr;
import java.util.Properties;

public class ForNonBlank
implements Control {
    @Override
    public String checkArguments(Evaluable[] args) {
        if (args.length != 4) {
            return GrelControlFunctionRegistry.getInstance().getControlName(this) + " expects 4 arguments";
        }
        if (!(args[1] instanceof VariableExpr)) {
            return GrelControlFunctionRegistry.getInstance().getControlName(this) + " expects second argument to be a variable name";
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object call(Properties bindings, Evaluable[] args) {
        Object o = args[0].evaluate(bindings);
        Evaluable var = args[1];
        String name = ((VariableExpr)var).getName();
        if (ExpressionUtils.isNonBlankData(o)) {
            Object oldValue = bindings.get(name);
            bindings.put(name, o);
            try {
                Object object = args[2].evaluate(bindings);
                return object;
            }
            finally {
                if (oldValue != null) {
                    bindings.put(name, oldValue);
                } else {
                    bindings.remove(name);
                }
            }
        }
        return args[3].evaluate(bindings);
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.ForNonBlank.DOCUMENTATION", "Evaluates expression o. If it is non-blank, binds its value to variable name v, evaluates expression eNonBlank and returns the result. Otherwise (if o evaluates to blank), evaluates expression eBlank and returns that result instead.").withParams("expression o, variable v, expression eNonBlank, expression eBlank").withReturns("GREL.FUNCTIONS.RETURNS.DEPENDS_ON_ARGUMENTS", "depends on arguments").withCategory("GREL.FUNCTIONS.CATEGORY.CONTROL_STRUCTURES", "Control structures").withDeprecated().withHidden(true);
    }
}

