/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.grel.controls;

import com.dataiku.dip.i18n.LocalizedString;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Example;
import com.google.refine.grel.controls.IsTest;
import org.apache.commons.lang.StringUtils;

public class IsNull
extends IsTest {
    @Override
    protected LocalizedString getDescription() {
        return new LocalizedString("GREL.FUNCTION.IsNull.DOCUMENTATION", "Returns whether <code>o</code> is null or an empty string. It returns true when value is null or empty (\"\").<br/>It considers a string made of blank spaces as null, and does not consider an expression with an error as null.");
    }

    @Override
    protected boolean test(Object o) {
        if (o instanceof String) {
            return StringUtils.isBlank((String)((String)o));
        }
        return o == null;
    }

    @Override
    public Documentation getDocumentation() {
        return super.getDocumentation().withExample(Example.with("\"\"").returns("true")).withExample(Example.with("\" \"").returns("true")).withExample(Example.with("abs(\"a\")").returns("false"));
    }
}

