/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.objectinspector.primitive;

import com.dataiku.dip.input.formats.hive.serde.DSSInspectionException;
import com.dataiku.dip.shaker.types.Boolean;
import org.apache.hadoop.hive.serde2.objectinspector.DSSBaseInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DSSAbstractPrimitiveJavaObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableBooleanObjectInspector;
import org.apache.hadoop.io.BooleanWritable;

public class DSSBooleanInspector
extends DSSAbstractPrimitiveJavaObjectInspector
implements SettableBooleanObjectInspector {
    private static Boolean booleanMeaning = new Boolean();

    public DSSBooleanInspector() {
        super(booleanTypeInfo);
    }

    public Object create(boolean value) {
        return value ? java.lang.Boolean.TRUE : java.lang.Boolean.FALSE;
    }

    public Object set(Object o, boolean value) {
        return value ? java.lang.Boolean.TRUE : java.lang.Boolean.FALSE;
    }

    public Object getPrimitiveWritableObject(Object o) {
        return o == null ? null : new BooleanWritable(this.get(o));
    }

    public boolean get(Object o) {
        if (o instanceof java.lang.Boolean) {
            return (java.lang.Boolean)o;
        }
        if (o instanceof String) {
            return booleanMeaning.parse((String)o);
        }
        throw new DSSInspectionException((DSSBaseInspector)this, "Not castable to boolean: " + String.valueOf(o) + " (" + o.getClass().getSimpleName() + ")");
    }
}

