(function(){
    'use strict';

    const requestCodeEnv = {
        bindings: {
            request: '<',
            requester: '<',
            closer: '<',
            onChange: '&',
            codeEnvObjectLink: '<'
        },
        templateUrl: '/static/dataiku/inbox/components/request-center/request/request-code-env/request-code-env.component.html',
        controller: function(CodeMirrorSettingService, RequestCenterService, CodeEnvService){
            this.callback = () => {
                const response = {type: 'CodeEnvResponse', targetName: this.request.requestDetails.targetName}; // keep type in sync with backend
                this.onChange({response});
            }
            this.$onInit = () => {
                this.callback();

                if (this.request.requestDetails.desc){
                    this.pythonInterpreters = this.request.requestDetails.desc.conda ? CodeEnvService.pythonCondaInterpreters : CodeEnvService.pythonInterpreters;

                    let pythonInterpreter = this.pythonInterpreters.find(i => i[0] === this.request.requestDetails.desc.pythonInterpreter);
                    this.pythonInterpreterLabel = pythonInterpreter ? pythonInterpreter[1] : "";

                    this.corePackagesSets = [
                        ['LEGACY_PANDAS023', 'Pandas 0.23'],
                        ['PANDAS10', 'Pandas 1.0'],
                        ['PANDAS11', 'Pandas 1.1'],
                        ['PANDAS12', 'Pandas 1.2'],
                        ['PANDAS13', 'Pandas 1.3'],
                        ['PANDAS14', 'Pandas 1.4'],
                        ['PANDAS15', 'Pandas 1.5'],
                        ['PANDAS20', 'Pandas 2.0'],
                        ['PANDAS21', 'Pandas 2.1'],
                        ['PANDAS22', 'Pandas 2.2'],
                        ['PANDAS23', 'Pandas 2.3']
                    ];
                    let corePackagesSet = this.corePackagesSets.find(i => i[0] === this.request.requestDetails.desc.corePackagesSet);
                    this.corePackagesSetLabel = corePackagesSet ? corePackagesSet[1] : "";
                }
            }

            this.getCodeEnvLangLabel = function(){
                return RequestCenterService.getCodeEnvLangLabel(this.request.objectId, this.request.requestDetails.envLang);
            }

            this.isInternalCodeEnv = function(){
                return this.request.objectId.startsWith("INTERNAL_");
            }

            this.hasCorePackages = function() {
                return this.request.requestDetails.desc.installCorePackages;
            }

            this.corePackagesLabel = function() {
                return this.hasCorePackages() ? "Yes" : "No";
            }

            this.hasJupyterSupport = function() {
                return this.request.requestDetails.desc.installJupyterSupport;
            }

            this.jupyterSupportLabel = function() {
                return this.hasJupyterSupport() ? "Yes" : "No";
            }

            const editorSettings = CodeMirrorSettingService.get('text/plain');
            this.insertReadOnlyOptions = {
                ...editorSettings,
                readOnly: true,
            };

        }
    }

    angular.module('dataiku.inbox')
    .component('requestCodeEnv', requestCodeEnv);
})();
