(function() {
    'use strict';

    const app = angular.module('dataiku.dashboards');

    /**
     * Was previously located here: src/main/platypus/static/dataiku/js/dashboards/core.js
     */
    app.controller('DashboardPageRightColumnActions', async function($controller, $scope, $rootScope, $stateParams, DataikuAPI, ActiveProjectKey) {

        $controller('_TaggableObjectPageRightColumnActions', { $scope: $scope });

        const dashboard = (await DataikuAPI.dashboards.get($stateParams.projectKey, $stateParams.dashboardId)).data;
        dashboard.nodeType = 'DASHBOARD';
        dashboard.interest = {};

        $scope.selection = {
            selectedObject: dashboard,
            confirmedItem: dashboard
        };

        $scope.renameObjectAndSave = function(newName) {
            $scope.dashboard.name = newName;
            return DataikuAPI.dashboards.save($scope.dashboard);
        };

        function updateListed() {
            DataikuAPI.dashboards.get($stateParams.projectKey, $stateParams.dashboardId).success(function(data) {

                $scope.selection.selectedObject.listed = data.listed;

            }).error(setErrorInScope.bind($scope));
        }

        function updateUserInterests() {
            DataikuAPI.interests.getForObject($rootScope.appConfig.login, 'DASHBOARD', ActiveProjectKey.get(), $stateParams.dashboardId).success(function(data) {

                $scope.selection.selectedObject.interest = data;
                $scope.dashboardFullInfo.interest = data;

            }).error(setErrorInScope.bind($scope));
        }

        updateUserInterests();
        const interestsListener = $rootScope.$on('userInterestsUpdated', updateUserInterests);
        const listedListener = $scope.$on('objectTimelineChanged', updateListed);
        $scope.$on('$destroy', interestsListener);
        $scope.$on('$destroy', listedListener);
    });

})();
