/**
 * Work around: jQuery 3.5 does not parse our templates properly
 * 
 * @todo HTML templates need to be cleaned up (they are currently not valid HTML5)
 * @see https://jquery.com/upgrade-guide/3.5/
 */
{
    const rxhtmlTag = /<(?!area|br|col|embed|hr|img|input|link|meta|param)(([a-z][^/\0>\x20\t\r\n\f]*)[^>]*)\/>/gi;
    jQuery.htmlPrefilter = function (html) {
        return html.replace(rxhtmlTag, "<$1></$2>");
    };
}

/**
 * Work around: bootstrap-less 2 and jQuery 3 are not compatible
 * 
 * @see https://github.com/twbs/bootstrap/issues/26351
 * @see https://github.com/jquery/jquery/pull/1682
 * @todo bootstrap should be updated
 */
{
    const oldJQueryFind = jQuery.fn.find;
    jQuery.fn.find = function (...args) {
        if (args.length === 1 && args[0] === '#') {
            return oldJQueryFind.call(this); // returns an empty jquery set as in jQuery < 3
        }
        return oldJQueryFind.call(this, ...args)
    };
}

/**
 * Work around: $(...).size() was removed in jQuery 3
 * (we could have replaced all usages in our codebase, but it was clearly not worth the effort)
 * 
 * @see https://api.jquery.com/category/removed/
 * @deprecated
 */
jQuery.fn.size = function () { return this.length };

/**
 * TLDR: jQuery 3 does not compute height() and width() using the same method as jQuery 2
 *
 * jQuery 2 relies on 'offsetWidth' / 'offsetHeight', whereas jQuery 3 switched to 'getBoundingClientRect()'
 * Among the differences, the new calculation methods now takes CSS transforms into account, which is arguably "more correct".
 * However, DSS relied on the legacy jQuery behavior in some places, and the new jQuery size measurement method breaks flow graph rendering in subtle ways.
 *
 * The helpers below are trying to mimic the legacy behavior of width() and height() in jQuery 2 with (a lot of) simplifications.
 * While the real implementations is much more complicated than that in jQuery 2 (ie. offset + computed style + raw style + border/box model handling...),
 * just returning 'offsetWidth' / 'offsetHeight' seems to solve our rendering problem. If we later discover that it is not enough, we
 * can still copy the whole legacy jQuery implementation here.
 *
 * These helpers should never be used in new code.
 *
 * @see in jQuery 2: https://github.com/jquery/jquery/blob/2.2-stable/src/css.js#L118
 * @see in jQuery 3: https://github.com/jquery/jquery/blob/3.x-stable/src/css.js#L119
 * @see discussions about this problem: https://github.com/jquery/jquery/issues/3193
 */
{
    /** @deprecated */
    jQuery.fn.legacyHeight = function () {
        const element = this[0];
        if (!element) {
            return null;
        }
        return element.offsetHeight;
    };
    /** @deprecated */
    jQuery.fn.legacyWidth = function () {
        const element = this[0];
        if (!element) {
            return null;
        }
        return element.offsetWidth;
    };
}
