(function() {
    'use strict';

    const app = angular.module('dataiku.charts');

    // (!) This service previously was in static/dataiku/js/simple_report/scatter/density_2d.js
    app.factory('Density2DChart', function(ChartColorScales) {

        const getUpdatedGByClass = function(svg, margins) {
            d3.select(svg).selectAll('defs').remove();
            d3.select(svg).append('defs');

            d3.select(svg).selectAll('g').remove();
            return d3.select(svg).append('g').attr('class', 'chart').attr('transform', 'translate(' + margins.left + ',' + margins.top + ')');
        };

        return function(svg, chartDef, data, chartHandler) {
            const width = $(svg).width();
            const height = $(svg).height();
            const margins = { top: 10, right: 50, bottom: 50, left: 50 };
            const chartWidth = width - margins.left - margins.right;
            const chartHeight = height - margins.top - margins.bottom;

            const g = getUpdatedGByClass(svg, margins);

            const xScale = d3.scale.linear().domain([data.xMin, data.xMax]).range([0, chartWidth]);
            const yScale = d3.scale.linear().domain([data.yMin, data.yMax]).range([chartHeight, 0]);

            const xAxis = d3.svg.axis().scale(xScale).orient('bottom');
            const yAxis = d3.svg.axis().scale(yScale).orient('left');

            const colorScale = ChartColorScales.continuousColorScale(chartDef.colorOptions, data.minDensity, data.maxDensity, data.density, undefined, chartHandler.getChartTheme());

            // i = xc  + yc * xSteps

            const rectWidth = chartWidth / data.xSteps;
            const rectHeight = chartHeight / data.ySteps;

            g.selectAll('.densityrect').data(data.density)
                .enter().append('rect')
                .attr('class', 'densityrect')
                //.attr("xc", function(d, i) { return i % data.xSteps})
                .attr('yc', function(d, i) {
                    return Math.floor(i / data.xSteps);
                })
                .attr('yv', function(d, i) {
                    const yc = Math.floor(i / data.xSteps) + 1; // NOT A TYPO
                    const yv = data.yMin + yc * (data.yMax - data.yMin) / data.ySteps;
                    return yv;
                })
                .attr('x', function(d, i) {
                    const xc = i % data.xSteps;
                    const xv = data.xMin + xc * (data.xMax - data.xMin) / data.xSteps;

                    return xScale(xv);
                })
                .attr('y', function(d, i) {
                    const yc = Math.floor(i / data.xSteps) + 1; // NOT A TYPO
                    const yv = data.yMin + yc * (data.yMax - data.yMin) / data.ySteps;
                    return yScale(yv);
                })
                .attr('width', rectWidth)
                .attr('height', rectHeight)
                .attr('fill', function(d) {
                    return colorScale(d);
                })
                .attr('stroke', function(d) {
                    return colorScale(d);
                });

            g.append('g')
                .attr('class', 'x axis')
                .style('fill', '#999')
                .style('stroke', '#999')
                .attr('transform', 'translate(0,' + chartHeight + ')')
                .call(xAxis);

            const xAxisG = g.select('g.x.axis');
            if (xAxisG) {
                xAxisG.selectAll('.tick text')
                    .attr('fill', '#333')
                    .attr('font-size', 11);
            }

            g.append('g')
                .attr('class', 'y axis')
                .style('fill', '#999')
                .style('stroke', '#999')
                .call(yAxis);

            const yAxisG = g.select('g.y.axis');
            if (yAxisG) {
                yAxisG.selectAll('.tick text')
                    .attr('fill', '#333')
                    .attr('font-size', 11);
            }

            chartHandler.legendsWrapper.deleteLegends();

            // Signal to the callee handler that the chart has been successfully loaded. Dashboards use it to determine when all insights are completely loaded.
            if (typeof (chartHandler.loadedCallback) === 'function') {
                chartHandler.loadedCallback();
            }
        };
    });

})();
