/* global describe, it, xit, beforeEach, ChartFeaturesTestUtils */

describe('chart features scatter', function () {

    const chartType = 'scatter';
    const chartVariant = 'normal';

    /* Get tests helpers */
    const { expectIdToBeVisible, expectIdToBeHidden, renderTemplate } = ChartFeaturesTestUtils;

    /* Initialize each test */
    beforeEach(() => {
        ChartFeaturesTestUtils.initEachTest();
        ChartFeaturesTestUtils.initChartType(chartType, chartVariant);
        ChartFeaturesTestUtils.setAxisSpecs(chartType);
    });

    it('has left menu filters dropzone', function () {
        renderTemplate('/templates/simple_report/left-column/left-column.html');

        expectIdToBeVisible('qa_charts_filter-submenu-header');
        expectIdToBeVisible('qa_charts_filters-dropzone');
    })

    it('has left menu dimensions options', function () {
        renderTemplate('/templates/simple_report/left-column/dimensions.html');

        expectIdToBeVisible('qa_charts_tooltip-submenu-header');
        expectIdToBeHidden('qa_charts_animation-submenu-header');
        expectIdToBeHidden('qa_charts_animation-dropzone');
        expectIdToBeHidden('qa_charts_subchart-submenu-header');
        expectIdToBeHidden('qa_charts_subcharts-dropzone');
    })


    it('has axis options', function () {
        ChartFeaturesTestUtils.setXYUaDimensionFromNumericalColumns();
        renderTemplate(`/templates/simple_report/types/definition-${chartType}.html`);

        $('.measure-wrapper')[0].click(); // in X
        expectIdToBeHidden('qa_charts_one-tick-per-bin-select');
        expectIdToBeHidden('qa_charts_handling-empty-bins-select');

        $('.measure-wrapper')[1].click() // in Y
        expectIdToBeHidden('qa_charts_one-tick-per-bin-select');
        expectIdToBeHidden('qa_charts_handling-empty-bins-select');
    })

    it('doesn\'t have along dimension option', function () {
        ChartFeaturesTestUtils.computeAlongDimensionSelectTests(chartType, 'NORMAL', false);
    })

});
