CREATE TABLE signoffs (
    signoff_artifact_id TEXT GENERATED ALWAYS AS ((signoff_json -> 'signoffId' ->> 'artifactId')::TEXT) STORED NOT NULL REFERENCES artifacts,
    signoff_step_id TEXT GENERATED ALWAYS AS ((signoff_json -> 'signoffId' ->> 'stepId')::TEXT) STORED NOT NULL,
    signoff_blueprint_id TEXT GENERATED ALWAYS AS ((signoff_json -> 'configuration' -> 'id' -> 'blueprintVersionId' ->> 'blueprintId')::TEXT) STORED NOT NULL,
    signoff_version_id TEXT GENERATED ALWAYS AS ((signoff_json -> 'configuration' -> 'id' -> 'blueprintVersionId' ->> 'versionId')::TEXT) STORED NOT NULL,
    signoff_json JSONB NOT NULL,
    PRIMARY KEY (signoff_artifact_id, signoff_step_id)
);

CREATE TABLE signoffs_history (
    signoff_artifact_id TEXT GENERATED ALWAYS AS ((signoff_json -> 'signoffId' ->> 'artifactId')::TEXT) STORED NOT NULL,
    signoff_step_id TEXT GENERATED ALWAYS AS ((signoff_json -> 'signoffId' ->> 'stepId')::TEXT) STORED NOT NULL,
    signoff_json JSONB NOT NULL,
    PRIMARY KEY (_revision_id)
) INHERITS (_history_revisions);
CREATE INDEX signoffs_history_artifact_id_step_id_index ON signoffs_history (signoff_artifact_id, signoff_step_id);

CREATE TABLE signoff_configurations (
    signoff_configuration_blueprint_id TEXT GENERATED ALWAYS AS ((signoff_configuration_json -> 'id' -> 'blueprintVersionId' ->> 'blueprintId')::TEXT) STORED NOT NULL,
    signoff_configuration_version_id TEXT GENERATED ALWAYS AS ((signoff_configuration_json -> 'id' -> 'blueprintVersionId' ->> 'versionId')::TEXT) STORED NOT NULL,
    signoff_configuration_step_id TEXT GENERATED ALWAYS AS ((signoff_configuration_json -> 'id' ->> 'stepId')::TEXT) STORED NOT NULL,
    signoff_configuration_json JSONB NOT NULL,
    PRIMARY KEY (signoff_configuration_blueprint_id, signoff_configuration_version_id, signoff_configuration_step_id),
    FOREIGN KEY (signoff_configuration_blueprint_id, signoff_configuration_version_id) REFERENCES blueprint_versions (blueprint_version_blueprint_id, blueprint_version_version_id)
);

CREATE TABLE signoff_configurations_history (
    signoff_configuration_blueprint_id TEXT GENERATED ALWAYS AS ((signoff_configuration_json -> 'id' -> 'blueprintVersionId' ->> 'blueprintId')::TEXT) STORED NOT NULL ,
    signoff_configuration_version_id TEXT GENERATED ALWAYS AS ((signoff_configuration_json -> 'id' -> 'blueprintVersionId' ->> 'versionId')::TEXT) STORED NOT NULL,
    signoff_configuration_step_id TEXT GENERATED ALWAYS AS ((signoff_configuration_json -> 'id' ->> 'stepId')::TEXT) STORED NOT NULL,
    signoff_configuration_json JSONB NOT NULL,
    PRIMARY KEY (_revision_id)
) INHERITS (_history_revisions);
CREATE INDEX signoff_configurations_history_blueprint_id_version_id_index ON signoff_configurations_history (signoff_configuration_blueprint_id, signoff_configuration_version_id, signoff_configuration_step_id);
