/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.netty.handler.codec.socksx.v5;

import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.netty.buffer.ByteBufUtil;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.netty.channel.ChannelHandler;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.netty.handler.codec.EncoderException;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.netty.handler.codec.MessageToByteEncoder;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.netty.handler.codec.socksx.v5.Socks5AddressEncoder;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.netty.handler.codec.socksx.v5.Socks5AddressType;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.netty.handler.codec.socksx.v5.Socks5CommandResponse;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.netty.handler.codec.socksx.v5.Socks5InitialResponse;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.netty.handler.codec.socksx.v5.Socks5Message;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.netty.handler.codec.socksx.v5.Socks5PasswordAuthResponse;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.netty.util.internal.StringUtil;

@ChannelHandler.Sharable
public class Socks5ServerEncoder
extends MessageToByteEncoder<Socks5Message> {
    public static final Socks5ServerEncoder DEFAULT = new Socks5ServerEncoder(Socks5AddressEncoder.DEFAULT);
    private final Socks5AddressEncoder addressEncoder;

    protected Socks5ServerEncoder() {
        this(Socks5AddressEncoder.DEFAULT);
    }

    public Socks5ServerEncoder(Socks5AddressEncoder addressEncoder) {
        this.addressEncoder = ObjectUtil.checkNotNull(addressEncoder, "addressEncoder");
    }

    protected final Socks5AddressEncoder addressEncoder() {
        return this.addressEncoder;
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, Socks5Message msg, ByteBuf out) throws Exception {
        if (msg instanceof Socks5InitialResponse) {
            Socks5ServerEncoder.encodeAuthMethodResponse((Socks5InitialResponse)msg, out);
        } else if (msg instanceof Socks5PasswordAuthResponse) {
            Socks5ServerEncoder.encodePasswordAuthResponse((Socks5PasswordAuthResponse)msg, out);
        } else if (msg instanceof Socks5CommandResponse) {
            this.encodeCommandResponse((Socks5CommandResponse)msg, out);
        } else {
            throw new EncoderException("unsupported message type: " + StringUtil.simpleClassName(msg));
        }
    }

    private static void encodeAuthMethodResponse(Socks5InitialResponse msg, ByteBuf out) {
        out.writeByte(msg.version().byteValue());
        out.writeByte(msg.authMethod().byteValue());
    }

    private static void encodePasswordAuthResponse(Socks5PasswordAuthResponse msg, ByteBuf out) {
        out.writeByte(1);
        out.writeByte(msg.status().byteValue());
    }

    private void encodeCommandResponse(Socks5CommandResponse msg, ByteBuf out) throws Exception {
        out.writeByte(msg.version().byteValue());
        out.writeByte(msg.status().byteValue());
        out.writeByte(0);
        Socks5AddressType bndAddrType = msg.bndAddrType();
        out.writeByte(bndAddrType.byteValue());
        this.addressEncoder.encodeAddress(bndAddrType, msg.bndAddr(), out);
        ByteBufUtil.writeShortBE(out, msg.bndPort());
    }
}

