/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.io.opencensus.implcore.stats;

import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.Maps;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.common.Duration;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.common.Timestamp;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.implcore.stats.MutableAggregation;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.implcore.stats.RecordUtils;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.metrics.data.AttachmentValue;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.stats.Aggregation;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.stats.Measure;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.tags.TagValue;
import java.util.List;
import java.util.Map;

final class IntervalBucket {
    private static final Duration ZERO = Duration.create(0L, 0);
    private final Timestamp start;
    private final Duration duration;
    private final Aggregation aggregation;
    private final Measure measure;
    private final Map<List<TagValue>, MutableAggregation> tagValueAggregationMap = Maps.newHashMap();

    IntervalBucket(Timestamp start, Duration duration, Aggregation aggregation, Measure measure) {
        this.start = Preconditions.checkNotNull(start, "Start");
        this.duration = Preconditions.checkNotNull(duration, "Duration");
        Preconditions.checkArgument(duration.compareTo(ZERO) > 0, "Duration must be positive");
        this.aggregation = Preconditions.checkNotNull(aggregation, "Aggregation");
        this.measure = Preconditions.checkNotNull(measure, "measure");
    }

    Map<List<TagValue>, MutableAggregation> getTagValueAggregationMap() {
        return this.tagValueAggregationMap;
    }

    Timestamp getStart() {
        return this.start;
    }

    void record(List<TagValue> tagValues, double value, Map<String, AttachmentValue> attachments, Timestamp timestamp) {
        if (!this.tagValueAggregationMap.containsKey(tagValues)) {
            this.tagValueAggregationMap.put(tagValues, RecordUtils.createMutableAggregation(this.aggregation, this.measure));
        }
        this.tagValueAggregationMap.get(tagValues).add(value, attachments, timestamp);
    }

    double getFraction(Timestamp now) {
        Duration elapsedTime = now.subtractTimestamp(this.start);
        Preconditions.checkArgument(elapsedTime.compareTo(ZERO) >= 0 && elapsedTime.compareTo(this.duration) < 0, "This bucket must be current.");
        return (double)elapsedTime.toMillis() / (double)this.duration.toMillis();
    }

    void clearStats() {
        this.tagValueAggregationMap.clear();
    }
}

